@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  smack-integration-test startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and SMACK_INTEGRATION_TEST_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS="-enableassertions"

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\smack-integration-test-4.4.0-alpha2.jar;%APP_HOME%\lib\smack-java7-4.4.0-alpha2.jar;%APP_HOME%\lib\smack-tcp-4.4.0-alpha2.jar;%APP_HOME%\lib\smack-omemo-4.4.0-alpha2.jar;%APP_HOME%\lib\smack-omemo-4.4.0-alpha2-tests.jar;%APP_HOME%\lib\smack-openpgp-4.4.0-alpha2.jar;%APP_HOME%\lib\smack-experimental-4.4.0-alpha2.jar;%APP_HOME%\lib\smack-extensions-4.4.0-alpha2.jar;%APP_HOME%\lib\smack-debug-4.4.0-alpha2.jar;%APP_HOME%\lib\reflections-0.9.11.jar;%APP_HOME%\lib\java-pinning-java7-1.1.0-alpha1.jar;%APP_HOME%\lib\junit-vintage-engine-5.4.2.jar;%APP_HOME%\lib\junit-4.12.jar;%APP_HOME%\lib\junit-jupiter-api-5.4.2.jar;%APP_HOME%\lib\smack-resolver-javax-4.4.0-alpha2.jar;%APP_HOME%\lib\smack-sasl-javax-4.4.0-alpha2.jar;%APP_HOME%\lib\smack-im-4.4.0-alpha2.jar;%APP_HOME%\lib\smack-core-4.4.0-alpha2.jar;%APP_HOME%\lib\smack-core-4.4.0-alpha2-tests.jar;%APP_HOME%\lib\pgpainless-core-0.0.1-alpha4.jar;%APP_HOME%\lib\bcpg-jdk15on-1.60.jar;%APP_HOME%\lib\bcprov-jdk15on-1.61.jar;%APP_HOME%\lib\hsluv-0.2.jar;%APP_HOME%\lib\guava-20.0.jar;%APP_HOME%\lib\javassist-3.21.0-GA.jar;%APP_HOME%\lib\java-pinning-jar-1.1.0-alpha1.jar;%APP_HOME%\lib\junit-platform-engine-1.4.2.jar;%APP_HOME%\lib\junit-platform-commons-1.4.2.jar;%APP_HOME%\lib\apiguardian-api-1.0.0.jar;%APP_HOME%\lib\hamcrest-core-1.3.jar;%APP_HOME%\lib\opentest4j-1.1.1.jar;%APP_HOME%\lib\smack-xmlparser-stax-4.4.0-alpha2.jar;%APP_HOME%\lib\smack-xmlparser-xpp3-4.4.0-alpha2.jar;%APP_HOME%\lib\smack-xmlparser-4.4.0-alpha2.jar;%APP_HOME%\lib\jxmpp-jid-0.7.0-alpha5.jar;%APP_HOME%\lib\jxmpp-jid-0.7.0-alpha5-tests.jar;%APP_HOME%\lib\jxmpp-core-0.7.0-alpha5.jar;%APP_HOME%\lib\minidns-core-0.4.0-alpha3.jar;%APP_HOME%\lib\jsr305-3.0.2.jar;%APP_HOME%\lib\xmlunit-assertj-2.6.2.jar;%APP_HOME%\lib\xmlunit-core-2.6.2.jar;%APP_HOME%\lib\assertj-core-3.11.1.jar;%APP_HOME%\lib\java-xmlbuilder-1.2.jar;%APP_HOME%\lib\jxmpp-util-cache-0.7.0-alpha5.jar;%APP_HOME%\lib\xpp3_min-1.1.4c.jar;%APP_HOME%\lib\xpp3-1.1.4c.jar;%APP_HOME%\lib\base64-2.3.8.jar

@rem Execute smack-integration-test
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %SMACK_INTEGRATION_TEST_OPTS%  -classpath "%CLASSPATH%" org.igniterealtime.smack.inttest.SmackIntegrationTestFramework %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable SMACK_INTEGRATION_TEST_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%SMACK_INTEGRATION_TEST_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
