/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.igniterealtime.smack.inttest.AbstractSmackIntTest;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.AbstractSmackLowLevelIntegrationTest;
import org.igniterealtime.smack.inttest.AbstractSmackSpecificLowLevelIntegrationTest;
import org.igniterealtime.smack.inttest.Configuration;
import org.igniterealtime.smack.inttest.FailedTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.SuccessfulTest;
import org.igniterealtime.smack.inttest.TestNotPossible;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.XmppConnectionDescriptor;
import org.igniterealtime.smack.inttest.XmppConnectionManager;
import org.igniterealtime.smack.inttest.annotations.AfterClass;
import org.igniterealtime.smack.inttest.annotations.BeforeClass;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.TLSUtils;
import org.jivesoftware.smack.util.dns.dnsjava.DNSJavaResolver;
import org.jivesoftware.smack.util.dns.javax.JavaxResolver;
import org.jivesoftware.smack.util.dns.minidns.MiniDnsResolver;
import org.jivesoftware.smackx.debugger.EnhancedDebuggerWindow;
import org.jivesoftware.smackx.iqregister.AccountManager;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.MethodParameterScanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;

public class SmackIntegrationTestFramework {
    private static final Logger LOGGER;
    public static boolean SINTTEST_UNIT_TEST;
    protected final Configuration config;
    protected TestRunResult testRunResult;
    private SmackIntegrationTestEnvironment environment;
    protected XmppConnectionManager connectionManager;

    public static void main(String[] args) throws IOException, KeyManagementException, NoSuchAlgorithmException, SmackException, XMPPException, InterruptedException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        int exitStatus;
        Configuration config = Configuration.newConfiguration(args);
        SmackIntegrationTestFramework sinttest = new SmackIntegrationTestFramework(config);
        TestRunResult testRunResult = sinttest.run();
        for (Map.Entry entry : testRunResult.impossibleTestClasses.entrySet()) {
            LOGGER.info("Could not run " + ((Class)entry.getKey()).getName() + " because: " + ((Throwable)entry.getValue()).getLocalizedMessage());
        }
        for (TestNotPossible testNotPossible : testRunResult.impossibleIntegrationTests) {
            LOGGER.info("Could not run " + testNotPossible.concreteTest + " because: " + testNotPossible.testNotPossibleException.getMessage());
        }
        for (SuccessfulTest successfulTest : testRunResult.successfulIntegrationTests) {
            LOGGER.info(successfulTest.concreteTest + " \u2714");
        }
        int successfulTests = testRunResult.successfulIntegrationTests.size();
        int failedTests = testRunResult.failedIntegrationTests.size();
        int availableTests = testRunResult.getNumberOfAvailableTests();
        LOGGER.info("SmackIntegrationTestFramework[" + testRunResult.testRunId + ']' + " finished: " + successfulTests + '/' + availableTests + " [" + failedTests + " failed]");
        if (failedTests > 0) {
            LOGGER.warning("\ud83d\udc80 The following " + failedTests + " tests failed! \ud83d\udc80");
            for (FailedTest failedTest : testRunResult.failedIntegrationTests) {
                Throwable cause = failedTest.failureReason;
                LOGGER.log(Level.SEVERE, failedTest.concreteTest + " failed: " + cause, cause);
            }
            exitStatus = 2;
        } else {
            LOGGER.info("All possible Smack Integration Tests completed successfully. \\o/");
            exitStatus = 0;
        }
        switch (config.debugger) {
            case enhanced: {
                EnhancedDebuggerWindow.getInstance().waitUntilClosed();
                break;
            }
        }
        System.exit(exitStatus);
    }

    public SmackIntegrationTestFramework(Configuration configuration) {
        this.config = configuration;
    }

    public synchronized TestRunResult run() throws KeyManagementException, NoSuchAlgorithmException, SmackException, IOException, XMPPException, InterruptedException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        switch (this.config.dnsResolver) {
            case minidns: {
                MiniDnsResolver.setup();
                break;
            }
            case javax: {
                JavaxResolver.setup();
                break;
            }
            case dnsjava: {
                DNSJavaResolver.setup();
            }
        }
        this.testRunResult = new TestRunResult();
        this.connectionManager = new XmppConnectionManager(this);
        LOGGER.info("SmackIntegrationTestFramework [" + this.testRunResult.testRunId + ']' + ": Starting\nSmack version: " + SmackConfiguration.getVersion());
        if (this.config.debugger != Configuration.Debugger.none) {
            SmackConfiguration.addDisabledSmackClass((String)"org.jivesoftware.smack.debugger.JulDebugger");
            SmackConfiguration.DEBUG = true;
        }
        if (this.config.replyTimeout > 0) {
            SmackConfiguration.setDefaultReplyTimeout((int)this.config.replyTimeout);
        }
        if (this.config.securityMode != ConnectionConfiguration.SecurityMode.required && this.config.accountRegistration == Configuration.AccountRegistration.inBandRegistration) {
            AccountManager.sensitiveOperationOverInsecureConnectionDefault((boolean)true);
        }
        String[] testPackages = this.config.testPackages == null || this.config.testPackages.isEmpty() ? new String[]{"org.jivesoftware.smackx", "org.jivesoftware.smack"} : this.config.testPackages.toArray(new String[this.config.testPackages.size()]);
        Reflections reflections = new Reflections(new Object[]{testPackages, new SubTypesScanner(), new TypeAnnotationsScanner(), new MethodAnnotationsScanner(), new MethodParameterScanner()});
        Set inttestClasses = reflections.getSubTypesOf(AbstractSmackIntegrationTest.class);
        Set lowLevelInttestClasses = reflections.getSubTypesOf(AbstractSmackLowLevelIntegrationTest.class);
        HashSet<Class<? extends AbstractSmackIntTest>> classes = new HashSet<Class<? extends AbstractSmackIntTest>>(inttestClasses.size() + lowLevelInttestClasses.size());
        classes.addAll(inttestClasses);
        classes.addAll(lowLevelInttestClasses);
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            Class clazz = (Class)it.next();
            if (!Modifier.isAbstract(clazz.getModifiers())) continue;
            it.remove();
        }
        if (classes.isEmpty()) {
            throw new IllegalStateException("No test classes found");
        }
        LOGGER.info("SmackIntegrationTestFramework [" + this.testRunResult.testRunId + "]: Finished scanning for tests, preparing environment");
        this.environment = this.prepareEnvironment();
        try {
            this.runTests(classes);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Unexpected abort because runTests() threw throwable", t);
            throw t;
        }
        finally {
            this.connectionManager.disconnectAndCleanup();
        }
        return this.testRunResult;
    }

    private void runTests(Set<Class<? extends AbstractSmackIntTest>> classes) throws InterruptedException, InstantiationException, IllegalAccessException, IllegalArgumentException, SmackException, IOException, XMPPException {
        ArrayList<PreparedTest> tests = new ArrayList<PreparedTest>(classes.size());
        int numberOfAvailableTests = 0;
        for (Class<? extends AbstractSmackIntTest> testClass : classes) {
            TestType testType;
            AbstractSmackIntTest test;
            Constructor<? extends AbstractSmackIntTest> cons;
            DisabledTestClass disabledTestClass;
            String testClassName = testClass.getName();
            if (!SINTTEST_UNIT_TEST && testClassName.startsWith("org.igniterealtime.smack.inttest.unittest")) {
                LOGGER.warning("Skipping integration test '" + testClassName + "' from src/test classpath (should not be in classpath)");
                continue;
            }
            if (this.config.enabledTests != null && !SmackIntegrationTestFramework.isInSet(testClass, this.config.enabledTests)) {
                disabledTestClass = new DisabledTestClass(testClass, "Skipping test class " + testClassName + " because it is not enabled");
                this.testRunResult.disabledTestClasses.add(disabledTestClass);
                continue;
            }
            if (SmackIntegrationTestFramework.isInSet(testClass, this.config.disabledTests)) {
                disabledTestClass = new DisabledTestClass(testClass, "Skipping test class " + testClassName + " because it is disalbed");
                this.testRunResult.disabledTestClasses.add(disabledTestClass);
                continue;
            }
            try {
                cons = testClass.getConstructor(SmackIntegrationTestEnvironment.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IllegalArgumentException("Smack Integration Test class does not declare the correct constructor. Is a public Constructor(SmackIntegrationTestEnvironment) missing?", e);
            }
            Method[] testClassMethods = testClass.getMethods();
            ArrayList<Method> smackIntegrationTestMethods = new ArrayList<Method>(testClassMethods.length);
            for (Method method : testClassMethods) {
                if (!method.isAnnotationPresent(SmackIntegrationTest.class)) continue;
                smackIntegrationTestMethods.add(method);
            }
            if (smackIntegrationTestMethods.isEmpty()) {
                LOGGER.warning("No Smack integration test methods found in " + testClass);
                continue;
            }
            try {
                test = cons.newInstance(this.environment);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                SmackIntegrationTestFramework.throwFatalException(cause);
                this.testRunResult.impossibleTestClasses.put(testClass, cause);
                continue;
            }
            Class specificLowLevelConnectionClass = null;
            if (test instanceof AbstractSmackSpecificLowLevelIntegrationTest) {
                AbstractSmackSpecificLowLevelIntegrationTest specificLowLevelTest = (AbstractSmackSpecificLowLevelIntegrationTest)test;
                specificLowLevelConnectionClass = specificLowLevelTest.getConnectionClass();
                testType = TestType.SpecificLowLevel;
            } else if (test instanceof AbstractSmackLowLevelIntegrationTest) {
                testType = TestType.LowLevel;
            } else if (test instanceof AbstractSmackIntegrationTest) {
                testType = TestType.Normal;
            } else {
                throw new AssertionError();
            }
            for (Method method : smackIntegrationTestMethods) {
                Class<?> retClass = method.getReturnType();
                if (!retClass.equals(Void.TYPE)) {
                    throw new IllegalStateException("SmackIntegrationTest annotation on" + method + " that does not return void");
                }
                switch (testType) {
                    case Normal: {
                        Class<?>[] parameterTypes = method.getParameterTypes();
                        if (parameterTypes.length <= 0) break;
                        throw new IllegalStateException("SmackIntegrationTest annotaton on " + method + " that takes arguments ");
                    }
                    case LowLevel: {
                        SmackIntegrationTestFramework.verifyLowLevelTestMethod(method, AbstractXMPPConnection.class);
                        break;
                    }
                    case SpecificLowLevel: {
                        SmackIntegrationTestFramework.verifyLowLevelTestMethod(method, specificLowLevelConnectionClass);
                    }
                }
            }
            Iterator it = smackIntegrationTestMethods.iterator();
            while (it.hasNext()) {
                DisabledTest disabledTest;
                Method method;
                method = (Method)it.next();
                String methodName = method.getName();
                if (this.config.enabledTests != null && !this.config.enabledTests.contains(methodName) && !SmackIntegrationTestFramework.isInSet(testClass, this.config.enabledTests)) {
                    disabledTest = new DisabledTest(method, "Skipping test method " + (String)methodName + " because it is not enabled");
                    this.testRunResult.disabledTests.add(disabledTest);
                    it.remove();
                    continue;
                }
                if (this.config.disabledTests == null || !this.config.disabledTests.contains(methodName)) continue;
                disabledTest = new DisabledTest(method, "Skipping test method " + (String)methodName + " because it is disabled");
                this.testRunResult.disabledTests.add(disabledTest);
                it.remove();
            }
            if (smackIntegrationTestMethods.isEmpty()) {
                LOGGER.info("All tests in " + testClassName + " are disabled");
                continue;
            }
            ArrayList<ConcreteTest> concreteTests = new ArrayList<ConcreteTest>(smackIntegrationTestMethods.size());
            for (Method testMethod : smackIntegrationTestMethods) {
                block7 : switch (testType) {
                    case Normal: {
                        ConcreteTest.Executor concreteTestExecutor = () -> testMethod.invoke((Object)test, new Object[0]);
                        ConcreteTest concreteTest = new ConcreteTest(testType, testMethod, concreteTestExecutor, new String[0]);
                        concreteTests.add(concreteTest);
                        break;
                    }
                    case LowLevel: 
                    case SpecificLowLevel: {
                        LowLevelTestMethod lowLevelTestMethod = new LowLevelTestMethod(testMethod);
                        switch (testType) {
                            case LowLevel: {
                                List<ConcreteTest> concreteLowLevelTests = this.invokeLowLevel(lowLevelTestMethod, (AbstractSmackLowLevelIntegrationTest)test);
                                concreteTests.addAll(concreteLowLevelTests);
                                break block7;
                            }
                            case SpecificLowLevel: {
                                ConcreteTest.Executor concreteTestExecutor = () -> SmackIntegrationTestFramework.invokeSpecificLowLevel(lowLevelTestMethod, (AbstractSmackSpecificLowLevelIntegrationTest)test);
                                ConcreteTest concreteTest = new ConcreteTest(testType, testMethod, concreteTestExecutor, new String[0]);
                                concreteTests.add(concreteTest);
                                break block7;
                            }
                        }
                        throw new AssertionError();
                    }
                }
            }
            PreparedTest preparedTest = new PreparedTest(test, concreteTests);
            tests.add(preparedTest);
            numberOfAvailableTests += concreteTests.size();
        }
        StringBuilder sb = new StringBuilder(1024);
        sb.append("Smack Integration Test Framework\n");
        sb.append("################################\n");
        if (this.config.verbose) {
            sb.append('\n');
            if (!this.testRunResult.disabledTestClasses.isEmpty()) {
                sb.append("The following test classes are disabled:\n");
                for (DisabledTestClass disabledTestClass : this.testRunResult.disabledTestClasses) {
                    disabledTestClass.appendTo(sb).append('\n');
                }
            }
            if (!this.testRunResult.disabledTests.isEmpty()) {
                sb.append("The following tests are disabled:\n");
                for (DisabledTest disabledTest : this.testRunResult.disabledTests) {
                    disabledTest.appendTo(sb).append('\n');
                }
            }
            sb.append('\n');
        }
        sb.append("Available tests: ").append(numberOfAvailableTests).append("(#-classes: ").append(this.testRunResult.disabledTestClasses.size()).append(", #-tests: ").append(this.testRunResult.disabledTests.size()).append(")\n");
        LOGGER.info(sb.toString());
        for (PreparedTest test : tests) {
            test.run();
        }
        assert (numberOfAvailableTests == this.testRunResult.getNumberOfAvailableTests());
    }

    private void runConcreteTest(ConcreteTest concreteTest) throws InterruptedException, XMPPException, IOException, SmackException {
        LOGGER.info(concreteTest + " Start");
        long testStart = System.currentTimeMillis();
        try {
            concreteTest.executor.execute();
            long testEnd = System.currentTimeMillis();
            LOGGER.info(concreteTest + " Success");
            this.testRunResult.successfulIntegrationTests.add(new SuccessfulTest(concreteTest, testStart, testEnd, null));
        }
        catch (InvocationTargetException e) {
            long testEnd = System.currentTimeMillis();
            Throwable cause = e.getCause();
            if (cause instanceof TestNotPossibleException) {
                LOGGER.info(concreteTest + " is not possible");
                this.testRunResult.impossibleIntegrationTests.add(new TestNotPossible(concreteTest, testStart, testEnd, null, (TestNotPossibleException)cause));
                return;
            }
            Throwable nonFatalFailureReason = cause instanceof AssertionError ? cause : SmackIntegrationTestFramework.throwFatalException(cause);
            this.testRunResult.failedIntegrationTests.add(new FailedTest(concreteTest, testStart, testEnd, null, nonFatalFailureReason));
            LOGGER.log(Level.SEVERE, concreteTest + " Failed", e);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void verifyLowLevelTestMethod(Method method, Class<? extends AbstractXMPPConnection> connectionClass) {
        if (!SmackIntegrationTestFramework.testMethodParametersIsListOfConnections(method, connectionClass) && !SmackIntegrationTestFramework.testMethodParametersVarargsConnections(method, connectionClass)) {
            throw new IllegalArgumentException(method + " is not a valid low level test method");
        }
    }

    private List<ConcreteTest> invokeLowLevel(LowLevelTestMethod lowLevelTestMethod, AbstractSmackLowLevelIntegrationTest test) {
        Collection<XmppConnectionDescriptor<AbstractXMPPConnection, ConnectionConfiguration, ConnectionConfiguration.Builder<?, ?>>> connectionDescriptors;
        if (lowLevelTestMethod.smackIntegrationTestAnnotation.onlyDefaultConnectionType()) {
            XmppConnectionDescriptor<? extends AbstractXMPPConnection, ? extends ConnectionConfiguration, ? extends ConnectionConfiguration.Builder<?, ?>> defaultConnectionDescriptor = this.connectionManager.getDefaultConnectionDescriptor();
            connectionDescriptors = Collections.singleton(defaultConnectionDescriptor);
        } else {
            connectionDescriptors = this.connectionManager.getConnectionDescriptors();
        }
        ArrayList<ConcreteTest> resultingConcreteTests = new ArrayList<ConcreteTest>(connectionDescriptors.size());
        for (XmppConnectionDescriptor<AbstractXMPPConnection, ConnectionConfiguration, ConnectionConfiguration.Builder<?, ?>> connectionDescriptor : connectionDescriptors) {
            DisabledTest disabledTest;
            String connectionNick = connectionDescriptor.getNickname();
            if (this.config.enabledConnections != null && !this.config.enabledConnections.contains(connectionNick)) {
                disabledTest = new DisabledTest(lowLevelTestMethod.testMethod, "Not creating test for " + lowLevelTestMethod + " with connection '" + connectionNick + "', as this connection type is not enabled");
                this.testRunResult.disabledTests.add(disabledTest);
                continue;
            }
            if (this.config.disabledConnections != null && this.config.disabledConnections.contains(connectionNick)) {
                disabledTest = new DisabledTest(lowLevelTestMethod.testMethod, "Not creating test for " + lowLevelTestMethod + " with connection '" + connectionNick + ", as this connection type is disabled");
                this.testRunResult.disabledTests.add(disabledTest);
                continue;
            }
            Class<? extends AbstractXMPPConnection> connectionClass = connectionDescriptor.getConnectionClass();
            ConcreteTest.Executor executor = () -> lowLevelTestMethod.invoke(test, connectionClass);
            ConcreteTest concreteTest = new ConcreteTest(TestType.LowLevel, lowLevelTestMethod.testMethod, executor, new String[]{connectionClass.getSimpleName()});
            resultingConcreteTests.add(concreteTest);
        }
        return resultingConcreteTests;
    }

    private static <C extends AbstractXMPPConnection> void invokeSpecificLowLevel(LowLevelTestMethod testMethod, AbstractSmackSpecificLowLevelIntegrationTest<C> test) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InterruptedException, SmackException, IOException, XMPPException {
        if (testMethod.smackIntegrationTestAnnotation.onlyDefaultConnectionType()) {
            throw new IllegalArgumentException("SpecificLowLevelTests must not have set onlyDefaultConnectionType");
        }
        Class<C> connectionClass = test.getConnectionClass();
        testMethod.invoke(test, connectionClass);
    }

    protected SmackIntegrationTestEnvironment prepareEnvironment() throws SmackException, IOException, XMPPException, InterruptedException, KeyManagementException, NoSuchAlgorithmException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.connectionManager.prepareEnvironment();
    }

    static XMPPTCPConnectionConfiguration.Builder getConnectionConfigurationBuilder(Configuration config) {
        XMPPTCPConnectionConfiguration.Builder builder = XMPPTCPConnectionConfiguration.builder();
        config.configurationApplier.applyConfigurationTo((ConnectionConfiguration.Builder<?, ?>)builder);
        return builder;
    }

    private static Exception throwFatalException(Throwable e) throws Error, SmackException.NoResponseException, InterruptedException {
        if (e instanceof InterruptedException) {
            throw (InterruptedException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        return (Exception)e;
    }

    private static boolean isInSet(Class<?> clz, Set<String> classes) {
        if (classes == null) {
            return false;
        }
        String className = clz.getName();
        String unqualifiedClassName = clz.getSimpleName();
        return classes.contains(className) || classes.contains(unqualifiedClassName);
    }

    private static Method getSinttestSpecialMethod(Class<? extends AbstractSmackIntTest> testClass, Class<? extends Annotation> annotation) {
        Set specialClassMethods = ReflectionUtils.getAllMethods(testClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(annotation), ReflectionUtils.withReturnType(Void.TYPE), ReflectionUtils.withParametersCount((int)0), ReflectionUtils.withModifier((int)1)});
        Set allSpecialClassMethods = ReflectionUtils.getAllMethods(testClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(annotation)});
        allSpecialClassMethods.removeAll(specialClassMethods);
        if (!allSpecialClassMethods.isEmpty()) {
            throw new IllegalArgumentException(annotation + " methods with wrong signature found");
        }
        if (specialClassMethods.size() == 1) {
            return (Method)specialClassMethods.iterator().next();
        }
        if (specialClassMethods.size() > 1) {
            throw new IllegalArgumentException("Only one @BeforeClass method allowed");
        }
        return null;
    }

    private static boolean testMethodParametersIsListOfConnections(Method testMethod) {
        return SmackIntegrationTestFramework.testMethodParametersIsListOfConnections(testMethod, AbstractXMPPConnection.class);
    }

    static boolean testMethodParametersIsListOfConnections(Method testMethod, Class<? extends AbstractXMPPConnection> connectionClass) {
        Type[] parameterTypes = testMethod.getGenericParameterTypes();
        if (parameterTypes.length != 1) {
            return false;
        }
        Class<?> soleParameter = testMethod.getParameterTypes()[0];
        if (!Collection.class.isAssignableFrom(soleParameter)) {
            return false;
        }
        ParameterizedType soleParameterizedType = (ParameterizedType)parameterTypes[0];
        Type[] actualTypeArguments = soleParameterizedType.getActualTypeArguments();
        if (actualTypeArguments.length != 1) {
            return false;
        }
        Type soleActualTypeArgument = actualTypeArguments[0];
        if (!(soleActualTypeArgument instanceof Class)) {
            return false;
        }
        Class soleActualTypeArgumentAsClass = (Class)soleActualTypeArgument;
        return connectionClass.isAssignableFrom(soleActualTypeArgumentAsClass);
    }

    static boolean testMethodParametersVarargsConnections(Method testMethod, Class<? extends AbstractXMPPConnection> connectionClass) {
        Class<?>[] parameterTypes;
        for (Class<? extends AbstractXMPPConnection> clazz : parameterTypes = testMethod.getParameterTypes()) {
            if (clazz.isAssignableFrom(connectionClass)) continue;
            return false;
        }
        return true;
    }

    static {
        TLSUtils.setDefaultTrustStoreTypeToJksIfRequired();
        LOGGER = Logger.getLogger(SmackIntegrationTestFramework.class.getName());
        SINTTEST_UNIT_TEST = false;
    }

    private final class LowLevelTestMethod {
        private final Method testMethod;
        private final SmackIntegrationTest smackIntegrationTestAnnotation;
        private final boolean parameterListOfConnections;

        private LowLevelTestMethod(Method testMethod) {
            this.testMethod = testMethod;
            this.smackIntegrationTestAnnotation = testMethod.getAnnotation(SmackIntegrationTest.class);
            assert (this.smackIntegrationTestAnnotation != null);
            this.parameterListOfConnections = SmackIntegrationTestFramework.testMethodParametersIsListOfConnections(testMethod);
        }

        private void invoke(AbstractSmackLowLevelIntegrationTest test, Class<? extends AbstractXMPPConnection> connectionClass) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InterruptedException, SmackException, IOException, XMPPException {
            int connectionCount;
            if (this.parameterListOfConnections) {
                connectionCount = this.smackIntegrationTestAnnotation.connectionCount();
                if (connectionCount < 1) {
                    throw new IllegalArgumentException(this.testMethod + " is annotated to use less than one connection ('" + connectionCount + ')');
                }
            } else {
                connectionCount = this.testMethod.getParameterCount();
            }
            List<? extends AbstractXMPPConnection> connections = SmackIntegrationTestFramework.this.connectionManager.constructConnectedConnections(connectionClass, connectionCount);
            if (this.parameterListOfConnections) {
                this.testMethod.invoke((Object)test, connections);
            } else {
                Object[] connectionsArray = new Object[connectionCount];
                for (int i = 0; i < connectionsArray.length; ++i) {
                    connectionsArray[i] = connections.remove(0);
                }
                this.testMethod.invoke((Object)test, connectionsArray);
            }
        }

        public String toString() {
            return this.testMethod.toString();
        }
    }

    public static final class DisabledTest {
        private final Method method;
        private final String reason;

        private DisabledTest(Method method, String reason) {
            this.method = method;
            this.reason = reason;
        }

        public Method getMethod() {
            return this.method;
        }

        public String getReason() {
            return this.reason;
        }

        public StringBuilder appendTo(StringBuilder sb) {
            return sb.append("Disabled ").append(this.method).append(" because ").append(this.reason);
        }
    }

    public static final class DisabledTestClass {
        private final Class<? extends AbstractSmackIntTest> testClass;
        private final String reason;

        private DisabledTestClass(Class<? extends AbstractSmackIntTest> testClass, String reason) {
            this.testClass = testClass;
            this.reason = reason;
        }

        public Class<? extends AbstractSmackIntTest> getTestClass() {
            return this.testClass;
        }

        public String getReason() {
            return this.reason;
        }

        public StringBuilder appendTo(StringBuilder sb) {
            return sb.append("Disabled ").append(this.testClass).append(" because ").append(this.reason);
        }
    }

    static final class ConcreteTest {
        private final TestType testType;
        private final Method method;
        private final Executor executor;
        private final String[] subdescriptons;
        private transient String stringCache;

        private ConcreteTest(TestType testType, Method method, Executor executor, String ... subdescriptions) {
            this.testType = testType;
            this.method = method;
            this.executor = executor;
            this.subdescriptons = subdescriptions;
        }

        public String toString() {
            if (this.stringCache != null) {
                return this.stringCache;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.method.getDeclaringClass().getSimpleName()).append('.').append(this.method.getName()).append(" (").append(this.testType.name());
            if (this.subdescriptons != null && this.subdescriptons.length > 0) {
                sb.append(", ");
                StringUtils.appendTo(Arrays.asList(this.subdescriptons), (StringBuilder)sb);
            }
            sb.append(')');
            this.stringCache = sb.toString();
            return this.stringCache;
        }

        private static interface Executor {
            public void execute() throws IllegalAccessException, InterruptedException, InvocationTargetException, XMPPException, IOException, SmackException;
        }
    }

    final class PreparedTest {
        private final AbstractSmackIntTest test;
        private final List<ConcreteTest> concreteTests;
        private final Method beforeClassMethod;
        private final Method afterClassMethod;

        private PreparedTest(AbstractSmackIntTest test, List<ConcreteTest> concreteTests) {
            this.test = test;
            this.concreteTests = concreteTests;
            Class<?> testClass = test.getClass();
            this.beforeClassMethod = SmackIntegrationTestFramework.getSinttestSpecialMethod(testClass, BeforeClass.class);
            this.afterClassMethod = SmackIntegrationTestFramework.getSinttestSpecialMethod(testClass, AfterClass.class);
        }

        public void run() throws InterruptedException, XMPPException, IOException, SmackException {
            try {
                this.executeSinttestSpecialMethod(this.beforeClassMethod);
                for (ConcreteTest concreteTest : this.concreteTests) {
                    SmackIntegrationTestFramework.this.runConcreteTest(concreteTest);
                }
            }
            finally {
                this.executeSinttestSpecialMethod(this.afterClassMethod);
            }
        }

        private void executeSinttestSpecialMethod(Method method) {
            if (method == null) {
                return;
            }
            try {
                method.invoke((Object)this.test, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.log(Level.SEVERE, "Exception executing " + method, e);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static final class TestRunResult {
        public final String testRunId = StringUtils.insecureRandomString((int)5).toLowerCase(Locale.US);
        private final List<SuccessfulTest> successfulIntegrationTests = Collections.synchronizedList(new LinkedList());
        private final List<FailedTest> failedIntegrationTests = Collections.synchronizedList(new LinkedList());
        private final List<TestNotPossible> impossibleIntegrationTests = Collections.synchronizedList(new LinkedList());
        private final List<DisabledTestClass> disabledTestClasses = Collections.synchronizedList(new ArrayList());
        private final List<DisabledTest> disabledTests = Collections.synchronizedList(new ArrayList());
        private final Map<Class<? extends AbstractSmackIntTest>, Throwable> impossibleTestClasses = new HashMap<Class<? extends AbstractSmackIntTest>, Throwable>();

        TestRunResult() {
        }

        public String getTestRunId() {
            return this.testRunId;
        }

        public int getNumberOfAvailableTests() {
            return this.successfulIntegrationTests.size() + this.failedIntegrationTests.size() + this.impossibleIntegrationTests.size();
        }

        public List<SuccessfulTest> getSuccessfulTests() {
            return Collections.unmodifiableList(this.successfulIntegrationTests);
        }

        public List<FailedTest> getFailedTests() {
            return Collections.unmodifiableList(this.failedIntegrationTests);
        }

        public List<TestNotPossible> getNotPossibleTests() {
            return Collections.unmodifiableList(this.impossibleIntegrationTests);
        }

        public Map<Class<? extends AbstractSmackIntTest>, Throwable> getImpossibleTestClasses() {
            return Collections.unmodifiableMap(this.impossibleTestClasses);
        }
    }

    static enum AccountNum {
        One,
        Two,
        Three;

    }

    public static enum TestType {
        Normal,
        LowLevel,
        SpecificLowLevel;

    }
}

