/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import org.igniterealtime.smack.inttest.AbstractSmackLowLevelIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.sasl.SASLError;
import org.jivesoftware.smack.sasl.SASLErrorException;
import org.jivesoftware.smack.sasl.packet.SaslNonza;
import org.jivesoftware.smack.util.StringUtils;
import org.junit.jupiter.api.Assertions;

public class LoginIntegrationTest
extends AbstractSmackLowLevelIntegrationTest {
    public LoginIntegrationTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
    }

    @SmackIntegrationTest
    public void testInvalidLogin() throws SmackException, IOException, XMPPException, InterruptedException, KeyManagementException, NoSuchAlgorithmException {
        String nonExistentUserString = StringUtils.insecureRandomString((int)24);
        String invalidPassword = "invalidPassword";
        AbstractXMPPConnection connection = this.getUnconnectedConnection();
        connection.connect();
        SASLErrorException saslErrorException = (SASLErrorException)Assertions.assertThrows(SASLErrorException.class, () -> connection.login((CharSequence)nonExistentUserString, "invalidPassword"));
        SaslNonza.SASLFailure saslFailure = saslErrorException.getSASLFailure();
        Assertions.assertEquals((Object)SASLError.not_authorized, (Object)saslFailure.getSASLError());
    }
}

