/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mood;

import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.annotations.AfterClass;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.util.IntegrationTestRosterUtil;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.mood.Mood;
import org.jivesoftware.smackx.mood.MoodManager;
import org.jivesoftware.smackx.pep.PepEventListener;

public class MoodIntegrationTest
extends AbstractSmackIntegrationTest {
    private final MoodManager mm1;
    private final MoodManager mm2;

    public MoodIntegrationTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
        this.mm1 = MoodManager.getInstanceFor((XMPPConnection)this.conOne);
        this.mm2 = MoodManager.getInstanceFor((XMPPConnection)this.conTwo);
    }

    @SmackIntegrationTest
    public void test() throws Exception {
        IntegrationTestRosterUtil.ensureBothAccountsAreSubscribedToEachOther(this.conOne, this.conTwo, this.timeout);
        SimpleResultSyncPoint moodReceived = new SimpleResultSyncPoint();
        PepEventListener moodListener = (jid, moodElement, id, message) -> {
            if (moodElement.getMood() == Mood.satisfied) {
                moodReceived.signal();
            }
        };
        this.mm2.addMoodListener(moodListener);
        try {
            this.mm1.setMood(Mood.satisfied);
            moodReceived.waitForResult(this.timeout);
        }
        finally {
            this.mm2.removeMoodListener(moodListener);
        }
    }

    @AfterClass
    public void unsubscribe() throws SmackException.NotLoggedInException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        IntegrationTestRosterUtil.ensureBothAccountsAreNotInEachOthersRoster(this.conOne, this.conTwo);
    }
}

