/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox_im;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.AfterClass;
import org.igniterealtime.smack.inttest.annotations.BeforeClass;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.ox.AbstractOpenPgpIntegrationTest;
import org.jivesoftware.smackx.ox.OpenPgpContact;
import org.jivesoftware.smackx.ox.OpenPgpManager;
import org.jivesoftware.smackx.ox.crypto.OpenPgpProvider;
import org.jivesoftware.smackx.ox.crypto.PainlessOpenPgpProvider;
import org.jivesoftware.smackx.ox.element.SigncryptElement;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpStore;
import org.jivesoftware.smackx.ox.store.filebased.FileBasedOpenPgpStore;
import org.jivesoftware.smackx.ox_im.OXInstantMessagingManager;
import org.jivesoftware.smackx.ox_im.OxMessageListener;
import org.junit.jupiter.api.Assertions;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;

public class OXInstantMessagingIntegrationTest
extends AbstractOpenPgpIntegrationTest {
    private static final String sessionId = StringUtils.randomString((int)10);
    private static final File tempDir = FileUtils.getTempDirectory();
    private static final File aliceStorePath = new File(tempDir, "basic_ox_messaging_test_alice_" + sessionId);
    private static final File bobStorePath = new File(tempDir, "basic_ox_messaging_test_bob_" + sessionId);
    private OpenPgpV4Fingerprint aliceFingerprint = null;
    private OpenPgpV4Fingerprint bobFingerprint = null;
    private OpenPgpManager aliceOpenPgp;
    private OpenPgpManager bobOpenPgp;

    public OXInstantMessagingIntegrationTest(SmackIntegrationTestEnvironment environment) throws XMPPException.XMPPErrorException, InterruptedException, SmackException.NotConnectedException, TestNotPossibleException, SmackException.NoResponseException {
        super(environment);
    }

    @BeforeClass
    @AfterClass
    public static void deleteStore() throws IOException {
        FileUtils.deleteDirectory((File)aliceStorePath);
        FileUtils.deleteDirectory((File)bobStorePath);
    }

    @SmackIntegrationTest
    public void basicInstantMessagingTest() throws Exception {
        LOGGER.log(Level.INFO, aliceStorePath.getAbsolutePath() + " " + bobStorePath.getAbsolutePath());
        final SimpleResultSyncPoint bobReceivedMessage = new SimpleResultSyncPoint();
        String body = "Writing integration tests is an annoying task, but it has to be done, so lets do it!!!";
        FileBasedOpenPgpStore aliceStore = new FileBasedOpenPgpStore(aliceStorePath);
        aliceStore.setKeyRingProtector((SecretKeyRingProtector)new UnprotectedKeysProtector());
        FileBasedOpenPgpStore bobStore = new FileBasedOpenPgpStore(bobStorePath);
        bobStore.setKeyRingProtector((SecretKeyRingProtector)new UnprotectedKeysProtector());
        PainlessOpenPgpProvider aliceProvider = new PainlessOpenPgpProvider(this.aliceConnection, (OpenPgpStore)aliceStore);
        PainlessOpenPgpProvider bobProvider = new PainlessOpenPgpProvider(this.bobConnection, (OpenPgpStore)bobStore);
        this.aliceOpenPgp = OpenPgpManager.getInstanceFor((XMPPConnection)this.aliceConnection);
        this.bobOpenPgp = OpenPgpManager.getInstanceFor((XMPPConnection)this.bobConnection);
        OXInstantMessagingManager aliceInstantMessaging = OXInstantMessagingManager.getInstanceFor((XMPPConnection)this.aliceConnection);
        OXInstantMessagingManager bobInstantMessaging = OXInstantMessagingManager.getInstanceFor((XMPPConnection)this.bobConnection);
        bobInstantMessaging.addOxMessageListener(new OxMessageListener(){

            public void newIncomingOxMessage(OpenPgpContact contact, Message originalMessage, SigncryptElement decryptedPayload, OpenPgpMetadata metadata) {
                if (((Message.Body)decryptedPayload.getExtension("jabber:client")).getMessage().equals("Writing integration tests is an annoying task, but it has to be done, so lets do it!!!")) {
                    bobReceivedMessage.signal();
                } else {
                    bobReceivedMessage.signalFailure();
                }
            }
        });
        this.aliceOpenPgp.setOpenPgpProvider((OpenPgpProvider)aliceProvider);
        this.bobOpenPgp.setOpenPgpProvider((OpenPgpProvider)bobProvider);
        this.aliceFingerprint = this.aliceOpenPgp.generateAndImportKeyPair(this.alice);
        this.bobFingerprint = this.bobOpenPgp.generateAndImportKeyPair(this.bob);
        this.aliceOpenPgp.announceSupportAndPublish();
        this.bobOpenPgp.announceSupportAndPublish();
        OpenPgpContact bobForAlice = this.aliceOpenPgp.getOpenPgpContact(this.bob.asEntityBareJidIfPossible());
        OpenPgpContact aliceForBob = this.bobOpenPgp.getOpenPgpContact(this.alice.asEntityBareJidIfPossible());
        bobForAlice.updateKeys(this.aliceConnection);
        Assertions.assertFalse((boolean)bobForAlice.isTrusted(this.bobFingerprint));
        Assertions.assertFalse((boolean)aliceForBob.isTrusted(this.aliceFingerprint));
        bobForAlice.trust(this.bobFingerprint);
        aliceForBob.trust(this.aliceFingerprint);
        Assertions.assertTrue((boolean)bobForAlice.isTrusted(this.bobFingerprint));
        Assertions.assertTrue((boolean)aliceForBob.isTrusted(this.aliceFingerprint));
        aliceInstantMessaging.sendOxMessage(bobForAlice, (CharSequence)"Writing integration tests is an annoying task, but it has to be done, so lets do it!!!");
        bobReceivedMessage.waitForResult(this.timeout);
    }
}

