/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smack.util.BooleansUtils;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.jiveproperties.JivePropertiesManager;
import org.jivesoftware.smackx.jiveproperties.packet.JivePropertiesExtension;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public class XmppConnectionStressTest {
    private static final String MESSAGE_NUMBER_PROPERTY = "message-number";
    private final Configuration configuration;
    private volatile long waitStart;

    public XmppConnectionStressTest(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - void declaration
     */
    public void run(final List<? extends XMPPConnection> connections, long replyTimeoutMillis) throws InterruptedException, StressTestFailedException.NotAllMessagesReceivedException, StressTestFailedException.ErrorsWhileSendingOrReceivingException {
        long l;
        boolean bl;
        MultiMap messages = new MultiMap();
        Random random = new Random(this.configuration.seed);
        ConcurrentHashMap sendExceptions = new ConcurrentHashMap();
        final ConcurrentHashMap receiveExceptions = new ConcurrentHashMap();
        this.waitStart = -1L;
        for (XMPPConnection xMPPConnection : connections) {
            MultiMap toConnectionMessages = new MultiMap();
            for (XMPPConnection xMPPConnection2 : connections) {
                for (int i = 0; i < this.configuration.messagesPerConnection; ++i) {
                    MessageBuilder messageBuilder = xMPPConnection.getStanzaFactory().buildMessageStanza();
                    messageBuilder.to((Jid)xMPPConnection2.getUser());
                    int payloadChunkCount = random.nextInt(this.configuration.maxPayloadChunks) + 1;
                    for (int c = 0; c < payloadChunkCount; ++c) {
                        int payloadChunkSize = random.nextInt(this.configuration.maxPayloadChunkSize) + 1;
                        String payloadCunk = StringUtils.randomString((int)payloadChunkSize, (Random)random);
                        JivePropertiesManager.addProperty((StanzaBuilder)messageBuilder, (String)("payload-chunk-" + c), (Object)payloadCunk);
                    }
                    JivePropertiesManager.addProperty((StanzaBuilder)messageBuilder, (String)MESSAGE_NUMBER_PROPERTY, (Object)i);
                    Message message = messageBuilder.build();
                    toConnectionMessages.put((Object)xMPPConnection2, (Object)message);
                }
            }
            if (this.configuration.intermixMessages) {
                while (!toConnectionMessages.isEmpty()) {
                    void var12_23;
                    int n = random.nextInt(connections.size());
                    Object var12_22 = null;
                    while (var12_23 == null) {
                        void var11_14;
                        XMPPConnection toConnection = connections.get((int)var11_14);
                        Message message = (Message)toConnectionMessages.getFirst((Object)toConnection);
                        var11_14 = (var11_14 + true) % connections.size();
                    }
                    messages.put((Object)xMPPConnection, (Object)var12_23);
                }
                continue;
            }
            for (XMPPConnection xMPPConnection3 : connections) {
                for (Message message : toConnectionMessages.getAll((Object)xMPPConnection3)) {
                    messages.put((Object)xMPPConnection, (Object)message);
                }
            }
        }
        final Semaphore receivedSemaphore = new Semaphore(-connections.size() + 1);
        final ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(connections.size());
        for (final XMPPConnection xMPPConnection : connections) {
            xMPPConnection.addSyncStanzaListener(new StanzaListener(){

                public void processStanza(Stanza stanza) {
                    boolean[] fromMarkers;
                    XmppConnectionStressTest.this.waitStart = System.currentTimeMillis();
                    EntityFullJid from = stanza.getFrom().asEntityFullJidOrThrow();
                    Message message = (Message)stanza;
                    JivePropertiesExtension extension = JivePropertiesExtension.from((Message)message);
                    Integer messageNumber = (Integer)extension.getProperty(XmppConnectionStressTest.MESSAGE_NUMBER_PROPERTY);
                    HashMap<EntityFullJid, boolean[]> myReceiveMarkers = (HashMap<EntityFullJid, boolean[]>)concurrentHashMap.get(xMPPConnection);
                    if (myReceiveMarkers == null) {
                        myReceiveMarkers = new HashMap<EntityFullJid, boolean[]>(connections.size());
                        concurrentHashMap.put(xMPPConnection, myReceiveMarkers);
                    }
                    if ((fromMarkers = (boolean[])myReceiveMarkers.get(from)) == null) {
                        fromMarkers = new boolean[((XmppConnectionStressTest)XmppConnectionStressTest.this).configuration.messagesPerConnection];
                        myReceiveMarkers.put(from, fromMarkers);
                    }
                    for (int i = 0; i < fromMarkers.length; ++i) {
                        String inOrderViolation;
                        if (i < messageNumber && !fromMarkers[i]) {
                            inOrderViolation = "not yet message #";
                        } else {
                            if (i < messageNumber || !fromMarkers[i]) continue;
                            inOrderViolation = "we already received a later (or the same) message #";
                        }
                        StringBuilder exceptionMessage = new StringBuilder();
                        exceptionMessage.append("We received message #").append(messageNumber).append(" but ");
                        exceptionMessage.append(inOrderViolation);
                        exceptionMessage.append(i);
                        exceptionMessage.append("\nMessage with id ").append(stanza.getStanzaId()).append(" from ").append((CharSequence)from).append(" to ").append((CharSequence)stanza.getTo());
                        Exception exception = new Exception(exceptionMessage.toString());
                        receiveExceptions.put(xMPPConnection, exception);
                        xMPPConnection.removeSyncStanzaListener((StanzaListener)this);
                        receivedSemaphore.release();
                        return;
                    }
                    fromMarkers[messageNumber.intValue()] = true;
                    if (myReceiveMarkers.size() != connections.size()) {
                        return;
                    }
                    for (boolean[] markers : myReceiveMarkers.values()) {
                        if (!BooleansUtils.contains((boolean[])markers, (boolean)false)) continue;
                        return;
                    }
                    receivedSemaphore.release();
                }
            }, (StanzaFilter)new AndFilter(new StanzaFilter[]{MessageTypeFilter.NORMAL, new StanzaExtensionFilter("properties", "http://www.jivesoftware.com/xmlns/xmpp/properties")}));
        }
        Semaphore sendSemaphore = new Semaphore(-connections.size() + 1);
        for (XMPPConnection xMPPConnection : connections) {
            Async.go(() -> {
                List messagesToSend;
                MultiMap multiMap = messages;
                synchronized (multiMap) {
                    messagesToSend = messages.getAll((Object)connection);
                }
                try {
                    for (Message messageToSend : messagesToSend) {
                        connection.sendStanza((Stanza)messageToSend);
                    }
                }
                catch (InterruptedException | SmackException.NotConnectedException e) {
                    sendExceptions.put(connection, e);
                }
                finally {
                    sendSemaphore.release();
                }
            });
        }
        sendSemaphore.acquire();
        if (this.waitStart < 0L) {
            this.waitStart = System.currentTimeMillis();
        }
        while (!(bl = receivedSemaphore.tryAcquire(l = this.waitStart + replyTimeoutMillis - System.currentTimeMillis(), TimeUnit.MILLISECONDS)) && System.currentTimeMillis() < this.waitStart + replyTimeoutMillis) {
        }
        if (!bl && receiveExceptions.isEmpty() && sendExceptions.isEmpty()) {
            throw new StressTestFailedException.NotAllMessagesReceivedException(concurrentHashMap, connections);
        }
        if (!receiveExceptions.isEmpty() || !sendExceptions.isEmpty()) {
            throw new StressTestFailedException.ErrorsWhileSendingOrReceivingException(sendExceptions, receiveExceptions);
        }
    }

    public static abstract class StressTestFailedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        protected StressTestFailedException(String message) {
            super(message);
        }

        public static final class ErrorsWhileSendingOrReceivingException
        extends StressTestFailedException {
            private static final long serialVersionUID = 1L;
            public final Map<XMPPConnection, Exception> sendExceptions;
            public final Map<XMPPConnection, Exception> receiveExceptions;

            private ErrorsWhileSendingOrReceivingException(Map<XMPPConnection, Exception> sendExceptions, Map<XMPPConnection, Exception> receiveExceptions) {
                super(ErrorsWhileSendingOrReceivingException.createMessageFrom(sendExceptions, receiveExceptions));
                this.sendExceptions = sendExceptions;
                this.receiveExceptions = receiveExceptions;
            }

            private static String createMessageFrom(Map<XMPPConnection, Exception> sendExceptions, Map<XMPPConnection, Exception> receiveExceptions) {
                StringBuilder sb = new StringBuilder(1024);
                sb.append("Exceptions while sending and/or receiving.");
                if (!sendExceptions.isEmpty()) {
                    sb.append(" Send exxceptions: ");
                    for (Map.Entry<XMPPConnection, Exception> entry : sendExceptions.entrySet()) {
                        sb.append(entry.getKey()).append(": ").append(entry.getValue()).append(';');
                    }
                }
                if (!receiveExceptions.isEmpty()) {
                    sb.append(" Receive exceptions: ");
                    for (Map.Entry<XMPPConnection, Exception> entry : receiveExceptions.entrySet()) {
                        sb.append(entry.getKey()).append(": ").append(entry.getValue());
                    }
                }
                return sb.toString();
            }
        }

        public static final class NotAllMessagesReceivedException
        extends StressTestFailedException {
            private static final long serialVersionUID = 1L;
            public final Map<XMPPConnection, Map<EntityFullJid, boolean[]>> receiveMarkers;

            private NotAllMessagesReceivedException(Map<XMPPConnection, Map<EntityFullJid, boolean[]>> receiveMarkers, List<? extends XMPPConnection> connections) {
                super("Did not receive all messages\n" + NotAllMessagesReceivedException.markersToString(receiveMarkers, connections).toString());
                this.receiveMarkers = receiveMarkers;
            }

            public static StringBuilder markersToString(Map<XMPPConnection, Map<EntityFullJid, boolean[]>> receiveMarkers, List<? extends XMPPConnection> connections) {
                StringBuilder sb = new StringBuilder();
                int connectionCount = connections.size();
                HashMap<EntityFullJid, Integer> connectionIds = new HashMap<EntityFullJid, Integer>(connectionCount);
                for (int i = 0; i < connectionCount; ++i) {
                    XMPPConnection connection = connections.get(i);
                    EntityFullJid connectionAddress = connection.getUser();
                    connectionIds.put(connectionAddress, i);
                }
                for (Map.Entry<XMPPConnection, Map<EntityFullJid, boolean[]>> entry : receiveMarkers.entrySet()) {
                    XMPPConnection connection = entry.getKey();
                    Map<EntityFullJid, boolean[]> receiveMarkersOfThisConnection = entry.getValue();
                    Integer markerToConnectionId = (Integer)connectionIds.get(connection.getUser());
                    for (Map.Entry<EntityFullJid, boolean[]> receiveMarkerOfThisConnection : receiveMarkersOfThisConnection.entrySet()) {
                        boolean[] marker = receiveMarkerOfThisConnection.getValue();
                        int numberOfFalseMarkers = BooleansUtils.numberOf((boolean[])marker, (boolean)false);
                        if (numberOfFalseMarkers == 0) continue;
                        EntityFullJid markerFromAddress = receiveMarkerOfThisConnection.getKey();
                        Integer markerFromConnectionId = (Integer)connectionIds.get(markerFromAddress);
                        sb.append(markerToConnectionId).append(" is missing ").append(numberOfFalseMarkers).append(" messages from ").append(markerFromConnectionId).append(" :");
                        for (int i = 0; i < marker.length; ++i) {
                            if (marker[i]) continue;
                            sb.append(i).append(", ");
                        }
                        sb.setLength(sb.length() - 2);
                        sb.append('\n');
                    }
                }
                return sb;
            }
        }
    }

    public static class Configuration {
        public final long seed;
        public final int messagesPerConnection;
        public final int maxPayloadChunkSize;
        public final int maxPayloadChunks;
        public final boolean intermixMessages;

        public Configuration(long seed, int messagesPerConnection, int maxPayloadChunkSize, int maxPayloadChunks, boolean intermixMessages) {
            this.seed = seed;
            this.messagesPerConnection = messagesPerConnection;
            this.maxPayloadChunkSize = maxPayloadChunkSize;
            this.maxPayloadChunks = maxPayloadChunks;
            this.intermixMessages = intermixMessages;
        }
    }
}

