/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox;

import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.AfterClass;
import org.igniterealtime.smack.inttest.annotations.BeforeClass;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.ox.AbstractOpenPgpIntegrationTest;
import org.jivesoftware.smackx.ox.OpenPgpManager;
import org.jivesoftware.smackx.ox.OpenPgpSelf;
import org.jivesoftware.smackx.ox.callback.backup.AskForBackupCodeCallback;
import org.jivesoftware.smackx.ox.callback.backup.DisplayBackupCodeCallback;
import org.jivesoftware.smackx.ox.callback.backup.SecretKeyBackupSelectionCallback;
import org.jivesoftware.smackx.ox.crypto.OpenPgpProvider;
import org.jivesoftware.smackx.ox.crypto.PainlessOpenPgpProvider;
import org.jivesoftware.smackx.ox.exception.InvalidBackupCodeException;
import org.jivesoftware.smackx.ox.exception.MissingOpenPgpKeyException;
import org.jivesoftware.smackx.ox.exception.MissingUserIdOnKeyException;
import org.jivesoftware.smackx.ox.exception.NoBackupFoundException;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpStore;
import org.jivesoftware.smackx.ox.store.filebased.FileBasedOpenPgpStore;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.junit.jupiter.api.Assertions;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;

public class OXSecretKeyBackupIntegrationTest
extends AbstractOpenPgpIntegrationTest {
    private static final String sessionId = StringUtils.randomString((int)10);
    private static final File tempDir = FileUtils.getTempDirectory();
    private static final File beforePath = new File(tempDir, "ox_backup_" + sessionId);
    private static final File afterPath = new File(tempDir, "ox_restore_" + sessionId);
    private String backupCode = null;
    private OpenPgpManager openPgpManager;

    public OXSecretKeyBackupIntegrationTest(SmackIntegrationTestEnvironment environment) throws XMPPException.XMPPErrorException, TestNotPossibleException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        super(environment);
        if (!OpenPgpManager.serverSupportsSecretKeyBackups((XMPPConnection)this.aliceConnection)) {
            throw new TestNotPossibleException("Server does not support the 'whitelist' PubSub access model.");
        }
    }

    @AfterClass
    @BeforeClass
    public static void cleanStore() throws IOException {
        LOGGER.log(Level.INFO, "Delete store directories...");
        FileUtils.deleteDirectory((File)afterPath);
        FileUtils.deleteDirectory((File)beforePath);
    }

    @SmackIntegrationTest
    public void test() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, IOException, InterruptedException, PubSubException.NotALeafNodeException, SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.XMPPErrorException, SmackException.NotLoggedInException, SmackException.FeatureNotSupportedException, MissingUserIdOnKeyException, NoBackupFoundException, InvalidBackupCodeException, PGPException, MissingOpenPgpKeyException {
        FileBasedOpenPgpStore beforeStore = new FileBasedOpenPgpStore(beforePath);
        beforeStore.setKeyRingProtector((SecretKeyRingProtector)new UnprotectedKeysProtector());
        PainlessOpenPgpProvider beforeProvider = new PainlessOpenPgpProvider((OpenPgpStore)beforeStore);
        this.openPgpManager = OpenPgpManager.getInstanceFor((XMPPConnection)this.aliceConnection);
        this.openPgpManager.setOpenPgpProvider((OpenPgpProvider)beforeProvider);
        OpenPgpSelf self = this.openPgpManager.getOpenPgpSelf();
        Assertions.assertNull((Object)self.getSigningKeyFingerprint());
        OpenPgpV4Fingerprint keyFingerprint = this.openPgpManager.generateAndImportKeyPair(this.alice);
        Assertions.assertEquals((Object)keyFingerprint, (Object)self.getSigningKeyFingerprint());
        Assertions.assertTrue((boolean)self.getSecretKeys().contains(keyFingerprint.getKeyId()));
        PGPSecretKeyRing beforeSec = beforeStore.getSecretKeyRing(this.alice, keyFingerprint);
        Assertions.assertNotNull((Object)beforeSec);
        PGPPublicKeyRing beforePub = beforeStore.getPublicKeyRing(this.alice, keyFingerprint);
        Assertions.assertNotNull((Object)beforePub);
        this.openPgpManager.backupSecretKeyToServer(new DisplayBackupCodeCallback(){

            public void displayBackupCode(String backupCode) {
                OXSecretKeyBackupIntegrationTest.this.backupCode = backupCode;
            }
        }, new SecretKeyBackupSelectionCallback(){

            public Set<OpenPgpV4Fingerprint> selectKeysToBackup(Set<OpenPgpV4Fingerprint> availableSecretKeys) {
                return availableSecretKeys;
            }
        });
        FileBasedOpenPgpStore afterStore = new FileBasedOpenPgpStore(afterPath);
        afterStore.setKeyRingProtector((SecretKeyRingProtector)new UnprotectedKeysProtector());
        PainlessOpenPgpProvider afterProvider = new PainlessOpenPgpProvider((OpenPgpStore)afterStore);
        this.openPgpManager.setOpenPgpProvider((OpenPgpProvider)afterProvider);
        OpenPgpV4Fingerprint fingerprint = this.openPgpManager.restoreSecretKeyServerBackup(new AskForBackupCodeCallback(){

            public String askForBackupCode() {
                return OXSecretKeyBackupIntegrationTest.this.backupCode;
            }
        });
        Assertions.assertEquals((Object)keyFingerprint, (Object)fingerprint);
        Assertions.assertTrue((boolean)self.getSecretKeys().contains(keyFingerprint.getKeyId()));
        Assertions.assertEquals((Object)keyFingerprint, (Object)self.getSigningKeyFingerprint());
        PGPSecretKeyRing afterSec = afterStore.getSecretKeyRing(this.alice, keyFingerprint);
        Assertions.assertNotNull((Object)afterSec);
        Assertions.assertTrue((boolean)Arrays.equals(beforeSec.getEncoded(), afterSec.getEncoded()));
        PGPPublicKeyRing afterPub = afterStore.getPublicKeyRing(this.alice, keyFingerprint);
        Assertions.assertNotNull((Object)afterPub);
        Assertions.assertTrue((boolean)Arrays.equals(beforePub.getEncoded(), afterPub.getEncoded()));
    }
}

