/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox;

import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.ox.util.OpenPgpPubSubUtil;
import org.jivesoftware.smackx.pep.PepManager;
import org.jxmpp.jid.BareJid;

public abstract class AbstractOpenPgpIntegrationTest
extends AbstractSmackIntegrationTest {
    protected final XMPPConnection aliceConnection;
    protected final XMPPConnection bobConnection;
    protected final XMPPConnection chloeConnection;
    protected final BareJid alice;
    protected final BareJid bob;
    protected final BareJid chloe;
    protected final PepManager alicePepManager;
    protected final PepManager bobPepManager;
    protected final PepManager chloePepManager;

    protected AbstractOpenPgpIntegrationTest(SmackIntegrationTestEnvironment environment) throws XMPPException.XMPPErrorException, TestNotPossibleException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        super(environment);
        AbstractOpenPgpIntegrationTest.throwIfPubSubNotSupported(this.conOne);
        AbstractOpenPgpIntegrationTest.throwIfPubSubNotSupported(this.conTwo);
        AbstractOpenPgpIntegrationTest.throwIfPubSubNotSupported(this.conThree);
        this.aliceConnection = this.conOne;
        this.bobConnection = this.conTwo;
        this.chloeConnection = this.conThree;
        this.alice = this.aliceConnection.getUser().asBareJid();
        this.bob = this.bobConnection.getUser().asBareJid();
        this.chloe = this.chloeConnection.getUser().asBareJid();
        this.alicePepManager = PepManager.getInstanceFor((XMPPConnection)this.aliceConnection);
        this.bobPepManager = PepManager.getInstanceFor((XMPPConnection)this.bobConnection);
        this.chloePepManager = PepManager.getInstanceFor((XMPPConnection)this.chloeConnection);
        OpenPgpPubSubUtil.deletePubkeysListNode((PepManager)this.alicePepManager);
        OpenPgpPubSubUtil.deletePubkeysListNode((PepManager)this.bobPepManager);
        OpenPgpPubSubUtil.deletePubkeysListNode((PepManager)this.chloePepManager);
    }

    private static void throwIfPubSubNotSupported(XMPPConnection connection) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, TestNotPossibleException {
        if (!PepManager.getInstanceFor((XMPPConnection)connection).isSupported()) {
            throw new TestNotPossibleException("Server " + connection.getXMPPServiceDomain().toString() + " does not support PEP.");
        }
    }
}

