/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.geolocation;

import java.net.URI;
import java.util.concurrent.TimeoutException;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.annotations.AfterClass;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.util.IntegrationTestRosterUtil;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.geoloc.GeoLocationManager;
import org.jivesoftware.smackx.geoloc.packet.GeoLocation;
import org.jivesoftware.smackx.pep.PepEventListener;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.util.XmppDateTime;

public class GeolocationIntegrationTest
extends AbstractSmackIntegrationTest {
    private final GeoLocationManager glm1;
    private final GeoLocationManager glm2;

    public GeolocationIntegrationTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
        this.glm1 = GeoLocationManager.getInstanceFor((XMPPConnection)this.conOne);
        this.glm2 = GeoLocationManager.getInstanceFor((XMPPConnection)this.conTwo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void test() throws TimeoutException, Exception {
        GeoLocation.Builder builder = GeoLocation.builder();
        final GeoLocation geoLocation1 = builder.setAccuracy(Double.valueOf(23.0)).setAlt(Double.valueOf(1000.0)).setAltAccuracy(Double.valueOf(10.0)).setArea("Delhi").setBearing(Double.valueOf(10.0)).setBuilding("Small Building").setCountry("India").setCountryCode("IN").setDescription("My Description").setFloor("top").setLat(Double.valueOf(25.098345)).setLocality("awesome").setLon(Double.valueOf(77.992034)).setPostalcode("110085").setRegion("North").setRoom("small").setSpeed(Double.valueOf(250.0)).setStreet("Wall Street").setText("Unit Testing GeoLocation").setTimestamp(XmppDateTime.parseDate((String)"2004-02-19")).setTzo("+5:30").setUri(new URI("http://xmpp.org")).build();
        IntegrationTestRosterUtil.ensureBothAccountsAreSubscribedToEachOther(this.conOne, this.conTwo, this.timeout);
        final SimpleResultSyncPoint geoLocationReceived = new SimpleResultSyncPoint();
        PepEventListener<GeoLocation> geoLocationListener = new PepEventListener<GeoLocation>(){

            public void onPepEvent(EntityBareJid jid, GeoLocation geoLocation, String id, Message message) {
                if (geoLocation.equals((Object)geoLocation1)) {
                    geoLocationReceived.signal();
                } else {
                    geoLocationReceived.signalFailure("Received non matching GeoLocation");
                }
            }
        };
        this.glm2.addGeoLocationListener((PepEventListener)geoLocationListener);
        try {
            this.glm1.publishGeoLocation(geoLocation1);
            geoLocationReceived.waitForResult(this.timeout);
        }
        finally {
            this.glm2.removeGeoLocationListener((PepEventListener)geoLocationListener);
        }
    }

    @AfterClass
    public void unsubscribe() throws SmackException.NotLoggedInException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        IntegrationTestRosterUtil.ensureBothAccountsAreNotInEachOthersRoster(this.conOne, this.conTwo);
    }
}

