/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.usertune;

import java.net.URI;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.annotations.AfterClass;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.util.IntegrationTestRosterUtil;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.pep.PepEventListener;
import org.jivesoftware.smackx.usertune.UserTuneManager;
import org.jivesoftware.smackx.usertune.element.UserTuneElement;
import org.jxmpp.jid.EntityBareJid;

public class UserTuneIntegrationTest
extends AbstractSmackIntegrationTest {
    private final UserTuneManager utm1;
    private final UserTuneManager utm2;

    public UserTuneIntegrationTest(SmackIntegrationTestEnvironment environment) throws SmackException.NotLoggedInException {
        super(environment);
        this.utm1 = UserTuneManager.getInstanceFor((XMPPConnection)this.conOne);
        this.utm2 = UserTuneManager.getInstanceFor((XMPPConnection)this.conTwo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void test() throws Exception {
        URI uri = new URI("http://www.yesworld.com/lyrics/Fragile.html#9");
        UserTuneElement.Builder builder = UserTuneElement.getBuilder();
        final UserTuneElement userTuneElement1 = builder.setArtist("Yes").setLength(686).setRating(8).setSource("Yessongs").setTitle("Heart of the Sunrise").setTrack("3").setUri(uri).build();
        IntegrationTestRosterUtil.ensureBothAccountsAreSubscribedToEachOther(this.conOne, this.conTwo, this.timeout);
        final SimpleResultSyncPoint userTuneReceived = new SimpleResultSyncPoint();
        PepEventListener<UserTuneElement> userTuneListener = new PepEventListener<UserTuneElement>(){

            public void onPepEvent(EntityBareJid jid, UserTuneElement userTuneElement, String id, Message message) {
                if (userTuneElement.equals((Object)userTuneElement1)) {
                    userTuneReceived.signal();
                }
            }
        };
        this.utm2.addUserTuneListener((PepEventListener)userTuneListener);
        try {
            this.utm1.publishUserTune(userTuneElement1);
            userTuneReceived.waitForResult(this.timeout);
        }
        finally {
            this.utm2.removeUserTuneListener((PepEventListener)userTuneListener);
        }
    }

    @AfterClass
    public void unsubscribe() throws SmackException.NotLoggedInException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        IntegrationTestRosterUtil.ensureBothAccountsAreNotInEachOthersRoster(this.conOne, this.conTwo);
    }
}

