/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.igniterealtime.smack.inttest.Configuration;
import org.igniterealtime.smack.inttest.ConnectionConfigurationBuilderApplier;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.util.Consumer;

public final class XmppConnectionDescriptor<C extends AbstractXMPPConnection, CC extends ConnectionConfiguration, CCB extends ConnectionConfiguration.Builder<?, CC>> {
    private final Class<C> connectionClass;
    private final Class<CC> connectionConfigurationClass;
    private final Constructor<C> connectionConstructor;
    private final Method builderMethod;
    private final Consumer<CCB> extraBuilder;
    private final String nickname;

    private XmppConnectionDescriptor(Builder<C, CC, CCB> builder) throws NoSuchMethodException, SecurityException {
        this.connectionClass = ((Builder)builder).connectionClass;
        this.connectionConfigurationClass = ((Builder)builder).connectionConfigurationClass;
        this.extraBuilder = ((Builder)builder).extraBuilder;
        this.nickname = ((Builder)builder).nickname;
        this.connectionConstructor = XmppConnectionDescriptor.getConstructor(this.connectionClass, this.connectionConfigurationClass);
        this.builderMethod = XmppConnectionDescriptor.getBuilderMethod(this.connectionConfigurationClass);
    }

    public C construct(Configuration sinttestConfiguration) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.construct(sinttestConfiguration, Collections.emptyList());
    }

    public C construct(Configuration sinttestConfiguration, ConnectionConfigurationBuilderApplier ... customConnectionConfigurationAppliers) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ArrayList<ConnectionConfigurationBuilderApplier> customConnectionConfigurationAppliersList = new ArrayList<ConnectionConfigurationBuilderApplier>(Arrays.asList(customConnectionConfigurationAppliers));
        return this.construct(sinttestConfiguration, customConnectionConfigurationAppliersList);
    }

    public C construct(Configuration sinttestConfiguration, Collection<ConnectionConfigurationBuilderApplier> customConnectionConfigurationAppliers) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        CCB connectionConfigurationBuilder = this.getNewBuilder();
        if (this.extraBuilder != null) {
            this.extraBuilder.accept(connectionConfigurationBuilder);
        }
        for (ConnectionConfigurationBuilderApplier customConnectionConfigurationApplier : customConnectionConfigurationAppliers) {
            customConnectionConfigurationApplier.applyConfigurationTo((ConnectionConfiguration.Builder<?, ?>)connectionConfigurationBuilder);
        }
        sinttestConfiguration.configurationApplier.applyConfigurationTo((ConnectionConfiguration.Builder<?, ?>)connectionConfigurationBuilder);
        ConnectionConfiguration connectionConfiguration = connectionConfigurationBuilder.build();
        ConnectionConfiguration concreteConnectionConfiguration = (ConnectionConfiguration)this.connectionConfigurationClass.cast(connectionConfiguration);
        AbstractXMPPConnection connection = (AbstractXMPPConnection)this.connectionConstructor.newInstance(concreteConnectionConfiguration);
        connection.setReplyTimeout((long)sinttestConfiguration.replyTimeout);
        return (C)connection;
    }

    public CCB getNewBuilder() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (CCB)((ConnectionConfiguration.Builder)this.builderMethod.invoke(null, new Object[0]));
    }

    public Class<C> getConnectionClass() {
        return this.connectionClass;
    }

    public String getNickname() {
        return this.nickname;
    }

    private static <C extends XMPPConnection> Constructor<C> getConstructor(Class<C> connectionClass, Class<? extends ConnectionConfiguration> connectionConfigurationClass) throws NoSuchMethodException, SecurityException {
        return connectionClass.getConstructor(connectionConfigurationClass);
    }

    private static <CC extends ConnectionConfiguration> Method getBuilderMethod(Class<CC> connectionConfigurationClass) throws NoSuchMethodException, SecurityException {
        Method builderMethod = connectionConfigurationClass.getMethod("builder", new Class[0]);
        if (!Modifier.isStatic(builderMethod.getModifiers())) {
            throw new IllegalArgumentException();
        }
        Class<?> returnType = builderMethod.getReturnType();
        if (!ConnectionConfiguration.Builder.class.isAssignableFrom(returnType)) {
            throw new IllegalArgumentException();
        }
        return builderMethod;
    }

    public static <C extends AbstractXMPPConnection, CC extends ConnectionConfiguration, CCB extends ConnectionConfiguration.Builder<?, CC>> Builder<C, CC, CCB> buildWith(Class<C> connectionClass, Class<CC> connectionConfigurationClass) {
        return XmppConnectionDescriptor.buildWith(connectionClass, connectionConfigurationClass, null);
    }

    public static <C extends AbstractXMPPConnection, CC extends ConnectionConfiguration, CCB extends ConnectionConfiguration.Builder<?, CC>> Builder<C, CC, CCB> buildWith(Class<C> connectionClass, Class<CC> connectionConfigurationClass, Class<CCB> connectionConfigurationBuilderClass) {
        return new Builder(connectionClass, connectionConfigurationClass, connectionConfigurationBuilderClass);
    }

    public static final class Builder<C extends AbstractXMPPConnection, CC extends ConnectionConfiguration, CCB extends ConnectionConfiguration.Builder<?, CC>> {
        private final Class<C> connectionClass;
        private final Class<CC> connectionConfigurationClass;
        private Consumer<CCB> extraBuilder;
        private String nickname;

        private Builder(Class<C> connectionClass, Class<CC> connectionConfigurationClass, Class<CCB> connectionConfigurationBuilderClass) {
            this.connectionClass = connectionClass;
            this.connectionConfigurationClass = connectionConfigurationClass;
            this.nickname = connectionClass.getSimpleName();
        }

        public Builder<C, CC, CCB> applyExtraConfguration(Consumer<CCB> extraBuilder) {
            this.extraBuilder = extraBuilder;
            return this;
        }

        public Builder<C, CC, CCB> withNickname(String nickname) {
            this.nickname = nickname;
            return this;
        }

        public XmppConnectionDescriptor<C, CC, CCB> build() throws NoSuchMethodException, SecurityException {
            return new XmppConnectionDescriptor(this);
        }
    }
}

