/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.igniterealtime.smack.inttest.AbstractSmackIntTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.PresenceTypeFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.Async;
import org.jxmpp.jid.Jid;

public abstract class AbstractSmackIntegrationTest
extends AbstractSmackIntTest {
    protected final XMPPConnection conOne;
    protected final XMPPConnection conTwo;
    protected final XMPPConnection conThree;
    protected final XMPPConnection connection;
    protected final List<XMPPConnection> connections;

    public AbstractSmackIntegrationTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
        this.connection = this.conOne = environment.conOne;
        this.conTwo = environment.conTwo;
        this.conThree = environment.conThree;
        ArrayList<XMPPConnection> connectionsLocal = new ArrayList<XMPPConnection>(3);
        connectionsLocal.add(this.conOne);
        connectionsLocal.add(this.conTwo);
        connectionsLocal.add(this.conThree);
        this.connections = Collections.unmodifiableList(connectionsLocal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performActionAndWaitForPresence(XMPPConnection conA, XMPPConnection conB, Async.ThrowingRunnable action) throws Exception {
        final SimpleResultSyncPoint presenceReceivedSyncPoint = new SimpleResultSyncPoint();
        StanzaListener presenceListener = new StanzaListener(){

            public void processStanza(Stanza packet) {
                presenceReceivedSyncPoint.signal();
            }
        };
        conA.addAsyncStanzaListener(presenceListener, (StanzaFilter)new AndFilter(new StanzaFilter[]{PresenceTypeFilter.AVAILABLE, FromMatchesFilter.create((Jid)conB.getUser())}));
        action.runOrThrow();
        try {
            presenceReceivedSyncPoint.waitForResult(this.timeout);
        }
        finally {
            conA.removeAsyncStanzaListener(presenceListener);
        }
    }
}

