/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Date;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.annotations.AfterClass;
import org.igniterealtime.smack.inttest.annotations.BeforeClass;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.chat.Chat;
import org.jivesoftware.smack.chat.ChatManager;
import org.jivesoftware.smack.chat.ChatManagerListener;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.ThreadFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smackx.jiveproperties.JivePropertiesManager;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.EntityJid;

public class ChatTest
extends AbstractSmackIntegrationTest {
    private final ChatManager chatManagerOne;
    private boolean invoked;

    public ChatTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
        this.chatManagerOne = ChatManager.getInstanceFor((XMPPConnection)this.conOne);
    }

    @BeforeClass
    public void setUp() {
        JivePropertiesManager.setJavaObjectEnabled((boolean)true);
    }

    @AfterClass
    public void tearDown() {
        JivePropertiesManager.setJavaObjectEnabled((boolean)false);
    }

    @SmackIntegrationTest
    public void testProperties() throws Exception {
        Chat newChat = this.chatManagerOne.createChat((EntityJid)this.conTwo.getUser());
        StanzaCollector collector = this.conTwo.createStanzaCollector((StanzaFilter)new ThreadFilter(newChat.getThreadID()));
        MessageBuilder messageBuilder = StanzaBuilder.buildMessage();
        messageBuilder.setSubject("Subject of the chat");
        messageBuilder.setBody("Body of the chat");
        JivePropertiesManager.addProperty((StanzaBuilder)messageBuilder, (String)"favoriteColor", (Object)"red");
        JivePropertiesManager.addProperty((StanzaBuilder)messageBuilder, (String)"age", (Object)30);
        JivePropertiesManager.addProperty((StanzaBuilder)messageBuilder, (String)"distance", (Object)Float.valueOf(30.0f));
        JivePropertiesManager.addProperty((StanzaBuilder)messageBuilder, (String)"weight", (Object)30.0);
        JivePropertiesManager.addProperty((StanzaBuilder)messageBuilder, (String)"male", (Object)true);
        JivePropertiesManager.addProperty((StanzaBuilder)messageBuilder, (String)"birthdate", (Object)new Date());
        Message msg = messageBuilder.build();
        newChat.sendMessage(msg);
        Message msg2 = (Message)collector.nextResult(2000L);
        Assertions.assertNotNull((Object)msg2, (String)"No message was received");
        Assertions.assertEquals((Object)msg.getSubject(), (Object)msg2.getSubject(), (String)"Subjects are different");
        Assertions.assertEquals((Object)msg.getBody(), (Object)msg2.getBody(), (String)"Bodies are different");
        Assertions.assertEquals((Object)JivePropertiesManager.getProperty((StanzaView)msg, (String)"favoriteColor"), (Object)JivePropertiesManager.getProperty((StanzaView)msg2, (String)"favoriteColor"), (String)"favoriteColors are different");
        Assertions.assertEquals((Object)JivePropertiesManager.getProperty((StanzaView)msg, (String)"age"), (Object)JivePropertiesManager.getProperty((StanzaView)msg2, (String)"age"), (String)"ages are different");
        Assertions.assertEquals((Object)JivePropertiesManager.getProperty((StanzaView)msg, (String)"distance"), (Object)JivePropertiesManager.getProperty((StanzaView)msg2, (String)"distance"), (String)"distances are different");
        Assertions.assertEquals((Object)JivePropertiesManager.getProperty((StanzaView)msg, (String)"weight"), (Object)JivePropertiesManager.getProperty((StanzaView)msg2, (String)"weight"), (String)"weights are different");
        Assertions.assertEquals((Object)JivePropertiesManager.getProperty((StanzaView)msg, (String)"male"), (Object)JivePropertiesManager.getProperty((StanzaView)msg2, (String)"male"), (String)"males are different");
        Assertions.assertEquals((Object)JivePropertiesManager.getProperty((StanzaView)msg, (String)"birthdate"), (Object)JivePropertiesManager.getProperty((StanzaView)msg2, (String)"birthdate"), (String)"birthdates are different");
    }

    @SmackIntegrationTest
    public void chatManagerTest() {
        ChatManagerListener listener = new ChatManagerListener(){

            public void chatCreated(Chat chat, boolean createdLocally) {
                ChatTest.this.invoked = true;
            }
        };
        try {
            this.chatManagerOne.addChatListener(listener);
            this.chatManagerOne.createChat((EntityJid)this.conTwo.getUser());
            Assertions.assertTrue((boolean)this.invoked, (String)"TestChatManagerListener wasn't invoked");
        }
        finally {
            this.chatManagerOne.removeChatListener(listener);
        }
    }
}

