/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.concurrent.TimeoutException;
import org.igniterealtime.smack.inttest.AbstractSmackLowLevelIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.util.IntegrationTestRosterUtil;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.roster.AbstractPresenceEventListener;
import org.jivesoftware.smack.roster.PresenceEventListener;
import org.jivesoftware.smack.roster.Roster;
import org.jxmpp.jid.FullJid;

public class LowLevelRosterIntegrationTest
extends AbstractSmackLowLevelIntegrationTest {
    public LowLevelRosterIntegrationTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
    }

    @SmackIntegrationTest
    public void testPresenceEventListenersOffline(AbstractXMPPConnection conOne, final AbstractXMPPConnection conTwo) throws TimeoutException, Exception {
        IntegrationTestRosterUtil.ensureBothAccountsAreNotInEachOthersRoster((XMPPConnection)conOne, (XMPPConnection)conTwo);
        Roster rosterOne = Roster.getInstanceFor((XMPPConnection)conOne);
        Roster rosterTwo = Roster.getInstanceFor((XMPPConnection)conTwo);
        rosterOne.createItem(conTwo.getUser().asBareJid(), "Con Two", null);
        rosterTwo.createItem(conOne.getUser().asBareJid(), "Con One", null);
        IntegrationTestRosterUtil.ensureBothAccountsAreSubscribedToEachOther((XMPPConnection)conOne, (XMPPConnection)conTwo, this.timeout);
        final SimpleResultSyncPoint offlineTriggered = new SimpleResultSyncPoint();
        rosterOne.addPresenceEventListener((PresenceEventListener)new AbstractPresenceEventListener(){

            public void presenceUnavailable(FullJid jid, Presence presence) {
                if (!jid.equals((CharSequence)conTwo.getUser())) {
                    return;
                }
                offlineTriggered.signal();
            }
        });
        conTwo.disconnect();
        Boolean result = (Boolean)offlineTriggered.waitForResult(this.timeout);
        if (!result.booleanValue()) {
            throw new Exception("presenceUnavailable() was not called");
        }
    }
}

