/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest.util;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.igniterealtime.smack.inttest.util.ResultSyncPoint;
import org.jivesoftware.smack.util.Async;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResultSyncPointTest {
    @Test
    public void testResultSyncPoint() throws Exception {
        String result = "Hip Hip Hurrary!!111!";
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final ResultSyncPoint rsp = new ResultSyncPoint();
        Async.go((Runnable)new Async.ThrowingRunnable(){

            public void runOrThrow() throws InterruptedException, BrokenBarrierException {
                barrier.await();
                rsp.signal((Object)"Hip Hip Hurrary!!111!");
            }
        });
        barrier.await();
        String receivedResult = (String)rsp.waitForResult(60000L);
        Assertions.assertEquals((Object)"Hip Hip Hurrary!!111!", (Object)receivedResult);
    }

    @Test
    public void exceptionTestResultSyncPoint() throws Exception {
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final ResultSyncPoint rsp = new ResultSyncPoint();
        Async.go((Runnable)new Async.ThrowingRunnable(){

            public void runOrThrow() throws InterruptedException, BrokenBarrierException {
                barrier.await();
                rsp.signal((Exception)new TestException());
            }
        });
        barrier.await();
        Assertions.assertThrows(TestException.class, () -> {
            String cfr_ignored_0 = (String)rsp.waitForResult(60000L);
        });
    }

    private static class TestException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private TestException() {
        }
    }
}

