/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest;

import eu.geekplace.javapinning.java7.Java7Pinning;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.igniterealtime.smack.inttest.AbstractSmackIntTest;
import org.igniterealtime.smack.inttest.ConnectionConfigurationBuilderApplier;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.debugger.ConsoleDebugger;
import org.jivesoftware.smack.util.Function;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.util.SslContextFactory;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.debugger.EnhancedDebugger;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public final class Configuration {
    private static final Logger LOGGER = Logger.getLogger(Configuration.class.getName());
    public final DomainBareJid service;
    public final String serviceTlsPin;
    public final SslContextFactory sslContextFactory;
    public final ConnectionConfiguration.SecurityMode securityMode;
    public final int replyTimeout;
    public final AccountRegistration accountRegistration;
    public final String adminAccountUsername;
    public final String adminAccountPassword;
    public final String accountOneUsername;
    public final String accountOnePassword;
    public final String accountTwoUsername;
    public final String accountTwoPassword;
    public final String accountThreeUsername;
    public final String accountThreePassword;
    public final Debugger debugger;
    public final Set<String> enabledTests;
    public final Set<String> disabledTests;
    public final String defaultConnectionNickname;
    public final Set<String> enabledConnections;
    public final Set<String> disabledConnections;
    public final Set<String> testPackages;
    public final ConnectionConfigurationBuilderApplier configurationApplier;
    public final boolean verbose;
    public final DnsResolver dnsResolver;
    private static final String SINTTEST = "sinttest.";

    private Configuration(Builder builder) throws KeyManagementException, NoSuchAlgorithmException {
        this.service = (DomainBareJid)Objects.requireNonNull((Object)builder.service, (String)"'service' must be set. Either via 'properties' files or via system property 'sinttest.service'.");
        this.serviceTlsPin = builder.serviceTlsPin;
        if (this.serviceTlsPin != null) {
            SSLContext sslContext = Java7Pinning.forPin((String)this.serviceTlsPin);
            this.sslContextFactory = () -> sslContext;
        } else {
            this.sslContextFactory = null;
        }
        this.securityMode = builder.securityMode;
        this.replyTimeout = builder.replyTimeout > 0 ? builder.replyTimeout : 60000;
        this.debugger = builder.debugger;
        this.accountRegistration = StringUtils.isNotEmpty((CharSequence[])new CharSequence[]{builder.adminAccountUsername, builder.adminAccountPassword}) ? AccountRegistration.serviceAdministration : (StringUtils.isNotEmpty((CharSequence[])new CharSequence[]{builder.accountOneUsername, builder.accountOnePassword, builder.accountTwoUsername, builder.accountTwoPassword, builder.accountThreeUsername, builder.accountThreePassword}) ? AccountRegistration.disabled : AccountRegistration.inBandRegistration);
        this.adminAccountUsername = builder.adminAccountUsername;
        this.adminAccountPassword = builder.adminAccountPassword;
        boolean accountOnePasswordSet = StringUtils.isNotEmpty((CharSequence)builder.accountOnePassword);
        if (accountOnePasswordSet != StringUtils.isNotEmpty((CharSequence)builder.accountTwoPassword) || accountOnePasswordSet != StringUtils.isNotEmpty((CharSequence)builder.accountThreePassword)) {
            throw new IllegalArgumentException();
        }
        this.accountOneUsername = builder.accountOneUsername;
        this.accountOnePassword = builder.accountOnePassword;
        this.accountTwoUsername = builder.accountTwoUsername;
        this.accountTwoPassword = builder.accountTwoPassword;
        this.accountThreeUsername = builder.accountThreeUsername;
        this.accountThreePassword = builder.accountThreePassword;
        this.enabledTests = builder.enabledTests;
        this.disabledTests = builder.disabledTests;
        this.defaultConnectionNickname = builder.defaultConnectionNickname;
        this.enabledConnections = builder.enabledConnections;
        this.disabledConnections = builder.disabledConnections;
        this.testPackages = builder.testPackages;
        this.configurationApplier = b -> {
            if (this.sslContextFactory != null) {
                b.setSslContextFactory(this.sslContextFactory);
            }
            b.setSecurityMode(this.securityMode);
            b.setXmppDomain(this.service);
            switch (this.debugger) {
                case enhanced: {
                    b.setDebuggerFactory(EnhancedDebugger.Factory.INSTANCE);
                    break;
                }
                case console: {
                    b.setDebuggerFactory(ConsoleDebugger.Factory.INSTANCE);
                    break;
                }
            }
        };
        this.verbose = builder.verbose;
        this.dnsResolver = builder.dnsResolver;
    }

    public boolean isAccountRegistrationPossible() {
        return this.accountRegistration != AccountRegistration.disabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Configuration newConfiguration(String[] testPackages) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        String debugString;
        Properties properties = new Properties();
        File propertiesFile = Configuration.findPropertiesFile();
        if (propertiesFile != null) {
            FileInputStream in = new FileInputStream(propertiesFile);
            Object object = null;
            try {
                properties.load(in);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        Properties systemProperties = System.getProperties();
        for (Map.Entry<Object, Object> entry : systemProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(SINTTEST)) continue;
            key = key.substring(SINTTEST.length());
            String value = (String)entry.getValue();
            properties.put(key, value);
        }
        Builder builder = Configuration.builder();
        builder.setService(properties.getProperty("service"));
        builder.setServiceTlsPin(properties.getProperty("serviceTlsPin"));
        builder.setSecurityMode(properties.getProperty("securityMode"));
        builder.setReplyTimeout(properties.getProperty("replyTimeout", "60000"));
        String adminAccountUsername = properties.getProperty("adminAccountUsername");
        String adminAccountPassword = properties.getProperty("adminAccountPassword");
        if (StringUtils.isNotEmpty((CharSequence[])new CharSequence[]{adminAccountUsername, adminAccountPassword})) {
            builder.setAdminAccountUsernameAndPassword(adminAccountUsername, adminAccountPassword);
        }
        String accountOneUsername = properties.getProperty("accountOneUsername");
        String accountOnePassword = properties.getProperty("accountOnePassword");
        String accountTwoUsername = properties.getProperty("accountTwoUsername");
        String accountTwoPassword = properties.getProperty("accountTwoPassword");
        String accountThreeUsername = properties.getProperty("accountThreeUsername");
        String accountThreePassword = properties.getProperty("accountThreePassword");
        if (accountOneUsername != null || accountOnePassword != null || accountTwoUsername != null || accountTwoPassword != null || accountThreeUsername != null || accountThreePassword != null) {
            builder.setUsernamesAndPassword(accountOneUsername, accountOnePassword, accountTwoUsername, accountTwoPassword, accountThreeUsername, accountThreePassword);
        }
        if ((debugString = properties.getProperty("debug")) != null) {
            LOGGER.warning("Usage of depreacted 'debug' option detected, please use 'debugger' instead");
            builder.setDebugger(debugString);
        }
        builder.setDebugger(properties.getProperty("debugger"));
        builder.setEnabledTests(properties.getProperty("enabledTests"));
        builder.setDisabledTests(properties.getProperty("disabledTests"));
        builder.setDefaultConnection(properties.getProperty("defaultConnection"));
        builder.setEnabledConnections(properties.getProperty("enabledConnections"));
        builder.setDisabledConnections(properties.getProperty("disabledConnections"));
        builder.addTestPackages(properties.getProperty("testPackages"));
        builder.addTestPackages(testPackages);
        builder.setVerbose(properties.getProperty("verbose"));
        builder.setDnsResolver(properties.getProperty("dnsResolver"));
        return builder.build();
    }

    private static File findPropertiesFile() {
        LinkedList<String> possibleLocations = new LinkedList<String>();
        possibleLocations.add("properties");
        String userHome = System.getProperty("user.home");
        if (userHome != null) {
            possibleLocations.add(userHome + "/.config/smack-integration-test/properties");
        }
        for (String possibleLocation : possibleLocations) {
            File res = new File(possibleLocation);
            if (!res.isFile()) continue;
            return res;
        }
        return null;
    }

    private static Set<String> split(String input) {
        return Configuration.split(input, (Function<String, String>)Function.identity());
    }

    private static Set<String> split(String input, Function<String, String> transformer) {
        if (input == null) {
            return null;
        }
        String[] inputArray = input.split(",");
        HashSet<String> res = new HashSet<String>(inputArray.length);
        for (String s : inputArray) {
            boolean newElement = res.add(s = (String)transformer.apply((Object)s));
            if (newElement) continue;
            throw new IllegalArgumentException("The argument '" + s + "' was already provided.");
        }
        return res;
    }

    private static Set<String> getTestSetFrom(String input) {
        return Configuration.split(input, (Function<String, String>)((Function)s -> {
            if ((s = s.trim()).startsWith("smackx.") || s.startsWith("smack.")) {
                s = "org.jivesoftware." + s;
            }
            return s;
        }));
    }

    public static final class Builder {
        private DomainBareJid service;
        private String serviceTlsPin;
        private ConnectionConfiguration.SecurityMode securityMode;
        private int replyTimeout;
        private String adminAccountUsername;
        private String adminAccountPassword;
        private String accountOneUsername;
        private String accountOnePassword;
        private String accountTwoUsername;
        private String accountTwoPassword;
        public String accountThreeUsername;
        public String accountThreePassword;
        private Debugger debugger = Debugger.none;
        private Set<String> enabledTests;
        private Set<String> disabledTests;
        private String defaultConnectionNickname;
        private Set<String> enabledConnections;
        private Set<String> disabledConnections;
        private Set<String> testPackages;
        private boolean verbose;
        private DnsResolver dnsResolver = DnsResolver.minidns;

        private Builder() {
        }

        public Builder setService(String service) throws XmppStringprepException {
            if (service == null) {
                return this;
            }
            return this.setService(JidCreate.domainBareFrom((String)service));
        }

        public Builder setService(DomainBareJid service) {
            this.service = service;
            return this;
        }

        public Builder addEnabledTest(Class<? extends AbstractSmackIntTest> enabledTest) {
            if (this.enabledTests == null) {
                this.enabledTests = new HashSet<String>();
            }
            this.enabledTests.add(enabledTest.getName());
            return this.addTestPackage(enabledTest.getPackage().getName());
        }

        private void ensureTestPackagesIsSet(int length) {
            if (this.testPackages == null) {
                this.testPackages = new HashSet<String>(length);
            }
        }

        public Builder addTestPackage(String testPackage) {
            this.ensureTestPackagesIsSet(4);
            this.testPackages.add(testPackage);
            return this;
        }

        public Builder setAdminAccountUsernameAndPassword(String adminAccountUsername, String adminAccountPassword) {
            this.adminAccountUsername = (String)StringUtils.requireNotNullNorEmpty((CharSequence)adminAccountUsername, (String)"adminAccountUsername must not be null nor empty");
            this.adminAccountPassword = (String)StringUtils.requireNotNullNorEmpty((CharSequence)adminAccountPassword, (String)"adminAccountPassword must no be null nor empty");
            return this;
        }

        public Builder setUsernamesAndPassword(String accountOneUsername, String accountOnePassword, String accountTwoUsername, String accountTwoPassword, String accountThreeUsername, String accountThreePassword) {
            this.accountOneUsername = (String)StringUtils.requireNotNullNorEmpty((CharSequence)accountOneUsername, (String)"accountOneUsername must not be null nor empty");
            this.accountOnePassword = (String)StringUtils.requireNotNullNorEmpty((CharSequence)accountOnePassword, (String)"accountOnePassword must not be null nor empty");
            this.accountTwoUsername = (String)StringUtils.requireNotNullNorEmpty((CharSequence)accountTwoUsername, (String)"accountTwoUsername must not be null nor empty");
            this.accountTwoPassword = (String)StringUtils.requireNotNullNorEmpty((CharSequence)accountTwoPassword, (String)"accountTwoPasswordmust not be null nor empty");
            this.accountThreeUsername = (String)StringUtils.requireNotNullNorEmpty((CharSequence)accountThreeUsername, (String)"accountThreeUsername must not be null nor empty");
            this.accountThreePassword = (String)StringUtils.requireNotNullNorEmpty((CharSequence)accountThreePassword, (String)"accountThreePassword must not be null nor empty");
            return this;
        }

        public Builder setServiceTlsPin(String tlsPin) {
            this.serviceTlsPin = tlsPin;
            return this;
        }

        public Builder setSecurityMode(String securityModeString) {
            this.securityMode = securityModeString != null ? ConnectionConfiguration.SecurityMode.valueOf((String)securityModeString) : ConnectionConfiguration.SecurityMode.required;
            return this;
        }

        public Builder setReplyTimeout(String timeout) {
            if (timeout != null) {
                this.replyTimeout = Integer.valueOf(timeout);
            }
            return this;
        }

        public Builder setDebugger(String debuggerString) {
            if (debuggerString == null) {
                return this;
            }
            switch (debuggerString) {
                case "false": {
                    LOGGER.warning("Debug string \"" + debuggerString + "\" is deprecated, please use \"none\" instead");
                }
                case "none": {
                    this.debugger = Debugger.none;
                    break;
                }
                case "true": {
                    LOGGER.warning("Debug string \"" + debuggerString + "\" is deprecated, please use \"console\" instead");
                }
                case "console": {
                    this.debugger = Debugger.console;
                    break;
                }
                case "enhanced": {
                    this.debugger = Debugger.enhanced;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized debugger string: " + debuggerString);
                }
            }
            return this;
        }

        public Builder setEnabledTests(String enabledTestsString) {
            this.enabledTests = Configuration.getTestSetFrom(enabledTestsString);
            return this;
        }

        public Builder setDisabledTests(String disabledTestsString) {
            this.disabledTests = Configuration.getTestSetFrom(disabledTestsString);
            return this;
        }

        public Builder setDefaultConnection(String defaultConnectionNickname) {
            this.defaultConnectionNickname = defaultConnectionNickname;
            return this;
        }

        public Builder setEnabledConnections(String enabledConnectionsString) {
            this.enabledConnections = Configuration.split(enabledConnectionsString);
            return this;
        }

        public Builder setDisabledConnections(String disabledConnectionsString) {
            this.disabledConnections = Configuration.split(disabledConnectionsString);
            return this;
        }

        public Builder addTestPackages(String testPackagesString) {
            if (testPackagesString != null) {
                String[] testPackagesArray = testPackagesString.split(",");
                this.ensureTestPackagesIsSet(testPackagesArray.length);
                for (String s : testPackagesArray) {
                    this.testPackages.add(s.trim());
                }
            }
            return this;
        }

        public Builder addTestPackages(String[] testPackagesString) {
            if (testPackagesString == null) {
                return this;
            }
            this.ensureTestPackagesIsSet(testPackagesString.length);
            for (String testPackage : testPackagesString) {
                this.testPackages.add(testPackage);
            }
            return this;
        }

        public Builder setVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder setVerbose(String verboseBooleanString) {
            if (verboseBooleanString == null) {
                return this;
            }
            boolean verbose = ParserUtils.parseXmlBoolean((String)verboseBooleanString);
            return this.setVerbose(verbose);
        }

        public Builder setDnsResolver(DnsResolver dnsResolver) {
            this.dnsResolver = (DnsResolver)((Object)Objects.requireNonNull((Object)((Object)dnsResolver)));
            return this;
        }

        public Builder setDnsResolver(String dnsResolverString) {
            if (dnsResolverString == null) {
                return this;
            }
            DnsResolver dnsResolver = DnsResolver.valueOf(dnsResolverString);
            return this.setDnsResolver(dnsResolver);
        }

        public Configuration build() throws KeyManagementException, NoSuchAlgorithmException {
            return new Configuration(this);
        }
    }

    public static enum DnsResolver {
        minidns,
        javax,
        dnsjava;

    }

    public static enum Debugger {
        none,
        console,
        enhanced;

    }

    public static enum AccountRegistration {
        disabled,
        inBandRegistration,
        serviceAdministration;

    }
}

