/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mam;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.MessageWithBodiesFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.mam.MamManager;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;

public class MamIntegrationTest
extends AbstractSmackIntegrationTest {
    private final MamManager mamManagerConTwo;

    public MamIntegrationTest(SmackIntegrationTestEnvironment environment) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException, SmackException.NotLoggedInException {
        super(environment);
        this.mamManagerConTwo = MamManager.getInstanceFor((XMPPConnection)this.conTwo);
        if (!this.mamManagerConTwo.isSupported()) {
            throw new TestNotPossibleException("Message Archive Management (XEP-0313) is not supported by the server.");
        }
        try {
            this.mamManagerConTwo.enableMamForAllMessages();
        }
        catch (XMPPException.XMPPErrorException e) {
            if (e.getStanzaError().getCondition() != StanzaError.Condition.feature_not_implemented) {
                throw e;
            }
            LOGGER.log(Level.INFO, this.conTwo.getXMPPServiceDomain() + " doesn't support XEP-0441: Message Archive Management Preferences", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mamTest() throws TimeoutException, Exception {
        EntityBareJid userOne = this.conOne.getUser().asEntityBareJid();
        EntityBareJid userTwo = this.conTwo.getUser().asEntityBareJid();
        final String messageBody = "Test MAM message (" + this.testRunId + ")";
        Message message = ((MessageBuilder)this.conTwo.getStanzaFactory().buildMessageStanza().to((Jid)userTwo)).setBody(messageBody).build();
        String messageId = message.getStanzaId();
        final SimpleResultSyncPoint messageReceived = new SimpleResultSyncPoint();
        StanzaListener stanzaListener = new StanzaListener(){

            public void processStanza(Stanza stanza) {
                Message message = (Message)stanza;
                if (message.getBody().equals(messageBody)) {
                    messageReceived.signal();
                }
            }
        };
        this.conTwo.addAsyncStanzaListener(stanzaListener, MessageWithBodiesFilter.INSTANCE);
        try {
            this.conOne.sendStanza((Stanza)message);
            messageReceived.waitForResult(this.timeout);
        }
        finally {
            this.conTwo.removeAsyncStanzaListener(stanzaListener);
        }
        MamManager.MamQueryArgs mamQueryArgs = MamManager.MamQueryArgs.builder().setResultPageSizeTo(1).limitResultsToJid((Jid)userOne).queryLastPage().build();
        MamManager.MamQuery mamQuery = this.mamManagerConTwo.queryArchive(mamQueryArgs);
        Assertions.assertEquals((int)1, (int)mamQuery.getMessages().size());
        Message mamMessage = (Message)mamQuery.getMessages().get(0);
        Assertions.assertEquals((Object)messageId, (Object)mamMessage.getStanzaId());
        Assertions.assertEquals((Object)messageBody, (Object)mamMessage.getBody());
        Assertions.assertEquals((Object)this.conOne.getUser(), (Object)mamMessage.getFrom());
        Assertions.assertEquals((Object)userTwo, (Object)mamMessage.getTo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mamPageTest() throws TimeoutException, Exception {
        int messagesPerPage = 10;
        int numPages = 3;
        int totalMessages = 30;
        ArrayList<Message> outgoingMessages = new ArrayList<Message>(30);
        EntityBareJid userOne = this.conOne.getUser().asEntityBareJid();
        EntityBareJid userTwo = this.conTwo.getUser().asEntityBareJid();
        final SimpleResultSyncPoint allMessagesReceived = new SimpleResultSyncPoint();
        String lastMessageArchiveUid = this.mamManagerConTwo.getMessageUidOfLatestMessage();
        for (int i = 0; i < 30; ++i) {
            String messageBody = "MAM Page Test " + this.testRunId + " " + (i + 1);
            Message message = ((MessageBuilder)StanzaBuilder.buildMessage().to((Jid)userTwo)).setBody(messageBody).build();
            outgoingMessages.add(message);
        }
        final String lastBody = ((Message)outgoingMessages.get(outgoingMessages.size() - 1)).getBody();
        StanzaListener stanzaListener = new StanzaListener(){

            public void processStanza(Stanza stanza) {
                Message message = (Message)stanza;
                if (message.getBody().equals(lastBody)) {
                    allMessagesReceived.signal();
                }
            }
        };
        this.conTwo.addAsyncStanzaListener(stanzaListener, MessageWithBodiesFilter.INSTANCE);
        try {
            for (Message message : outgoingMessages) {
                this.conOne.sendStanza((Stanza)message);
            }
            allMessagesReceived.waitForResult(this.timeout);
        }
        finally {
            this.conTwo.removeAsyncStanzaListener(stanzaListener);
        }
        MamManager.MamQueryArgs mamQueryArgs = MamManager.MamQueryArgs.builder().setResultPageSize(Integer.valueOf(10)).limitResultsToJid((Jid)userOne).afterUid(lastMessageArchiveUid).build();
        MamManager.MamQuery mamQuery = this.mamManagerConTwo.queryArchive(mamQueryArgs);
        Assertions.assertFalse((boolean)mamQuery.isComplete());
        Assertions.assertEquals((int)10, (int)mamQuery.getMessageCount());
        ArrayList<Object> pages = new ArrayList<Object>(3);
        pages.add(mamQuery.getMessages());
        for (int additionalPageRequestNum = 0; additionalPageRequestNum < 2; ++additionalPageRequestNum) {
            boolean bl;
            List page = mamQuery.pageNext(10);
            boolean bl2 = bl = additionalPageRequestNum == 1;
            if (bl) {
                Assertions.assertTrue((boolean)mamQuery.isComplete());
            } else {
                Assertions.assertFalse((boolean)mamQuery.isComplete());
            }
            Assertions.assertEquals((int)10, (int)page.size());
            pages.add(page);
        }
        ArrayList queriedMessages = new ArrayList(30);
        for (List list : pages) {
            queriedMessages.addAll(list);
        }
        Assertions.assertEquals((int)outgoingMessages.size(), (int)queriedMessages.size());
        for (int i = 0; i < outgoingMessages.size(); ++i) {
            Message message = (Message)outgoingMessages.get(i);
            Message queriedMessage = (Message)queriedMessages.get(i);
            Assertions.assertEquals((Object)message.getBody(), (Object)queriedMessage.getBody());
        }
    }
}

