/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mood;

import java.util.concurrent.TimeoutException;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.annotations.AfterClass;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.util.IntegrationTestRosterUtil;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.disco.EntityCapabilitiesChangedListener;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.mood.Mood;
import org.jivesoftware.smackx.mood.MoodManager;
import org.jivesoftware.smackx.mood.element.MoodElement;
import org.jivesoftware.smackx.pep.PepEventListener;
import org.junit.jupiter.api.Assertions;

public class MoodIntegrationTest
extends AbstractSmackIntegrationTest {
    private final MoodManager mm1;
    private final MoodManager mm2;

    public MoodIntegrationTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
        this.mm1 = MoodManager.getInstanceFor((XMPPConnection)this.conOne);
        this.mm2 = MoodManager.getInstanceFor((XMPPConnection)this.conTwo);
    }

    @AfterClass
    public void unsubscribe() throws SmackException.NotLoggedInException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        IntegrationTestRosterUtil.ensureBothAccountsAreNotInEachOthersRoster(this.conOne, this.conTwo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void testNotification() throws Exception {
        Mood data = Mood.satisfied;
        IntegrationTestRosterUtil.ensureBothAccountsAreSubscribedToEachOther(this.conOne, this.conTwo, this.timeout);
        SimpleResultSyncPoint moodReceived = new SimpleResultSyncPoint();
        PepEventListener moodListener = (jid, moodElement, id, message) -> {
            if (moodElement.getMood().equals((Object)data)) {
                moodReceived.signal();
            }
        };
        try {
            this.registerListenerAndWait(this.mm2, ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.conTwo), (PepEventListener<MoodElement>)moodListener);
            this.mm1.setMood(data);
            try {
                moodReceived.waitForResult(this.timeout);
            }
            catch (TimeoutException e) {
                Assertions.fail((String)"Expected to receive a PEP notification, but did not.");
            }
        }
        finally {
            this.unregisterListener(this.mm2, (PepEventListener<MoodElement>)moodListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void testNotificationAfterFilterChange() throws Exception {
        Mood data = Mood.cautious;
        IntegrationTestRosterUtil.ensureBothAccountsAreSubscribedToEachOther(this.conOne, this.conTwo, this.timeout);
        SimpleResultSyncPoint moodReceived = new SimpleResultSyncPoint();
        PepEventListener moodListener = (jid, moodElement, id, message) -> {
            if (moodElement.getMood().equals((Object)data)) {
                moodReceived.signal();
            }
        };
        try {
            this.publishAndWait(this.mm1, ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.conOne), data);
            this.registerListenerAndWait(this.mm2, ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.conTwo), (PepEventListener<MoodElement>)moodListener);
            try {
                Object result = moodReceived.waitForResult(this.timeout);
                Assertions.assertNotNull(result, (String)"Expected to receive a PEP notification, but did not.");
            }
            catch (TimeoutException e) {
                Assertions.fail((String)"Expected to receive a PEP notification, but did not.");
            }
        }
        finally {
            this.unregisterListener(this.mm2, (PepEventListener<MoodElement>)moodListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListenerAndWait(MoodManager moodManager, ServiceDiscoveryManager discoManager, PepEventListener<MoodElement> listener) throws Exception {
        SimpleResultSyncPoint notificationFilterReceived = new SimpleResultSyncPoint();
        EntityCapabilitiesChangedListener notificationFilterReceivedListener = info -> {
            if (info.containsFeature((CharSequence)"http://jabber.org/protocol/mood+notify")) {
                notificationFilterReceived.signal();
            }
        };
        discoManager.addEntityCapabilitiesChangedListener(notificationFilterReceivedListener);
        try {
            moodManager.addMoodListener(listener);
            notificationFilterReceived.waitForResult(this.timeout);
        }
        finally {
            discoManager.removeEntityCapabilitiesChangedListener(notificationFilterReceivedListener);
        }
    }

    public void unregisterListener(MoodManager moodManager, PepEventListener<MoodElement> listener) {
        moodManager.removeMoodListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishAndWait(MoodManager moodManager, ServiceDiscoveryManager discoManager, Mood data) throws Exception {
        SimpleResultSyncPoint publicationEchoReceived = new SimpleResultSyncPoint();
        PepEventListener publicationEchoListener = (jid, moodElement, id, message) -> {
            if (moodElement.getMood().equals((Object)data)) {
                publicationEchoReceived.signal();
            }
        };
        try {
            this.registerListenerAndWait(moodManager, discoManager, (PepEventListener<MoodElement>)publicationEchoListener);
            moodManager.addMoodListener(publicationEchoListener);
            moodManager.setMood(data);
        }
        finally {
            moodManager.removeMoodListener(publicationEchoListener);
        }
    }
}

