/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.List;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Domainpart;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;

public class AbstractMultiUserChatIntegrationTest
extends AbstractSmackIntegrationTest {
    final String randomString = StringUtils.insecureRandomString((int)6);
    final MultiUserChatManager mucManagerOne = MultiUserChatManager.getInstanceFor((XMPPConnection)this.conOne);
    final MultiUserChatManager mucManagerTwo = MultiUserChatManager.getInstanceFor((XMPPConnection)this.conTwo);
    final MultiUserChatManager mucManagerThree = MultiUserChatManager.getInstanceFor((XMPPConnection)this.conThree);
    final DomainBareJid mucService;

    public AbstractMultiUserChatIntegrationTest(SmackIntegrationTestEnvironment environment) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException {
        super(environment);
        List services = this.mucManagerOne.getMucServiceDomains();
        if (services.isEmpty()) {
            throw new TestNotPossibleException("No MUC (XEP-45) service found");
        }
        this.mucService = (DomainBareJid)services.get(0);
    }

    public EntityBareJid getRandomRoom(String prefix) throws XmppStringprepException {
        String roomNameLocal = String.join((CharSequence)"-", prefix, this.testRunId, StringUtils.insecureRandomString((int)6));
        return JidCreate.entityBareFrom((Localpart)Localpart.from((String)roomNameLocal), (Domainpart)this.mucService.getDomain());
    }

    static void tryDestroy(MultiUserChat muc) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (muc == null) {
            return;
        }
        muc.destroy("test fixture teardown", null);
    }

    static void createMuc(MultiUserChat muc, Resourcepart resourceName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException {
        muc.create(resourceName).makeInstant();
    }

    static void createMuc(MultiUserChat muc, String nickname) throws XmppStringprepException, MultiUserChatException.MucAlreadyJoinedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, SmackException.NoResponseException, InterruptedException, MultiUserChatException.NotAMucServiceException {
        AbstractMultiUserChatIntegrationTest.createMuc(muc, Resourcepart.from((String)nickname));
    }

    static void createMembersOnlyMuc(MultiUserChat muc, Resourcepart resourceName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.MucConfigurationNotSupportedException, MultiUserChatException.NotAMucServiceException {
        muc.create(resourceName).getConfigFormManager().makeMembersOnly().submitConfigurationForm();
    }

    static void createModeratedMuc(MultiUserChat muc, Resourcepart resourceName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException, MultiUserChatException.MucConfigurationNotSupportedException {
        muc.create(resourceName).getConfigFormManager().makeModerated().submitConfigurationForm();
    }

    static void createHiddenMuc(MultiUserChat muc, Resourcepart resourceName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException, XmppStringprepException, MultiUserChatException.MucConfigurationNotSupportedException {
        muc.create(resourceName).getConfigFormManager().makeHidden().submitConfigurationForm();
    }
}

