/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.Map;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.muc.AbstractMultiUserChatIntegrationTest;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.parts.Resourcepart;

public class MultiUserChatEntityIntegrationTest
extends AbstractMultiUserChatIntegrationTest {
    public MultiUserChatEntityIntegrationTest(SmackIntegrationTestEnvironment environment) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException {
        super(environment);
    }

    @SmackIntegrationTest
    public void mucTestForDiscoveringFeatures() throws Exception {
        DiscoverInfo info = this.mucManagerOne.getMucServiceDiscoInfo((DomainBareJid)this.mucManagerOne.getMucServiceDomains().get(0));
        Assertions.assertTrue((info.getIdentities().size() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((info.getFeatures().size() > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucTestForDiscoveringRooms() throws Exception {
        Map rooms;
        EntityBareJid mucAddressPublic = this.getRandomRoom("smack-inttest-publicroom");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddressPublic);
        EntityBareJid mucAddressHidden = this.getRandomRoom("smack-inttest-hiddenroom");
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddressHidden);
        MultiUserChatEntityIntegrationTest.createMuc(mucAsSeenByOne, Resourcepart.from((String)("one-" + this.randomString)));
        try {
            MultiUserChatEntityIntegrationTest.createHiddenMuc(mucAsSeenByTwo, Resourcepart.from((String)("two-" + this.randomString)));
            rooms = this.mucManagerThree.getRoomsHostedBy(this.mucService);
        }
        finally {
            MultiUserChatEntityIntegrationTest.tryDestroy(mucAsSeenByOne);
            MultiUserChatEntityIntegrationTest.tryDestroy(mucAsSeenByTwo);
        }
        Assertions.assertTrue((boolean)rooms.containsKey(mucAddressPublic));
        Assertions.assertFalse((boolean)rooms.containsKey(mucAddressHidden));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucTestForDiscoveringRoomInfo() throws Exception {
        DiscoverInfo discoInfo;
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-discoinfo");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChatEntityIntegrationTest.createMuc(mucAsSeenByOne, Resourcepart.from((String)("one-" + this.randomString)));
        try {
            discoInfo = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.conOne).discoverInfo((Jid)mucAddress);
        }
        finally {
            MultiUserChatEntityIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
        Assertions.assertTrue((discoInfo.getIdentities().size() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((discoInfo.getFeatures().size() > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucTestForDiscoveringRoomItems() throws Exception {
        DiscoverItems roomItems;
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-discoitems");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChatEntityIntegrationTest.createMuc(mucAsSeenByOne, Resourcepart.from((String)("one-" + this.randomString)));
        try {
            roomItems = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.conTwo).discoverItems((Jid)mucAddress);
        }
        finally {
            MultiUserChatEntityIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
        Assertions.assertEquals((int)1, (int)roomItems.getItems().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucTestForRejectingDiscoOnRoomOccupantByNonOccupant() throws Exception {
        StanzaError.Condition expectedCondition;
        XMPPException.XMPPErrorException xe;
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-discoitems");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        Resourcepart nicknameOne = Resourcepart.from((String)("one-" + this.randomString));
        MultiUserChatEntityIntegrationTest.createMuc(mucAsSeenByOne, nicknameOne);
        EntityFullJid mucAsSeenByOneUserJid = mucAsSeenByOne.getMyRoomJid();
        if (mucAsSeenByOneUserJid == null) {
            throw new AssertionError();
        }
        try {
            xe = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.conTwo).discoverItems((Jid)mucAsSeenByOneUserJid));
        }
        finally {
            MultiUserChatEntityIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
        switch (this.sinttestConfiguration.compatibilityMode) {
            default: {
                expectedCondition = StanzaError.Condition.bad_request;
                break;
            }
            case ejabberd: {
                expectedCondition = StanzaError.Condition.not_acceptable;
            }
        }
        Assertions.assertEquals((Object)xe.getStanzaError().getCondition(), (Object)expectedCondition);
    }
}

