/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.concurrent.TimeoutException;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.util.ResultSyncPoint;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.muc.AbstractMultiUserChatIntegrationTest;
import org.jivesoftware.smackx.muc.DefaultUserStatusListener;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.parts.Resourcepart;

public class MultiUserChatIntegrationTest
extends AbstractMultiUserChatIntegrationTest {
    public MultiUserChatIntegrationTest(SmackIntegrationTestEnvironment environment) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException {
        super(environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucJoinTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-join");
        MultiUserChat muc = this.mucManagerOne.getMultiUserChat(mucAddress);
        try {
            Presence reflectedJoinPresence = muc.join(Resourcepart.from((String)"nick-one"));
            MUCUser mucUser = MUCUser.from((Stanza)reflectedJoinPresence);
            Assertions.assertNotNull((Object)mucUser);
            Assertions.assertTrue((boolean)mucUser.getStatus().contains(MUCUser.Status.PRESENCE_TO_SELF_110));
            Assertions.assertEquals((Object)(mucAddress + "/nick-one"), (Object)reflectedJoinPresence.getFrom().toString());
            Assertions.assertEquals((Object)this.conOne.getUser().asEntityFullJidIfPossible().toString(), (Object)reflectedJoinPresence.getTo().toString());
        }
        finally {
            MultiUserChatIntegrationTest.tryDestroy(muc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucLeaveTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-leave");
        MultiUserChat muc = this.mucManagerOne.getMultiUserChat(mucAddress);
        try {
            muc.join(Resourcepart.from((String)"nick-one"));
            Presence reflectedLeavePresence = muc.leave();
            MUCUser mucUser = MUCUser.from((Stanza)reflectedLeavePresence);
            Assertions.assertNotNull((Object)mucUser);
            Assertions.assertTrue((boolean)mucUser.getStatus().contains(MUCUser.Status.PRESENCE_TO_SELF_110));
            Assertions.assertEquals((Object)(mucAddress + "/nick-one"), (Object)reflectedLeavePresence.getFrom().toString());
            Assertions.assertEquals((Object)this.conOne.getUser().asEntityFullJidIfPossible().toString(), (Object)reflectedLeavePresence.getTo().toString());
        }
        finally {
            muc.join(Resourcepart.from((String)"nick-one"));
            MultiUserChatIntegrationTest.tryDestroy(muc);
        }
    }

    @SmackIntegrationTest
    public void mucTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-message");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        final String mucMessage = "Smack Integration Test MUC Test Message " + this.randomString;
        final ResultSyncPoint resultSyncPoint = new ResultSyncPoint();
        mucAsSeenByTwo.addMessageListener(new MessageListener(){

            public void processMessage(Message message) {
                String body = message.getBody();
                if (mucMessage.equals(body)) {
                    resultSyncPoint.signal(body);
                }
            }
        });
        MultiUserChatIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        mucAsSeenByTwo.join(Resourcepart.from((String)("two-" + this.randomString)));
        mucAsSeenByOne.sendMessage(mucMessage);
        try {
            resultSyncPoint.waitForResult(this.timeout);
        }
        catch (TimeoutException e) {
            throw new AssertionError("Failed to receive presence", e);
        }
        finally {
            MultiUserChatIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucDestroyTest() throws TimeoutException, Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-destroy");
        MultiUserChat muc = this.mucManagerOne.getMultiUserChat(mucAddress);
        muc.join(Resourcepart.from((String)"nick-one"));
        final SimpleResultSyncPoint mucDestroyed = new SimpleResultSyncPoint();
        DefaultUserStatusListener userStatusListener = new DefaultUserStatusListener(){

            public void roomDestroyed(MultiUserChat alternateMUC, String reason) {
                mucDestroyed.signal();
            }
        };
        muc.addUserStatusListener((UserStatusListener)userStatusListener);
        Assertions.assertEquals((int)1, (int)this.mucManagerOne.getJoinedRooms().size());
        Assertions.assertEquals((int)1, (int)muc.getOccupantsCount());
        Assertions.assertNotNull((Object)muc.getNickname());
        try {
            muc.destroy("Dummy reason", null);
            mucDestroyed.waitForResult(this.timeout);
        }
        finally {
            muc.removeUserStatusListener((UserStatusListener)userStatusListener);
        }
        Assertions.assertEquals((int)0, (int)this.mucManagerOne.getJoinedRooms().size());
        Assertions.assertEquals((int)0, (int)muc.getOccupantsCount());
        Assertions.assertNull((Object)muc.getNickname());
    }
}

