/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.util.ResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.muc.AbstractMultiUserChatIntegrationTest;
import org.jivesoftware.smackx.muc.MUCAffiliation;
import org.jivesoftware.smackx.muc.MUCRole;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;

public class MultiUserChatRolesAffiliationsPrivilegesIntegrationTest
extends AbstractMultiUserChatIntegrationTest {
    public MultiUserChatRolesAffiliationsPrivilegesIntegrationTest(SmackIntegrationTestEnvironment environment) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException {
        super(environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucRoleTestForReceivingModerator() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        final ResultSyncPoint resultSyncPoint = new ResultSyncPoint();
        mucAsSeenByTwo.addUserStatusListener(new UserStatusListener(){

            public void moderatorGranted() {
                resultSyncPoint.signal("done");
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByOne.grantModerator(nicknameTwo);
            resultSyncPoint.waitForResult(this.timeout);
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucRoleTestForWitnessingModerator() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        final ResultSyncPoint resultSyncPoint = new ResultSyncPoint();
        mucAsSeenByThree.addParticipantStatusListener(new ParticipantStatusListener(){

            public void moderatorGranted(EntityFullJid participant) {
                resultSyncPoint.signal("done");
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            mucAsSeenByOne.grantModerator(nicknameTwo);
            resultSyncPoint.waitForResult(this.timeout);
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucRoleTestForRemovingModerator() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        final ResultSyncPoint resultSyncPoint = new ResultSyncPoint();
        mucAsSeenByTwo.addUserStatusListener(new UserStatusListener(){

            public void moderatorRevoked() {
                resultSyncPoint.signal("done");
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByOne.grantModerator(nicknameTwo);
            mucAsSeenByOne.revokeModerator(nicknameTwo);
            resultSyncPoint.waitForResult(this.timeout);
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucRoleTestForWitnessingModeratorRemoval() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        final ResultSyncPoint resultSyncPoint = new ResultSyncPoint();
        mucAsSeenByThree.addParticipantStatusListener(new ParticipantStatusListener(){

            public void moderatorRevoked(EntityFullJid participant) {
                resultSyncPoint.signal("done");
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            mucAsSeenByOne.grantModerator(nicknameTwo);
            mucAsSeenByOne.revokeModerator(nicknameTwo);
            resultSyncPoint.waitForResult(this.timeout);
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucRoleTestForRevokingVoice() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        final ResultSyncPoint resultSyncPoint = new ResultSyncPoint();
        mucAsSeenByTwo.addUserStatusListener(new UserStatusListener(){

            public void voiceRevoked() {
                resultSyncPoint.signal("done");
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByOne.revokeVoice(nicknameTwo);
            resultSyncPoint.waitForResult(this.timeout);
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucRoleTestForWitnessingRevokingVoice() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        final ResultSyncPoint resultSyncPoint = new ResultSyncPoint();
        mucAsSeenByThree.addParticipantStatusListener(new ParticipantStatusListener(){

            public void voiceRevoked(EntityFullJid participant) {
                resultSyncPoint.signal("done");
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            mucAsSeenByOne.revokeVoice(nicknameTwo);
            resultSyncPoint.waitForResult(this.timeout);
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucAffiliationTestForReceivingAdmin() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        final ResultSyncPoint resultSyncPoint = new ResultSyncPoint();
        mucAsSeenByTwo.addUserStatusListener(new UserStatusListener(){

            public void adminGranted() {
                resultSyncPoint.signal("done");
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByOne.grantAdmin((Jid)this.conTwo.getUser().asBareJid());
            resultSyncPoint.waitForResult(this.timeout);
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucAffiliationTestForWitnessingAdmin() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        final ResultSyncPoint resultSyncPoint = new ResultSyncPoint();
        mucAsSeenByThree.addParticipantStatusListener(new ParticipantStatusListener(){

            public void adminGranted(EntityFullJid participant) {
                resultSyncPoint.signal("done");
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            mucAsSeenByOne.grantAdmin((Jid)this.conTwo.getUser().asBareJid());
            resultSyncPoint.waitForResult(this.timeout);
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucAffiliationTestForRemovingAdmin() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        final ResultSyncPoint resultSyncPoint = new ResultSyncPoint();
        mucAsSeenByTwo.addUserStatusListener(new UserStatusListener(){

            public void adminRevoked() {
                resultSyncPoint.signal("done");
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByOne.grantAdmin((Jid)this.conTwo.getUser().asBareJid());
            mucAsSeenByOne.revokeAdmin((EntityJid)this.conTwo.getUser().asEntityBareJid());
            resultSyncPoint.waitForResult(this.timeout);
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucAffiliationTestForWitnessingAdminRemoval() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        final ResultSyncPoint resultSyncPoint = new ResultSyncPoint();
        mucAsSeenByThree.addParticipantStatusListener(new ParticipantStatusListener(){

            public void adminRevoked(EntityFullJid participant) {
                resultSyncPoint.signal("done");
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            mucAsSeenByOne.grantAdmin((Jid)this.conTwo.getUser().asBareJid());
            mucAsSeenByOne.revokeAdmin((EntityJid)this.conTwo.getUser().asEntityBareJid());
            resultSyncPoint.waitForResult(this.timeout);
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucPresenceTestForGettingKicked() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            ResultSyncPoint resultSyncPoint = new ResultSyncPoint();
            mucAsSeenByTwo.addParticipantListener(kickPresence -> resultSyncPoint.signal(kickPresence));
            mucAsSeenByOne.kickParticipant(nicknameTwo, "Nothing personal. Just a test.");
            Presence kickPresence2 = (Presence)resultSyncPoint.waitForResult(this.timeout);
            MUCUser mucUser = MUCUser.from((Stanza)kickPresence2);
            Assertions.assertNotNull((Object)mucUser);
            Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertTrue((boolean)mucUser.getStatus().contains(MUCUser.Status.PRESENCE_TO_SELF_110), (String)"Missing self-presence status code in kick presence"), () -> Assertions.assertTrue((boolean)mucUser.getStatus().contains(MUCUser.Status.KICKED_307), (String)"Missing kick status code in kick presence"), () -> Assertions.assertEquals((Object)MUCRole.none, (Object)mucUser.getItem().getRole(), (String)"Role other than 'none' in kick presence")});
            Jid itemJid = mucUser.getItem().getJid();
            if (itemJid != null) {
                Assertions.assertEquals((Object)this.conTwo.getUser().asEntityFullJidIfPossible(), (Object)itemJid, (String)"Incorrect kicked user in kick presence");
            }
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucPresenceTestForWitnessingKick() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            ResultSyncPoint resultSyncPoint = new ResultSyncPoint();
            mucAsSeenByThree.addParticipantListener(kickPresence -> resultSyncPoint.signal(kickPresence));
            mucAsSeenByOne.kickParticipant(nicknameTwo, "Nothing personal. Just a test.");
            Presence kickPresence2 = (Presence)resultSyncPoint.waitForResult(this.timeout);
            MUCUser mucUser = MUCUser.from((Stanza)kickPresence2);
            Assertions.assertNotNull((Object)mucUser);
            Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertFalse((boolean)mucUser.getStatus().contains(MUCUser.Status.PRESENCE_TO_SELF_110), (String)"Incorrect self-presence status code in kick presence"), () -> Assertions.assertTrue((boolean)mucUser.getStatus().contains(MUCUser.Status.KICKED_307), (String)"Missing kick status code in kick presence"), () -> Assertions.assertEquals((Object)MUCRole.none, (Object)mucUser.getItem().getRole(), (String)"Role other than 'none' in kick presence")});
            Jid itemJid = mucUser.getItem().getJid();
            if (itemJid != null) {
                Assertions.assertEquals((Object)this.conTwo.getUser().asEntityFullJidIfPossible(), (Object)itemJid, (String)"Incorrect kicked user in kick presence");
            }
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucTestPersistentAffiliation() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        Resourcepart nicknameOne = Resourcepart.from((String)("one-" + this.randomString));
        Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
        Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, nicknameOne);
        try {
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            mucAsSeenByOne.grantOwnership((Jid)this.conTwo.getUser().asBareJid());
            mucAsSeenByOne.grantAdmin((Jid)this.conThree.getUser().asBareJid());
            mucAsSeenByTwo.leave();
            mucAsSeenByThree.leave();
            Presence p2 = mucAsSeenByTwo.join(nicknameTwo);
            Presence p3 = mucAsSeenByThree.join(nicknameThree);
            Assertions.assertEquals((Object)MUCAffiliation.owner, (Object)MUCUser.from((Stanza)p2).getItem().getAffiliation());
            Assertions.assertEquals((Object)MUCAffiliation.admin, (Object)MUCUser.from((Stanza)p3).getItem().getAffiliation());
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucTestModeratorCannotRevokeVoiceFromOwner() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        Resourcepart nicknameOne = Resourcepart.from((String)("one-" + this.randomString));
        Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createModeratedMuc(mucAsSeenByOne, nicknameOne);
        try {
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByOne.grantModerator(nicknameTwo);
            XMPPException.XMPPErrorException xe = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> mucAsSeenByTwo.revokeVoice(nicknameOne));
            Assertions.assertEquals((Object)xe.getStanzaError().getCondition().toString(), (Object)"not-allowed");
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucTestModeratorCannotBeRevokedFromHigherAffiliation() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        Resourcepart nicknameOne = Resourcepart.from((String)("one-" + this.randomString));
        Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
        Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createModeratedMuc(mucAsSeenByOne, nicknameOne);
        try {
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            mucAsSeenByOne.grantAdmin((Jid)this.conTwo.getUser().asBareJid());
            mucAsSeenByOne.grantModerator(nicknameThree);
            XMPPException.XMPPErrorException xe1 = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> mucAsSeenByTwo.revokeModerator(nicknameOne));
            XMPPException.XMPPErrorException xe2 = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> mucAsSeenByThree.revokeModerator(nicknameOne));
            XMPPException.XMPPErrorException xe3 = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> mucAsSeenByThree.revokeModerator(nicknameTwo));
            Assertions.assertEquals((Object)xe1.getStanzaError().getCondition().toString(), (Object)"not-allowed");
            Assertions.assertEquals((Object)xe2.getStanzaError().getCondition().toString(), (Object)"not-allowed");
            Assertions.assertEquals((Object)xe3.getStanzaError().getCondition().toString(), (Object)"not-allowed");
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucTestDefaultRoleForAffiliationInUnmoderatedRoom() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-unmoderatedroles");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        Resourcepart nicknameOne = Resourcepart.from((String)("one-" + this.randomString));
        Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
        Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, nicknameOne);
        try {
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            final ResultSyncPoint resultSyncPoint = new ResultSyncPoint();
            mucAsSeenByOne.addParticipantStatusListener(new ParticipantStatusListener(){

                public void adminGranted(EntityFullJid participant) {
                    resultSyncPoint.signal("done");
                }
            });
            mucAsSeenByOne.grantAdmin((Jid)this.conTwo.getUser().asBareJid());
            resultSyncPoint.waitForResult(this.timeout);
            Assertions.assertEquals((int)mucAsSeenByOne.getOccupantsCount(), (int)3);
            Assertions.assertEquals((Object)MUCRole.moderator, (Object)mucAsSeenByOne.getOccupant(JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)nicknameOne)).getRole());
            Assertions.assertEquals((Object)MUCRole.moderator, (Object)mucAsSeenByOne.getOccupant(JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)nicknameTwo)).getRole());
            Assertions.assertEquals((Object)MUCRole.participant, (Object)mucAsSeenByOne.getOccupant(JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)nicknameThree)).getRole());
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucTestDefaultRoleForAffiliationInModeratedRoom() throws Exception {
        MUCRole threeRole;
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-moderatedroles");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        Resourcepart nicknameOne = Resourcepart.from((String)("one-" + this.randomString));
        Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
        Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
        final ResultSyncPoint resultSyncPoint = new ResultSyncPoint();
        mucAsSeenByOne.addParticipantStatusListener(new ParticipantStatusListener(){

            public void adminGranted(EntityFullJid participant) {
                resultSyncPoint.signal("done");
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createModeratedMuc(mucAsSeenByOne, nicknameOne);
        switch (this.sinttestConfiguration.compatibilityMode) {
            default: {
                threeRole = MUCRole.visitor;
                break;
            }
            case ejabberd: {
                threeRole = MUCRole.participant;
            }
        }
        try {
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            mucAsSeenByOne.grantAdmin((Jid)this.conTwo.getUser().asBareJid());
            resultSyncPoint.waitForResult(this.timeout);
            Assertions.assertEquals((int)mucAsSeenByOne.getOccupantsCount(), (int)3);
            Assertions.assertEquals((Object)MUCRole.moderator, (Object)mucAsSeenByOne.getOccupant(JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)nicknameOne)).getRole());
            Assertions.assertEquals((Object)MUCRole.moderator, (Object)mucAsSeenByOne.getOccupant(JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)nicknameTwo)).getRole());
            Assertions.assertEquals((Object)threeRole, (Object)mucAsSeenByOne.getOccupant(JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)nicknameThree)).getRole());
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucTestDefaultRoleForAffiliationInMembersOnlyRoom() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-membersonlyroles");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        Resourcepart nicknameOne = Resourcepart.from((String)("one-" + this.randomString));
        Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
        Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
        EntityFullJid jidOne = JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)nicknameOne);
        EntityFullJid jidTwo = JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)nicknameTwo);
        EntityFullJid jidThree = JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)nicknameThree);
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMembersOnlyMuc(mucAsSeenByOne, nicknameOne);
        final ResultSyncPoint adminResultSyncPoint = new ResultSyncPoint();
        mucAsSeenByOne.addParticipantStatusListener(new ParticipantStatusListener(){

            public void adminGranted(EntityFullJid participant) {
                adminResultSyncPoint.signal("done");
            }
        });
        try {
            mucAsSeenByOne.grantMembership((Jid)this.conTwo.getUser().asBareJid());
            mucAsSeenByOne.grantMembership((Jid)this.conThree.getUser().asBareJid());
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            mucAsSeenByOne.grantAdmin((Jid)this.conTwo.getUser().asBareJid());
            adminResultSyncPoint.waitForResult(this.timeout);
            Assertions.assertEquals((int)mucAsSeenByOne.getOccupantsCount(), (int)3);
            Assertions.assertEquals((Object)MUCRole.moderator, (Object)mucAsSeenByOne.getOccupant(jidOne).getRole());
            Assertions.assertEquals((Object)MUCRole.moderator, (Object)mucAsSeenByOne.getOccupant(jidTwo).getRole());
            Assertions.assertEquals((Object)MUCRole.participant, (Object)mucAsSeenByOne.getOccupant(jidThree).getRole());
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }
}

