/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest.unittest;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.DummySmackIntegrationTestFramework;
import org.igniterealtime.smack.inttest.FailedTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.SmackIntegrationTestFramework;
import org.igniterealtime.smack.inttest.SmackIntegrationTestUnitTestUtil;
import org.igniterealtime.smack.inttest.annotations.AfterClass;
import org.igniterealtime.smack.inttest.annotations.BeforeClass;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.StanzaError;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class SmackIntegrationTestFrameworkUnitTest {
    private static boolean beforeClassInvoked;
    private static boolean afterClassInvoked;

    @BeforeAll
    public static void prepareSinttestUnitTest() {
        SmackIntegrationTestFramework.SINTTEST_UNIT_TEST = true;
    }

    @AfterAll
    public static void disallowSinntestUnitTest() {
        SmackIntegrationTestFramework.SINTTEST_UNIT_TEST = false;
    }

    @Test
    public void throwsRuntimeExceptionsTest() throws KeyManagementException, NoSuchAlgorithmException, SmackException, IOException, XMPPException, InterruptedException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        DummySmackIntegrationTestFramework sinttest = SmackIntegrationTestUnitTestUtil.getFrameworkForUnitTest(ThrowsRuntimeExceptionDummyTest.class);
        Assertions.assertThrows(RuntimeException.class, () -> sinttest.run());
    }

    @Test
    public void logsNonFatalExceptionTest() throws KeyManagementException, NoSuchAlgorithmException, SmackException, IOException, XMPPException, InterruptedException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        DummySmackIntegrationTestFramework sinttest = SmackIntegrationTestUnitTestUtil.getFrameworkForUnitTest(ThrowsNonFatalExceptionDummyTest.class);
        SmackIntegrationTestFramework.TestRunResult testRunResult = sinttest.run();
        List failedTests = testRunResult.getFailedTests();
        Assertions.assertEquals((int)1, (int)failedTests.size());
        FailedTest failedTest = (FailedTest)failedTests.get(0);
        Assertions.assertTrue((boolean)(failedTest.failureReason instanceof XMPPException.XMPPErrorException));
        XMPPException.XMPPErrorException ex = (XMPPException.XMPPErrorException)failedTest.failureReason;
        Assertions.assertEquals((Object)StanzaError.Condition.bad_request, (Object)ex.getStanzaError().getCondition());
        Assertions.assertEquals((Object)"I'm not fatal", (Object)ex.getStanzaError().getDescriptiveText());
    }

    @Test
    public void testInvoking() throws KeyManagementException, NoSuchAlgorithmException, SmackException, IOException, XMPPException, InterruptedException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        beforeClassInvoked = false;
        afterClassInvoked = false;
        DummySmackIntegrationTestFramework sinttest = SmackIntegrationTestUnitTestUtil.getFrameworkForUnitTest(BeforeAfterClassTest.class);
        sinttest.run();
        Assertions.assertTrue((boolean)beforeClassInvoked, (String)"A before class method should have been executed to this time");
        Assertions.assertTrue((boolean)afterClassInvoked, (String)"A after class method should have been executed to this time");
    }

    public static class BeforeAfterClassTest
    extends AbstractSmackIntegrationTest {
        public BeforeAfterClassTest(SmackIntegrationTestEnvironment environment) {
            super(environment);
        }

        @BeforeClass
        public void setUp() {
            beforeClassInvoked = true;
        }

        @AfterClass
        public void tearDown() {
            afterClassInvoked = true;
        }

        @SmackIntegrationTest
        public void test() {
            Assertions.assertTrue((boolean)beforeClassInvoked, (String)"A before class method should have been executed to this time");
            Assertions.assertFalse((boolean)afterClassInvoked, (String)"A after class method shouldn't have been executed to this time");
        }
    }

    public static class ThrowsNonFatalExceptionDummyTest
    extends AbstractSmackIntegrationTest {
        public static final String DESCRIPTIVE_TEXT = "I'm not fatal";

        public ThrowsNonFatalExceptionDummyTest(SmackIntegrationTestEnvironment environment) {
            super(environment);
        }

        @SmackIntegrationTest
        public void throwRuntimeExceptionTest() throws XMPPException.XMPPErrorException {
            Message message = StanzaBuilder.buildMessage().build();
            throw new XMPPException.XMPPErrorException((Stanza)message, StanzaError.from((StanzaError.Condition)StanzaError.Condition.bad_request, (String)DESCRIPTIVE_TEXT).build());
        }
    }

    public static class ThrowsRuntimeExceptionDummyTest
    extends AbstractSmackIntegrationTest {
        public static final String RUNTIME_EXCEPTION_MESSAGE = "Dummy RuntimeException";

        public ThrowsRuntimeExceptionDummyTest(SmackIntegrationTestEnvironment environment) {
            super(environment);
        }

        @SmackIntegrationTest
        public void throwRuntimeExceptionTest() {
            throw new RuntimeException(RUNTIME_EXCEPTION_MESSAGE);
        }
    }
}

