/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands;

import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.commands.AdHocCommand;
import org.jivesoftware.smackx.commands.AdHocCommandHandler;
import org.jivesoftware.smackx.commands.AdHocCommandHandlerFactory;
import org.jivesoftware.smackx.commands.AdHocCommandManager;
import org.jivesoftware.smackx.commands.AdHocCommandResult;
import org.jivesoftware.smackx.commands.packet.AdHocCommandData;
import org.jivesoftware.smackx.commands.packet.AdHocCommandDataBuilder;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.ListSingleFormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.form.FillableForm;
import org.jivesoftware.smackx.xdata.form.SubmitForm;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.Jid;

@SpecificationReference(document="XEP-0050")
public class AdHocCommandIntegrationTest
extends AbstractSmackIntegrationTest {
    public AdHocCommandIntegrationTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void singleStageAdHocCommandTest() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        AdHocCommandManager manOne = AdHocCommandManager.getInstance((XMPPConnection)this.conOne);
        AdHocCommandManager manTwo = AdHocCommandManager.getInstance((XMPPConnection)this.conTwo);
        String commandNode = "test-list";
        String commandName = "Return a list for testing purposes";
        AdHocCommandHandlerFactory factory = (node, name, sessionId) -> new AdHocCommandHandler.SingleStage(node, name, sessionId){

            public AdHocCommandData executeSingleStage(AdHocCommandDataBuilder response) {
                TextSingleFormField field = FormField.textPrivateBuilder((String)"my-field").build();
                DataForm form = DataForm.builder((DataForm.Type)DataForm.Type.result).addField((FormField)field).build();
                response.setForm(form);
                return response.build();
            }
        };
        manOne.registerCommand(commandNode, commandName, factory);
        try {
            AdHocCommand command = manTwo.getRemoteCommand((Jid)this.conOne.getUser(), commandNode);
            AdHocCommandResult result = command.execute();
            AdHocCommandData response = result.getResponse();
            DataForm form = response.getForm();
            FormField field = form.getField("my-field");
            Assertions.assertNotNull((Object)field, (String)("Expected a field named 'my-field' to exist in the form that " + this.conTwo.getUser() + " obtained from " + this.conOne.getUser() + "'s command node '" + commandNode + "' (but it did not)."));
        }
        finally {
            manOne.unregisterCommand(commandNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void multiStageAdHocCommandTest() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        AdHocCommandManager manOne = AdHocCommandManager.getInstance((XMPPConnection)this.conOne);
        AdHocCommandManager manTwo = AdHocCommandManager.getInstance((XMPPConnection)this.conTwo);
        String commandNode = "my-multi-stage-command";
        String commandName = "An example multi-sage ad-hoc command";
        AdHocCommandHandlerFactory factory = (node, name, sessionId) -> new MyMultiStageAdHocCommandServer(node, name, sessionId);
        manOne.registerCommand(commandNode, commandName, factory);
        try {
            AdHocCommand command = manTwo.getRemoteCommand((Jid)this.conOne.getUser(), commandNode);
            AdHocCommandResult.StatusExecuting result = command.execute().asExecutingOrThrow();
            FillableForm form = result.getFillableForm();
            form.setAnswer("a", 42);
            SubmitForm submitForm = form.getSubmitForm();
            result = command.next(submitForm).asExecutingOrThrow();
            form = result.getFillableForm();
            form.setAnswer("b", 23);
            submitForm = form.getSubmitForm();
            result = command.next(submitForm).asExecutingOrThrow();
            form = result.getFillableForm();
            form.setAnswer("op", (CharSequence)"+");
            submitForm = form.getSubmitForm();
            AdHocCommandResult.StatusCompleted completed = command.complete(submitForm).asCompletedOrThrow();
            String operationResult = completed.getResponse().getForm().getField("result").getFirstValue();
            Assertions.assertEquals((Object)"65", (Object)operationResult, (String)("Unexpected value in the field 'result' from the command result that " + this.conTwo.getUser() + " received from " + this.conOne.getUser() + " after completing a multi-staged ad-hoc command on node '" + commandNode + "'."));
        }
        finally {
            manTwo.unregisterCommand(commandNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void multiStageWithPrevAdHocCommandTest() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        AdHocCommandManager manOne = AdHocCommandManager.getInstance((XMPPConnection)this.conOne);
        AdHocCommandManager manTwo = AdHocCommandManager.getInstance((XMPPConnection)this.conTwo);
        String commandNode = "my-multi-stage-with-prev-command";
        String commandName = "An example multi-sage ad-hoc command";
        AdHocCommandHandlerFactory factory = (node, name, sessionId) -> new MyMultiStageAdHocCommandServer(node, name, sessionId);
        manOne.registerCommand(commandNode, commandName, factory);
        try {
            AdHocCommand command = manTwo.getRemoteCommand((Jid)this.conOne.getUser(), commandNode);
            AdHocCommandResult.StatusExecuting result = command.execute().asExecutingOrThrow();
            FillableForm form = result.getFillableForm();
            form.setAnswer("a", 42);
            SubmitForm submitForm = form.getSubmitForm();
            command.next(submitForm).asExecutingOrThrow();
            result = command.prev().asExecutingOrThrow();
            form = result.getFillableForm();
            form.setAnswer("a", 77);
            submitForm = form.getSubmitForm();
            result = command.next(submitForm).asExecutingOrThrow();
            form = result.getFillableForm();
            form.setAnswer("b", 23);
            submitForm = form.getSubmitForm();
            result = command.next(submitForm).asExecutingOrThrow();
            form = result.getFillableForm();
            form.setAnswer("op", (CharSequence)"+");
            submitForm = form.getSubmitForm();
            AdHocCommandResult.StatusCompleted completed = command.complete(submitForm).asCompletedOrThrow();
            String operationResult = completed.getResponse().getForm().getField("result").getFirstValue();
            Assertions.assertEquals((Object)"100", (Object)operationResult, (String)("Unexpected value in the field 'result' from the command result that " + this.conTwo.getUser() + " received from " + this.conOne.getUser() + " after completing a multi-staged ad-hoc command on node '" + commandNode + "'."));
        }
        finally {
            manTwo.unregisterCommand(commandNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void multiStageInvalidArgAdHocCommandTest() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        AdHocCommandManager manOne = AdHocCommandManager.getInstance((XMPPConnection)this.conOne);
        AdHocCommandManager manTwo = AdHocCommandManager.getInstance((XMPPConnection)this.conTwo);
        String commandNode = "my-multi-stage-invalid-arg-command";
        String commandName = "An example multi-sage ad-hoc command";
        AdHocCommandHandlerFactory factory = (node, name, sessionId) -> new MyMultiStageAdHocCommandServer(node, name, sessionId);
        manOne.registerCommand(commandNode, commandName, factory);
        try {
            AdHocCommand command = manTwo.getRemoteCommand((Jid)this.conOne.getUser(), commandNode);
            AdHocCommandResult.StatusExecuting result = command.execute().asExecutingOrThrow();
            FillableForm form = result.getFillableForm();
            form.setAnswer("a", (CharSequence)"forty-two");
            SubmitForm submitForm = form.getSubmitForm();
            XMPPException.XMPPErrorException exception = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> command.next(submitForm));
            Assertions.assertEquals((Object)exception.getStanzaError().getCondition(), (Object)StanzaError.Condition.bad_request, (String)("Unexpected error condition received after " + this.conTwo.getUser() + " supplied an invalid argument to the command node '" + commandNode + "' of " + this.conOne.getUser()));
        }
        finally {
            manTwo.unregisterCommand(commandNode);
        }
    }

    private static class MyMultiStageAdHocCommandServer
    extends AdHocCommandHandler {
        private Integer a;
        private Integer b;
        private static final DataForm dataFormAskingForA = MyMultiStageAdHocCommandServer.createDataForm("a");
        private static final DataForm dataFormAskingForB = MyMultiStageAdHocCommandServer.createDataForm("b");
        private static final DataForm dataFormAskingForOp = MyMultiStageAdHocCommandServer.createDataFormOp();

        private static DataForm createDataForm(String variableName) {
            TextSingleFormField field = ((TextSingleFormField.Builder)FormField.textSingleBuilder((String)variableName).setRequired()).build();
            return DataForm.builder((DataForm.Type)DataForm.Type.form).setTitle("Variable " + variableName).setInstructions("Please provide an integer variable " + variableName).addField((FormField)field).build();
        }

        private static DataForm createDataFormOp() {
            ListSingleFormField field = ((ListSingleFormField.Builder)((ListSingleFormField.Builder)((ListSingleFormField.Builder)((ListSingleFormField.Builder)FormField.listSingleBuilder((String)"op").setLabel("Arithmetic Operation")).setRequired()).addOption("+")).addOption("-")).build();
            return DataForm.builder((DataForm.Type)DataForm.Type.form).setTitle("Operation").setInstructions("Please select the arithmetic operation to be performed with a and b").addField((FormField)field).build();
        }

        MyMultiStageAdHocCommandServer(String node, String name, String sessionId) {
            super(node, name, sessionId);
        }

        protected AdHocCommandData execute(AdHocCommandDataBuilder response) throws XMPPException.XMPPErrorException {
            return response.setForm(dataFormAskingForA).setStatusExecuting(AdHocCommandDataBuilder.PreviousStage.none, AdHocCommandDataBuilder.NextStage.nonFinal).build();
        }

        private static Integer extractIntegerField(SubmitForm form, String fieldName) throws XMPPException.XMPPErrorException {
            FormField field = form.getField(fieldName);
            if (field == null) {
                throw MyMultiStageAdHocCommandServer.newBadRequestException((String)("Submitted form does not contain a field of name " + fieldName));
            }
            String fieldValue = field.getFirstValue();
            if (fieldValue == null) {
                throw MyMultiStageAdHocCommandServer.newBadRequestException((String)("Submitted form contains field of name " + fieldName + " without value"));
            }
            try {
                return Integer.parseInt(fieldValue);
            }
            catch (NumberFormatException e) {
                throw MyMultiStageAdHocCommandServer.newBadRequestException((String)("Submitted form contains field of name " + fieldName + " with value " + fieldValue + " that is not an integer"));
            }
        }

        protected AdHocCommandData next(AdHocCommandDataBuilder response, SubmitForm submittedForm) throws XMPPException.XMPPErrorException {
            DataForm form;
            switch (this.getCurrentStage()) {
                case 2: {
                    this.a = MyMultiStageAdHocCommandServer.extractIntegerField(submittedForm, "a");
                    form = dataFormAskingForB;
                    response.setStatusExecuting(AdHocCommandDataBuilder.PreviousStage.exists, AdHocCommandDataBuilder.NextStage.nonFinal);
                    break;
                }
                case 3: {
                    this.b = MyMultiStageAdHocCommandServer.extractIntegerField(submittedForm, "b");
                    form = dataFormAskingForOp;
                    response.setStatusExecuting(AdHocCommandDataBuilder.PreviousStage.exists, AdHocCommandDataBuilder.NextStage.isFinal);
                    break;
                }
                case 4: {
                    return this.complete(response, submittedForm);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return response.setForm(form).build();
        }

        protected AdHocCommandData complete(AdHocCommandDataBuilder response, SubmitForm submittedForm) throws XMPPException.XMPPErrorException {
            int result;
            String op;
            if (this.getCurrentStage() != 4) {
                throw new IllegalStateException();
            }
            if (this.a == null || this.b == null) {
                throw new IllegalStateException();
            }
            switch (op = submittedForm.getField("op").getFirstValue()) {
                case "+": {
                    result = this.a + this.b;
                    break;
                }
                case "-": {
                    result = this.a - this.b;
                    break;
                }
                default: {
                    throw MyMultiStageAdHocCommandServer.newBadRequestException((String)("Submitted operation " + op + " is neither + nor -"));
                }
            }
            response.setStatusCompleted();
            TextSingleFormField field = ((TextSingleFormField.Builder)FormField.textSingleBuilder((String)"result").setValue(result)).build();
            DataForm form = DataForm.builder((DataForm.Type)DataForm.Type.result).setTitle("Result").addField((FormField)field).build();
            return response.setForm(form).build();
        }

        protected AdHocCommandData prev(AdHocCommandDataBuilder response) throws XMPPException.XMPPErrorException {
            switch (this.getCurrentStage()) {
                case 1: {
                    return this.execute(response);
                }
                case 2: {
                    return response.setForm(dataFormAskingForA).setStatusExecuting(AdHocCommandDataBuilder.PreviousStage.exists, AdHocCommandDataBuilder.NextStage.nonFinal).build();
                }
                case 3: {
                    return response.setForm(dataFormAskingForB).setStatusExecuting(AdHocCommandDataBuilder.PreviousStage.exists, AdHocCommandDataBuilder.NextStage.isFinal).build();
                }
            }
            throw new IllegalStateException();
        }

        public void cancel() {
        }
    }
}

