/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.httpfileupload;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.httpfileupload.HttpFileUploadManager;
import org.jivesoftware.smackx.httpfileupload.UploadProgressListener;
import org.jivesoftware.smackx.httpfileupload.UploadService;
import org.junit.jupiter.api.Assertions;

@SpecificationReference(document="XEP-0363")
public class HttpFileUploadIntegrationTest
extends AbstractSmackIntegrationTest {
    private static final int FILE_SIZE = 131072;
    private final HttpFileUploadManager hfumOne;

    public HttpFileUploadIntegrationTest(SmackIntegrationTestEnvironment environment) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, InterruptedException, TestNotPossibleException {
        super(environment);
        this.hfumOne = HttpFileUploadManager.getInstanceFor((XMPPConnection)this.conOne);
        if (!this.hfumOne.discoverUploadService()) {
            throw new TestNotPossibleException("HttpFileUploadManager was unable to discover a HTTP File Upload service");
        }
        UploadService uploadService = this.hfumOne.getDefaultUploadService();
        if (!uploadService.acceptsFileOfSize(131072L)) {
            throw new TestNotPossibleException("The upload service at " + uploadService.getAddress() + " does not accept files of size 131072. It only accepts files with  a maximum size of " + uploadService.getMaxFileSize());
        }
        if (environment.configuration.sslContextFactory != null) {
            this.hfumOne.setTlsContext(environment.configuration.sslContextFactory.createSslContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void httpFileUploadTest() throws IOException, XMPPException.XMPPErrorException, InterruptedException, SmackException {
        byte[] upBytes;
        int fileSize = 131072;
        File file = this.createNewTempFile();
        try (FileOutputStream fos = new FileOutputStream(file.getCanonicalPath());){
            upBytes = new byte[131072];
            INSECURE_RANDOM.nextBytes(upBytes);
            fos.write(upBytes);
        }
        URL getUrl = this.hfumOne.uploadFile(file, new UploadProgressListener(){

            public void onUploadProgress(long uploadedBytes, long totalBytes) {
                double progress = uploadedBytes / totalBytes;
                LOGGER.fine("HTTP File Upload progress " + progress + "% (" + uploadedBytes + "/" + totalBytes + ")");
            }
        });
        HttpURLConnection urlConnection = this.getHttpUrlConnectionFor(getUrl);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(131072);
        byte[] buffer = new byte[4096];
        try {
            int n;
            BufferedInputStream is = new BufferedInputStream(urlConnection.getInputStream());
            while ((n = ((InputStream)is).read(buffer)) != -1) {
                baos.write(buffer, 0, n);
            }
        }
        finally {
            urlConnection.disconnect();
        }
        byte[] downBytes = baos.toByteArray();
        Assertions.assertArrayEquals((byte[])upBytes, (byte[])downBytes, (String)"Expected the downloaded bytes to be equal to the uploaded bytes (but they were not).");
    }
}

