/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iot;

import java.util.Collection;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.igniterealtime.smack.inttest.util.IntegrationTestRosterUtil;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.iot.Thing;
import org.jivesoftware.smackx.iot.control.IoTControlManager;
import org.jivesoftware.smackx.iot.control.ThingControlRequest;
import org.jivesoftware.smackx.iot.control.element.IoTSetResponse;
import org.jivesoftware.smackx.iot.control.element.SetBoolData;
import org.jivesoftware.smackx.iot.control.element.SetData;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.FullJid;
import org.jxmpp.jid.Jid;

@SpecificationReference(document="XEP-0347")
public class IoTControlIntegrationTest
extends AbstractSmackIntegrationTest {
    private final IoTControlManager IoTControlManagerOne;
    private final IoTControlManager IoTControlManagerTwo;

    public IoTControlIntegrationTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
        this.IoTControlManagerOne = IoTControlManager.getInstanceFor((XMPPConnection)this.conOne);
        this.IoTControlManagerTwo = IoTControlManager.getInstanceFor((XMPPConnection)this.conTwo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void controlTest() throws Exception {
        String key = StringUtils.randomString((int)12);
        String sn = StringUtils.randomString((int)12);
        final SimpleResultSyncPoint syncPoint = new SimpleResultSyncPoint();
        Thing controlThing = Thing.builder().setKey(key).setSerialNumber(sn).setControlRequestHandler(new ThingControlRequest(){

            public void processRequest(Jid from, Collection<SetData> setData) throws XMPPException.XMPPErrorException {
                if (!from.equals((CharSequence)IoTControlIntegrationTest.this.conTwo.getUser())) {
                    return;
                }
                for (SetData data : setData) {
                    SetBoolData boolData;
                    if (!data.getName().equals(IoTControlIntegrationTest.this.testRunId) || !(data instanceof SetBoolData) || !(boolData = (SetBoolData)data).getBooleanValue().booleanValue()) continue;
                    syncPoint.signal();
                    break;
                }
            }
        }).build();
        this.IoTControlManagerOne.installThing(controlThing);
        try {
            IntegrationTestRosterUtil.ensureBothAccountsAreSubscribedToEachOther(this.conOne, this.conTwo, this.timeout);
            SetBoolData data = new SetBoolData(this.testRunId, true);
            IoTSetResponse response = this.IoTControlManagerTwo.setUsingIq((FullJid)this.conOne.getUser(), (SetData)data);
            Assertions.assertNotNull((Object)response, (String)("Expected " + this.conOne.getUser() + " to receive an IQ response with an 'setResponse' child element, but no such response was received."));
        }
        finally {
            this.IoTControlManagerOne.uninstallThing(controlThing);
            IntegrationTestRosterUtil.ensureBothAccountsAreNotInEachOthersRoster(this.conOne, this.conTwo);
        }
        syncPoint.waitForResult(this.timeout);
    }
}

