/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.Map;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.muc.AbstractMultiUserChatIntegrationTest;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.parts.Resourcepart;

@SpecificationReference(document="XEP-0045")
public class MultiUserChatEntityIntegrationTest
extends AbstractMultiUserChatIntegrationTest {
    public MultiUserChatEntityIntegrationTest(SmackIntegrationTestEnvironment environment) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException {
        super(environment);
    }

    @SmackIntegrationTest(section="6.2", quote="An entity may wish to discover if a service implements the Multi-User Chat protocol; in order to do so, it sends a service discovery information (\"disco#info\") query to the MUC service's JID. The service MUST return its identity and the features it supports.")
    public void mucTestForDiscoveringFeatures() throws Exception {
        DomainBareJid mucServiceAddress = (DomainBareJid)this.mucManagerOne.getMucServiceDomains().get(0);
        DiscoverInfo info = this.mucManagerOne.getMucServiceDiscoInfo(mucServiceAddress);
        Assertions.assertFalse((boolean)info.getIdentities().isEmpty(), (String)("Expected the service discovery information for service " + mucServiceAddress + " to include identities (but it did not)."));
        Assertions.assertFalse((boolean)info.getFeatures().isEmpty(), (String)("Expected the service discovery information for service " + mucServiceAddress + " to include features (but it did not)."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="6.3", quote="The service discovery items (\"disco#items\") protocol enables an entity to query a service for a list of associated items, which in the case of a chat service would consist of the specific chat rooms hosted by theservice. The service SHOULD return a full list of the public rooms it hosts (i.e., not return any rooms thatare hidden).")
    public void mucTestForDiscoveringRooms() throws Exception {
        Map rooms;
        EntityBareJid mucAddressPublic = this.getRandomRoom("smack-inttest-publicroom");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddressPublic);
        EntityBareJid mucAddressHidden = this.getRandomRoom("smack-inttest-hiddenroom");
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddressHidden);
        MultiUserChatEntityIntegrationTest.createMuc(mucAsSeenByOne, Resourcepart.from((String)("one-" + this.randomString)));
        try {
            MultiUserChatEntityIntegrationTest.createHiddenMuc(mucAsSeenByTwo, Resourcepart.from((String)("two-" + this.randomString)));
            rooms = this.mucManagerThree.getRoomsHostedBy(this.mucService);
        }
        finally {
            MultiUserChatEntityIntegrationTest.tryDestroy(mucAsSeenByOne);
            MultiUserChatEntityIntegrationTest.tryDestroy(mucAsSeenByTwo);
        }
        Assertions.assertTrue((boolean)rooms.containsKey(mucAddressPublic), (String)("Expected the disco response from " + this.mucService + " to include the public room " + mucAddressPublic + " (but it did not)."));
        Assertions.assertFalse((boolean)rooms.containsKey(mucAddressHidden), (String)("Expected the disco response from " + this.mucService + " to not include the hidden room " + mucAddressHidden + " (but it did)."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="6.4", quote="Using the disco#info protocol, an entity may also query a specific chat room for more detailed information about the room....The room MUST return its identity and SHOULD return the features it supports")
    public void mucTestForDiscoveringRoomInfo() throws Exception {
        DiscoverInfo discoInfo;
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-discoinfo");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChatEntityIntegrationTest.createMuc(mucAsSeenByOne, Resourcepart.from((String)("one-" + this.randomString)));
        try {
            discoInfo = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.conOne).discoverInfo((Jid)mucAddress);
        }
        finally {
            MultiUserChatEntityIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
        Assertions.assertFalse((boolean)discoInfo.getIdentities().isEmpty(), (String)("Expected the service discovery information for room " + mucAddress + " to include identities (but it did not)."));
        Assertions.assertFalse((boolean)discoInfo.getFeatures().isEmpty(), (String)("Expected the service discovery information for room " + mucAddress + " to include features (but it did not)."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="6.5", quote="An entity MAY also query a specific chat room for its associated items. An implementation MAY return a list of existing occupants if that information is publicly available, or return no list at all if this information is kept private.")
    public void mucTestForDiscoveringRoomItems() throws Exception {
        DiscoverItems roomItems;
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-discoitems");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChatEntityIntegrationTest.createMuc(mucAsSeenByOne, Resourcepart.from((String)("one-" + this.randomString)));
        try {
            roomItems = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.conTwo).discoverItems((Jid)mucAddress);
        }
        finally {
            MultiUserChatEntityIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
        Assertions.assertEquals((int)1, (int)roomItems.getItems().size(), (String)("Unexpected amount of disco items for " + mucAddress));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="6.6", quote="If a non-occupant attempts to send a disco request to an address of the form <room@service/nick>, a MUC service MUST return a <bad-request> error")
    public void mucTestForRejectingDiscoOnRoomOccupantByNonOccupant() throws Exception {
        StanzaError.Condition expectedCondition;
        XMPPException.XMPPErrorException xe;
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-discoitems");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        Resourcepart nicknameOne = Resourcepart.from((String)("one-" + this.randomString));
        MultiUserChatEntityIntegrationTest.createMuc(mucAsSeenByOne, nicknameOne);
        EntityFullJid mucAsSeenByOneUserJid = mucAsSeenByOne.getMyRoomJid();
        if (mucAsSeenByOneUserJid == null) {
            throw new AssertionError();
        }
        try {
            xe = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.conTwo).discoverItems((Jid)mucAsSeenByOneUserJid), (String)("Expected an XMPP error when " + this.conTwo.getUser() + " was trying to discover items of " + mucAsSeenByOneUserJid));
        }
        finally {
            MultiUserChatEntityIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
        switch (this.sinttestConfiguration.compatibilityMode) {
            default: {
                expectedCondition = StanzaError.Condition.bad_request;
                break;
            }
            case ejabberd: {
                expectedCondition = StanzaError.Condition.not_acceptable;
            }
        }
        Assertions.assertEquals((Object)xe.getStanzaError().getCondition(), (Object)expectedCondition, (String)("Unexpected error condition in error returned when " + this.conTwo.getUser() + " was trying to discover items of " + mucAsSeenByOneUserJid));
    }
}

