/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.concurrent.TimeoutException;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.muc.AbstractMultiUserChatIntegrationTest;
import org.jivesoftware.smackx.muc.DefaultUserStatusListener;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.parts.Resourcepart;

@SpecificationReference(document="XEP-0045")
public class MultiUserChatIntegrationTest
extends AbstractMultiUserChatIntegrationTest {
    public MultiUserChatIntegrationTest(SmackIntegrationTestEnvironment environment) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException {
        super(environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.2.2", quote="... the service MUST also send presence from the new participant's occupant JID to the full JIDs of all the occupants (including the new occupant)")
    public void mucJoinTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-join");
        MultiUserChat muc = this.mucManagerOne.getMultiUserChat(mucAddress);
        try {
            Presence reflectedJoinPresence = muc.join(Resourcepart.from((String)"nick-one"));
            MUCUser mucUser = MUCUser.from((Stanza)reflectedJoinPresence);
            Assertions.assertNotNull((Object)mucUser, (String)("Expected, but unable, to create a MUCUser instance from reflected join presence: " + reflectedJoinPresence));
            Assertions.assertTrue((boolean)mucUser.getStatus().contains(MUCUser.Status.PRESENCE_TO_SELF_110), (String)("Expected the reflected join presence of " + this.conOne.getUser() + " of room " + mucAddress + " to include 'presence-to-self' (" + MUCUser.Status.PRESENCE_TO_SELF_110 + ") but it did not."));
            Assertions.assertEquals((Object)(mucAddress + "/nick-one"), (Object)reflectedJoinPresence.getFrom().toString(), (String)("Unexpected 'from' attribute value in the reflected join presence of " + this.conOne.getUser() + " of room " + mucAddress));
            Assertions.assertEquals((Object)this.conOne.getUser().asEntityFullJidIfPossible().toString(), (Object)reflectedJoinPresence.getTo().toString(), (String)("Unexpected 'to' attribute value in the reflected join presence of " + this.conOne.getUser() + " of room " + mucAddress));
        }
        finally {
            MultiUserChatIntegrationTest.tryDestroy(muc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.14", quote="The service MUST then send a presence stanzas of type \"unavailable\" from the departing user's occupant JID to the departing occupant's full JIDs, including a status code of \"110\" to indicate that this notification is \"self-presence\"")
    public void mucLeaveTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-leave");
        MultiUserChat muc = this.mucManagerOne.getMultiUserChat(mucAddress);
        try {
            muc.join(Resourcepart.from((String)"nick-one"));
            Presence reflectedLeavePresence = muc.leave();
            MUCUser mucUser = MUCUser.from((Stanza)reflectedLeavePresence);
            Assertions.assertNotNull((Object)mucUser, (String)("Expected, but unable, to create a MUCUser instance from reflected leave presence: " + reflectedLeavePresence));
            Assertions.assertTrue((boolean)mucUser.getStatus().contains(MUCUser.Status.PRESENCE_TO_SELF_110), (String)("Expected the reflected leave presence of " + this.conOne.getUser() + " of room " + mucAddress + " to include 'presence-to-self' (" + MUCUser.Status.PRESENCE_TO_SELF_110 + ") but it did not."));
            Assertions.assertEquals((Object)(mucAddress + "/nick-one"), (Object)reflectedLeavePresence.getFrom().toString(), (String)("Unexpected 'from' attribute value in the reflected leave presence of " + this.conOne.getUser() + " of room " + mucAddress));
            Assertions.assertEquals((Object)this.conOne.getUser().asEntityFullJidIfPossible().toString(), (Object)reflectedLeavePresence.getTo().toString(), (String)("Unexpected 'to' attribute value in the reflected leave presence of " + this.conOne.getUser() + " of room " + mucAddress));
        }
        finally {
            muc.join(Resourcepart.from((String)"nick-one"));
            MultiUserChatIntegrationTest.tryDestroy(muc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-message");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        final String mucMessage = "Smack Integration Test MUC Test Message " + this.randomString;
        final SimpleResultSyncPoint resultSyncPoint = new SimpleResultSyncPoint();
        mucAsSeenByTwo.addMessageListener(new MessageListener(){

            public void processMessage(Message message) {
                String body = message.getBody();
                if (mucMessage.equals(body)) {
                    resultSyncPoint.signal();
                }
            }
        });
        MultiUserChatIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        mucAsSeenByTwo.join(Resourcepart.from((String)("two-" + this.randomString)));
        mucAsSeenByOne.sendMessage(mucMessage);
        try {
            this.assertResult(resultSyncPoint, "Expected " + this.conTwo.getUser() + " to receive message that was sent by " + this.conOne.getUser() + " in room " + mucAddress + " (but it did not).");
        }
        finally {
            MultiUserChatIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="10.9", quote="A room owner MUST be able to destroy a room, especially if the room is persistent... The room removes all users from the room... and destroys the room")
    public void mucDestroyTest() throws TimeoutException, Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-destroy");
        MultiUserChat muc = this.mucManagerOne.getMultiUserChat(mucAddress);
        muc.join(Resourcepart.from((String)"nick-one"));
        final SimpleResultSyncPoint mucDestroyed = new SimpleResultSyncPoint();
        DefaultUserStatusListener userStatusListener = new DefaultUserStatusListener(){

            public void roomDestroyed(MultiUserChat alternateMUC, String reason) {
                mucDestroyed.signal();
            }
        };
        muc.addUserStatusListener((UserStatusListener)userStatusListener);
        if (this.mucManagerOne.getJoinedRooms().size() != 1) {
            throw new IllegalStateException("Expected user to have joined a room.");
        }
        try {
            muc.destroy("Dummy reason", null);
            this.assertResult(mucDestroyed, "Expected " + this.conOne.getUser() + " to be notified of destruction of room " + mucAddress + " (but was not).");
        }
        finally {
            muc.removeUserStatusListener((UserStatusListener)userStatusListener);
        }
        Assertions.assertEquals((int)0, (int)this.mucManagerOne.getJoinedRooms().size(), (String)("Expected " + this.conOne.getUser() + " to no longer be in any rooms after " + mucAddress + " was destroyed (but was)."));
        Assertions.assertEquals((int)0, (int)muc.getOccupantsCount(), (String)("Expected room " + mucAddress + " to no longer have any occupants after it was destroyed (but it has)."));
        Assertions.assertNull((Object)muc.getNickname());
    }
}

