/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.io.IOException;
import org.igniterealtime.smack.inttest.AbstractSmackLowLevelIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.bookmarks.BookmarkManager;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jivesoftware.smackx.muc.bookmarkautojoin.MucBookmarkAutojoinManager;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.jid.parts.Resourcepart;

@SpecificationReference(document="XEP-0048")
public class MultiUserChatLowLevelIntegrationTest
extends AbstractSmackLowLevelIntegrationTest {
    public MultiUserChatLowLevelIntegrationTest(SmackIntegrationTestEnvironment environment) throws Exception {
        super(environment);
        AbstractXMPPConnection connection = this.getConnectedConnection();
        try {
            if (MultiUserChatManager.getInstanceFor((XMPPConnection)connection).getMucServiceDomains().isEmpty()) {
                throw new TestNotPossibleException("MUC component not offered by service");
            }
        }
        finally {
            this.recycle(connection);
        }
    }

    @SmackIntegrationTest
    public void testMucBookmarksAutojoin(AbstractXMPPConnection connection) throws InterruptedException, TestNotPossibleException, XMPPException, SmackException, IOException {
        BookmarkManager bookmarkManager = BookmarkManager.getBookmarkManager((XMPPConnection)connection);
        if (!bookmarkManager.isSupported()) {
            throw new TestNotPossibleException("Private data storage not supported");
        }
        MultiUserChatManager multiUserChatManager = MultiUserChatManager.getInstanceFor((XMPPConnection)connection);
        Resourcepart mucNickname = Resourcepart.from((String)("Nick-" + StringUtils.randomString((int)6)));
        String randomMucName = StringUtils.randomString((int)6);
        DomainBareJid mucComponent = (DomainBareJid)multiUserChatManager.getMucServiceDomains().get(0);
        MultiUserChat muc = multiUserChatManager.getMultiUserChat(JidCreate.entityBareFrom((Localpart)Localpart.from((String)randomMucName), (DomainBareJid)mucComponent));
        MultiUserChat.MucCreateConfigFormHandle handle = muc.createOrJoin(mucNickname);
        if (handle != null) {
            handle.makeInstant();
        }
        muc.leave();
        bookmarkManager.addBookmarkedConference("Smack Inttest: " + this.testRunId, muc.getRoom(), true, mucNickname, null);
        connection.disconnect();
        connection.connect().login();
        MucBookmarkAutojoinManager.getInstanceFor((XMPPConnection)connection).autojoinBookmarkedConferences();
        Assertions.assertTrue((boolean)muc.isJoined(), (String)("Expected " + connection.getUser() + " to automatically join room " + muc.getRoom() + " after a reconnect, but it did not."));
        muc.leave();
    }
}

