/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.concurrent.TimeoutException;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.igniterealtime.smack.inttest.util.ResultSyncPoint;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.muc.AbstractMultiUserChatIntegrationTest;
import org.jivesoftware.smackx.muc.MUCAffiliation;
import org.jivesoftware.smackx.muc.MUCRole;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;

@SpecificationReference(document="XEP-0045")
public class MultiUserChatRolesAffiliationsPrivilegesIntegrationTest
extends AbstractMultiUserChatIntegrationTest {
    public MultiUserChatRolesAffiliationsPrivilegesIntegrationTest(SmackIntegrationTestEnvironment environment) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException {
        super(environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="5.1.3", quote="(\u00a7 5.1.3)... a MUC service implementation MUST change the occupant's role to reflect the change and communicate the change to all occupants [...] (\u00a7 9.6) The service MUST then send updated presence from this individual to all occupants, indicating the addition of moderator status...")
    public void mucRoleTestForReceivingModerator() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        final SimpleResultSyncPoint resultSyncPoint = new SimpleResultSyncPoint();
        mucAsSeenByTwo.addUserStatusListener(new UserStatusListener(){

            public void moderatorGranted() {
                resultSyncPoint.signal();
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByOne.grantModerator(nicknameTwo);
            this.assertResult(resultSyncPoint, "Expected " + this.conTwo.getUser() + " to get a presence update after it was granted the role 'moderator' role in " + mucAddress + " (but it did not).");
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="9.6", quote="(\u00a7 5.1.3)... a MUC service implementation MUST change the occupant's role to reflect the change and communicate the change to all occupants [...] (\u00a7 9.6) The service MUST then send updated presence from this individual to all occupants, indicating the addition of moderator status...")
    public void mucRoleTestForWitnessingModerator() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        final SimpleResultSyncPoint resultSyncPoint = new SimpleResultSyncPoint();
        mucAsSeenByThree.addParticipantStatusListener(new ParticipantStatusListener(){

            public void moderatorGranted(EntityFullJid participant) {
                resultSyncPoint.signal();
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            mucAsSeenByOne.grantModerator(nicknameTwo);
            this.assertResult(resultSyncPoint, "Expected " + this.conThree.getUser() + " to get a presence update after another user in the room was granted the 'moderator' role in " + mucAddress + " (but it did not).");
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="5.1.3", quote="(\u00a7 5.1.3)... a MUC service implementation MUST change the occupant's role to reflect the change and communicate the change to all occupants [...] (\u00a7 9.7) The service MUST then send updated presence from this individual to all occupants, indicating the removal of moderator status...")
    public void mucRoleTestForRemovingModerator() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        final SimpleResultSyncPoint resultSyncPoint = new SimpleResultSyncPoint();
        mucAsSeenByTwo.addUserStatusListener(new UserStatusListener(){

            public void moderatorRevoked() {
                resultSyncPoint.signal();
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByOne.grantModerator(nicknameTwo);
            mucAsSeenByOne.revokeModerator(nicknameTwo);
            this.assertResult(resultSyncPoint, "Expected " + this.conTwo.getUser() + " to get a presence update after its 'moderator' role in " + mucAddress + " was revoked (but it did not).");
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="9.7", quote="(\u00a7 5.1.3)... a MUC service implementation MUST change the occupant's role to reflect the change and communicate the change to all occupants [...] (\u00a7 9.7) The service MUST then send updated presence from this individual to all occupants, indicating the removal of moderator status...")
    public void mucRoleTestForWitnessingModeratorRemoval() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        final SimpleResultSyncPoint resultSyncPoint = new SimpleResultSyncPoint();
        mucAsSeenByThree.addParticipantStatusListener(new ParticipantStatusListener(){

            public void moderatorRevoked(EntityFullJid participant) {
                resultSyncPoint.signal();
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            mucAsSeenByOne.grantModerator(nicknameTwo);
            mucAsSeenByOne.revokeModerator(nicknameTwo);
            this.assertResult(resultSyncPoint, "Expected " + this.conThree.getUser() + " to get a presence update after the 'moderator' role of another user in the room was revoked in " + mucAddress + " (but it did not).");
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="5.1.3", quote="(\u00a7 5.1.3)... a MUC service implementation MUST change the occupant's role to reflect the change and communicate the change to all occupants [...] (\u00a7 8.4) The service MUST then send updated presence from this individual to all occupants, indicating the removal of voice privileges...")
    public void mucRoleTestForRevokingVoice() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        final SimpleResultSyncPoint resultSyncPoint = new SimpleResultSyncPoint();
        mucAsSeenByTwo.addUserStatusListener(new UserStatusListener(){

            public void voiceRevoked() {
                resultSyncPoint.signal();
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByOne.revokeVoice(nicknameTwo);
            this.assertResult(resultSyncPoint, "Expected " + this.conTwo.getUser() + " to get a presence update after its 'voice' privilege was revoked in " + mucAddress + " (but it did not).");
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="8.4", quote="(\u00a7 5.1.3)... a MUC service implementation MUST change the occupant's role to reflect the change and communicate the change to all occupants [...] (\u00a7 8.4) The service MUST then send updated presence from this individual to all occupants, indicating the removal of voice privileges...")
    public void mucRoleTestForWitnessingRevokingVoice() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        final SimpleResultSyncPoint resultSyncPoint = new SimpleResultSyncPoint();
        mucAsSeenByThree.addParticipantStatusListener(new ParticipantStatusListener(){

            public void voiceRevoked(EntityFullJid participant) {
                resultSyncPoint.signal();
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            mucAsSeenByOne.revokeVoice(nicknameTwo);
            this.assertResult(resultSyncPoint, "Expected " + this.conThree.getUser() + " to get a presence update after another user's 'voice' privilege was revoked in " + mucAddress + " (but it did not).");
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="5.2.2", quote="(\u00a7 5.2.2) ... a MUC service implementation MUST change the user's affiliation to reflect the change and communicate that to all occupants [...] (\u00a7 10.6) If the user is in the room, the service MUST then send updated presence from this individual to all occupants, indicating the granting of admin status...")
    public void mucAffiliationTestForReceivingAdmin() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        final SimpleResultSyncPoint resultSyncPoint = new SimpleResultSyncPoint();
        mucAsSeenByTwo.addUserStatusListener(new UserStatusListener(){

            public void adminGranted() {
                resultSyncPoint.signal();
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByOne.grantAdmin((Jid)this.conTwo.getUser().asBareJid());
            this.assertResult(resultSyncPoint, "Expected " + this.conTwo.getUser() + " to get a presence update after its was granted 'admin' affiliation in " + mucAddress + " (but it did not).");
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="10.6", quote="(\u00a7 5.2.2) ... a MUC service implementation MUST change the user's affiliation to reflect the change and communicate that to all occupants [...] (\u00a7 10.6) If the user is in the room, the service MUST then send updated presence from this individual to all occupants, indicating the granting of admin status...")
    public void mucAffiliationTestForWitnessingAdmin() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        final SimpleResultSyncPoint resultSyncPoint = new SimpleResultSyncPoint();
        mucAsSeenByThree.addParticipantStatusListener(new ParticipantStatusListener(){

            public void adminGranted(EntityFullJid participant) {
                resultSyncPoint.signal();
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            mucAsSeenByOne.grantAdmin((Jid)this.conTwo.getUser().asBareJid());
            this.assertResult(resultSyncPoint, "Expected " + this.conThree.getUser() + " to get a presence update after another user was granted 'admin' affiliation in " + mucAddress + " (but it did not).");
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="10.7", quote="(\u00a7 5.2.2) ... a MUC service implementation MUST change the user's affiliation to reflect the change and communicate that to all occupants [...] (\u00a7 10.6) If the user is in the room, the service MUST then send updated presence from this individual to all occupants, indicating the loss of admin status by sending a presence element...")
    public void mucAffiliationTestForRemovingAdmin() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        final SimpleResultSyncPoint resultSyncPoint = new SimpleResultSyncPoint();
        mucAsSeenByTwo.addUserStatusListener(new UserStatusListener(){

            public void adminRevoked() {
                resultSyncPoint.signal();
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByOne.grantAdmin((Jid)this.conTwo.getUser().asBareJid());
            mucAsSeenByOne.revokeAdmin((EntityJid)this.conTwo.getUser().asEntityBareJid());
            this.assertResult(resultSyncPoint, "Expected " + this.conTwo.getUser() + " to get a presence update after its 'admin' affiliation was revoked in " + mucAddress + " (but it did not).");
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="10.7", quote="(\u00a7 5.2.2) ... a MUC service implementation MUST change the user's affiliation to reflect the change and communicate that to all occupants [...] (\u00a7 10.6) If the user is in the room, the service MUST then send updated presence from this individual to all occupants, indicating the loss of admin status by sending a presence element...")
    public void mucAffiliationTestForWitnessingAdminRemoval() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        final SimpleResultSyncPoint resultSyncPoint = new SimpleResultSyncPoint();
        mucAsSeenByThree.addParticipantStatusListener(new ParticipantStatusListener(){

            public void adminRevoked(EntityFullJid participant) {
                resultSyncPoint.signal();
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            mucAsSeenByOne.grantAdmin((Jid)this.conTwo.getUser().asBareJid());
            mucAsSeenByOne.revokeAdmin((EntityJid)this.conTwo.getUser().asEntityBareJid());
            this.assertResult(resultSyncPoint, "Expected " + this.conThree.getUser() + " to get a presence update after another user's 'admin' affiliation was revoked in " + mucAddress + " (but it did not).");
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="8.2", quote="The kick is performed based on the occupant's room nickname and is completed by setting the role of a participant or visitor to a value of \"none\". The service MUST remove the kicked occupant by sending a presence stanza of type \"unavailable\" to each kicked occupant, including status code 307 in the extended presence information, optionally along with the reason (if provided) and the roomnick or bare JID of the user who initiated the kick.")
    public void mucPresenceTestForGettingKicked() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            ResultSyncPoint resultSyncPoint = new ResultSyncPoint();
            mucAsSeenByTwo.addParticipantListener(kickPresence -> resultSyncPoint.signal(kickPresence));
            mucAsSeenByOne.kickParticipant(nicknameTwo, "Nothing personal. Just a test.");
            Presence kickPresence2 = (Presence)resultSyncPoint.waitForResult(this.timeout);
            MUCUser mucUser = MUCUser.from((Stanza)kickPresence2);
            Assertions.assertNotNull((Object)mucUser, (String)("Expected, but unable, to create a MUCUser instance from 'kick' presence: " + kickPresence2));
            Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertTrue((boolean)mucUser.getStatus().contains(MUCUser.Status.PRESENCE_TO_SELF_110), (String)("Missing self-presence status code in kick presence received by " + this.conTwo.getUser() + " after being kicked from room " + mucAddress)), () -> Assertions.assertTrue((boolean)mucUser.getStatus().contains(MUCUser.Status.KICKED_307), (String)("Missing kick status code in kick presence received by " + this.conTwo.getUser() + " after being kicked from room " + mucAddress)), () -> Assertions.assertEquals((Object)MUCRole.none, (Object)mucUser.getItem().getRole(), (String)("Role other than 'none' in kick presence received by " + this.conTwo.getUser() + " after being kicked from room " + mucAddress))});
            Jid itemJid = mucUser.getItem().getJid();
            if (itemJid != null) {
                Assertions.assertEquals((Object)this.conTwo.getUser().asEntityFullJidIfPossible(), (Object)itemJid, (String)("Incorrect kicked user in kick presence received by " + this.conTwo.getUser() + " after being kicked from room " + mucAddress));
            }
        }
        catch (TimeoutException e) {
            Assertions.fail((String)("Expected " + this.conTwo.getUser() + " to receive a presence update after it was kicked from room " + mucAddress + " (but it did not)."), (Throwable)e);
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="8.2", quote="...the service MUST then inform all of the remaining occupants that the kicked occupant is no longer in the room by sending presence stanzas of type \"unavailable\" from the individual's roomnick (<room@service/nick>) to all the remaining occupants (just as it does when occupants exit the room of their own volition), including the status code and optionally the reason and actor.")
    public void mucPresenceTestForWitnessingKick() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        try {
            Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
            Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            ResultSyncPoint resultSyncPoint = new ResultSyncPoint();
            mucAsSeenByThree.addParticipantListener(kickPresence -> resultSyncPoint.signal(kickPresence));
            mucAsSeenByOne.kickParticipant(nicknameTwo, "Nothing personal. Just a test.");
            Presence kickPresence2 = (Presence)resultSyncPoint.waitForResult(this.timeout);
            MUCUser mucUser = MUCUser.from((Stanza)kickPresence2);
            Assertions.assertNotNull((Object)mucUser, (String)("Expected, but unable, to create a MUCUser instance from 'kick' presence: " + kickPresence2));
            Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertFalse((boolean)mucUser.getStatus().contains(MUCUser.Status.PRESENCE_TO_SELF_110), (String)("Incorrect self-presence status code in kick presence received by " + this.conThree.getUser() + " after another user was kicked from room " + mucAddress)), () -> Assertions.assertTrue((boolean)mucUser.getStatus().contains(MUCUser.Status.KICKED_307), (String)("Missing kick status code in kick presence received by " + this.conThree.getUser() + " after another user was kicked from room " + mucAddress)), () -> Assertions.assertEquals((Object)MUCRole.none, (Object)mucUser.getItem().getRole(), (String)("Role other than 'none' in kick presence received by " + this.conThree.getUser() + " after another user was kicked from room " + mucAddress))});
            Jid itemJid = mucUser.getItem().getJid();
            if (itemJid != null) {
                Assertions.assertEquals((Object)this.conTwo.getUser().asEntityFullJidIfPossible(), (Object)itemJid, (String)("Incorrect kicked user in kick presence received by " + this.conThree.getUser() + " after another user was kicked from room " + mucAddress));
            }
        }
        catch (TimeoutException e) {
            Assertions.fail((String)("Expected " + this.conThree.getUser() + " to receive a presence update after another user was kicked from room " + mucAddress + " (but it did not)."), (Throwable)e);
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="5.2", quote="These affiliations are long-lived in that they persist across a user's visits to the room and are not affected by happenings in the room...Affiliations are granted, revoked, and maintained based on the user's bare JID, not the nick as with roles.")
    public void mucTestPersistentAffiliation() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        Resourcepart nicknameOne = Resourcepart.from((String)("one-" + this.randomString));
        Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
        Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, nicknameOne);
        try {
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            mucAsSeenByOne.grantOwnership((Jid)this.conTwo.getUser().asBareJid());
            mucAsSeenByOne.grantAdmin((Jid)this.conThree.getUser().asBareJid());
            mucAsSeenByTwo.leave();
            mucAsSeenByThree.leave();
            Presence p2 = mucAsSeenByTwo.join(nicknameTwo);
            Presence p3 = mucAsSeenByThree.join(nicknameThree);
            Assertions.assertEquals((Object)MUCAffiliation.owner, (Object)MUCUser.from((Stanza)p2).getItem().getAffiliation(), (String)("Unexpected affiliation of " + this.conTwo.getUser() + " after it re-joined room " + mucAddress));
            Assertions.assertEquals((Object)MUCAffiliation.admin, (Object)MUCUser.from((Stanza)p3).getItem().getAffiliation(), (String)("Unexpected affiliation of " + this.conThree.getUser() + " after it re-joined room " + mucAddress));
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="5.1.1", quote="A moderator MUST NOT be able to revoke voice privileges from an admin or owner [...] (\u00a7 8.4) A moderator MUST NOT be able to revoke voice from a user whose affiliation is at or above the moderator's level. In addition, a service MUST NOT allow the voice privileges of an admin or owner to be removed by anyone. If a moderator attempts to revoke voice privileges from such a user, the service MUST deny the request and return a <not-allowed/> error to the sender along with the offending item(s)")
    public void mucTestModeratorCannotRevokeVoiceFromOwner() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        Resourcepart nicknameOne = Resourcepart.from((String)("one-" + this.randomString));
        Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createModeratedMuc(mucAsSeenByOne, nicknameOne);
        try {
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByOne.grantModerator(nicknameTwo);
            XMPPException.XMPPErrorException xe = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> mucAsSeenByTwo.revokeVoice(nicknameOne), (String)("Expected an XMPP error when " + this.conTwo.getUser() + " was trying to revoke the 'voice' privilege of " + this.conOne.getUser() + " in room " + mucAddress));
            Assertions.assertEquals((Object)xe.getStanzaError().getCondition().toString(), (Object)"not-allowed", (String)("Unexpected stanza error condition in error returned when " + this.conTwo.getUser() + " was trying to revoke the 'voice' privilege of " + this.conOne.getUser() + " in room " + mucAddress));
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="5.1.3", quote="A moderator SHOULD NOT be allowed to revoke moderation privileges from someone with a higher affiliation than themselves (i.e., an unaffiliated moderator SHOULD NOT be allowed to revoke moderation privileges from an admin or an owner, and an admin SHOULD NOT be allowed to revoke moderation privileges from an owner)")
    public void mucTestModeratorCannotBeRevokedFromHigherAffiliation() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        Resourcepart nicknameOne = Resourcepart.from((String)("one-" + this.randomString));
        Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
        Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createModeratedMuc(mucAsSeenByOne, nicknameOne);
        try {
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            mucAsSeenByOne.grantAdmin((Jid)this.conTwo.getUser().asBareJid());
            mucAsSeenByOne.grantModerator(nicknameThree);
            XMPPException.XMPPErrorException xe1 = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> mucAsSeenByTwo.revokeModerator(nicknameOne), (String)("Expected an XMPP error when " + this.conTwo.getUser() + " (an admin) was trying to revoke the 'moderator' role of " + this.conOne.getUser() + " (an owner) in room " + mucAddress));
            XMPPException.XMPPErrorException xe2 = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> mucAsSeenByThree.revokeModerator(nicknameOne), (String)("Expected an XMPP error when " + this.conThree.getUser() + " (a moderator) was trying to revoke the 'moderator' role of " + this.conOne.getUser() + " (an owner) in room " + mucAddress));
            XMPPException.XMPPErrorException xe3 = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> mucAsSeenByThree.revokeModerator(nicknameTwo), (String)("Expected an XMPP error when " + this.conThree.getUser() + " (a moderator) was trying to revoke the 'moderator' role of " + this.conTwo.getUser() + " (an admin) in room " + mucAddress));
            Assertions.assertEquals((Object)xe1.getStanzaError().getCondition().toString(), (Object)"not-allowed", (String)("Unexpected condition in XMPP error when " + this.conTwo.getUser() + " (an admin) was trying to revoke the 'moderator' role of " + this.conOne.getUser() + " (an owner) in room " + mucAddress));
            Assertions.assertEquals((Object)xe2.getStanzaError().getCondition().toString(), (Object)"not-allowed", (String)("Unexpected condition in XMPP error when " + this.conThree.getUser() + " (a moderator) was trying to revoke the 'moderator' role of " + this.conOne.getUser() + " (an owner) in room " + mucAddress));
            Assertions.assertEquals((Object)xe3.getStanzaError().getCondition().toString(), (Object)"not-allowed", (String)("Unexpected condition in XMPP error when " + this.conThree.getUser() + " (a moderator) was trying to revoke the 'moderator' role of " + this.conTwo.getUser() + " (an admin) in room " + mucAddress));
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="5.1.2", quote="...the initial default roles that a service SHOULD set based on the user's affiliation...")
    public void mucTestDefaultRoleForAffiliationInUnmoderatedRoom() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-unmoderatedroles");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        Resourcepart nicknameOne = Resourcepart.from((String)("one-" + this.randomString));
        Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
        Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMuc(mucAsSeenByOne, nicknameOne);
        try {
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            final SimpleResultSyncPoint resultSyncPoint = new SimpleResultSyncPoint();
            mucAsSeenByOne.addParticipantStatusListener(new ParticipantStatusListener(){

                public void adminGranted(EntityFullJid participant) {
                    resultSyncPoint.signal();
                }
            });
            mucAsSeenByOne.grantAdmin((Jid)this.conTwo.getUser().asBareJid());
            resultSyncPoint.waitForResult(this.timeout);
            Assertions.assertEquals((int)mucAsSeenByOne.getOccupantsCount(), (int)3, (String)("Unexpected occupant count in room " + mucAddress));
            Assertions.assertEquals((Object)MUCRole.moderator, (Object)mucAsSeenByOne.getOccupant(JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)nicknameOne)).getRole(), (String)("Unexpected role for occupant " + nicknameOne + " of " + mucAddress));
            Assertions.assertEquals((Object)MUCRole.moderator, (Object)mucAsSeenByOne.getOccupant(JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)nicknameTwo)).getRole(), (String)("Unexpected role for occupant " + nicknameTwo + " of " + mucAddress));
            Assertions.assertEquals((Object)MUCRole.participant, (Object)mucAsSeenByOne.getOccupant(JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)nicknameThree)).getRole(), (String)("Unexpected role for occupant " + nicknameThree + " of " + mucAddress));
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="5.1.2", quote="...the initial default roles that a service SHOULD set based on the user's affiliation...")
    public void mucTestDefaultRoleForAffiliationInModeratedRoom() throws Exception {
        MUCRole threeRole;
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-moderatedroles");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        Resourcepart nicknameOne = Resourcepart.from((String)("one-" + this.randomString));
        Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
        Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
        final SimpleResultSyncPoint resultSyncPoint = new SimpleResultSyncPoint();
        mucAsSeenByOne.addParticipantStatusListener(new ParticipantStatusListener(){

            public void adminGranted(EntityFullJid participant) {
                resultSyncPoint.signal();
            }
        });
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createModeratedMuc(mucAsSeenByOne, nicknameOne);
        switch (this.sinttestConfiguration.compatibilityMode) {
            default: {
                threeRole = MUCRole.visitor;
                break;
            }
            case ejabberd: {
                threeRole = MUCRole.participant;
            }
        }
        try {
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            mucAsSeenByOne.grantAdmin((Jid)this.conTwo.getUser().asBareJid());
            resultSyncPoint.waitForResult(this.timeout);
            Assertions.assertEquals((int)mucAsSeenByOne.getOccupantsCount(), (int)3, (String)("Unexpected occupant count in room " + mucAddress));
            Assertions.assertEquals((Object)MUCRole.moderator, (Object)mucAsSeenByOne.getOccupant(JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)nicknameOne)).getRole(), (String)("Unexpected role for occupant " + nicknameOne + " of " + mucAddress));
            Assertions.assertEquals((Object)MUCRole.moderator, (Object)mucAsSeenByOne.getOccupant(JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)nicknameTwo)).getRole(), (String)("Unexpected role for occupant " + nicknameTwo + " of " + mucAddress));
            Assertions.assertEquals((Object)threeRole, (Object)mucAsSeenByOne.getOccupant(JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)nicknameThree)).getRole(), (String)("Unexpected role for occupant " + nicknameThree + " of " + mucAddress));
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="5.1.2", quote="...the initial default roles that a service SHOULD set based on the user's affiliation...")
    public void mucTestDefaultRoleForAffiliationInMembersOnlyRoom() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-membersonlyroles");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        Resourcepart nicknameOne = Resourcepart.from((String)("one-" + this.randomString));
        Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
        Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));
        EntityFullJid jidOne = JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)nicknameOne);
        EntityFullJid jidTwo = JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)nicknameTwo);
        EntityFullJid jidThree = JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)nicknameThree);
        MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.createMembersOnlyMuc(mucAsSeenByOne, nicknameOne);
        final SimpleResultSyncPoint adminResultSyncPoint = new SimpleResultSyncPoint();
        mucAsSeenByOne.addParticipantStatusListener(new ParticipantStatusListener(){

            public void adminGranted(EntityFullJid participant) {
                adminResultSyncPoint.signal();
            }
        });
        try {
            mucAsSeenByOne.grantMembership((Jid)this.conTwo.getUser().asBareJid());
            mucAsSeenByOne.grantMembership((Jid)this.conThree.getUser().asBareJid());
            mucAsSeenByTwo.join(nicknameTwo);
            mucAsSeenByThree.join(nicknameThree);
            mucAsSeenByOne.grantAdmin((Jid)this.conTwo.getUser().asBareJid());
            adminResultSyncPoint.waitForResult(this.timeout);
            Assertions.assertEquals((int)mucAsSeenByOne.getOccupantsCount(), (int)3, (String)("Unexpected occupant count in room " + mucAddress));
            Assertions.assertEquals((Object)MUCRole.moderator, (Object)mucAsSeenByOne.getOccupant(jidOne).getRole(), (String)("Unexpected role for occupant " + jidOne + " in room " + mucAddress));
            Assertions.assertEquals((Object)MUCRole.moderator, (Object)mucAsSeenByOne.getOccupant(jidTwo).getRole(), (String)("Unexpected role for occupant " + jidTwo + " in room " + mucAddress));
            Assertions.assertEquals((Object)MUCRole.participant, (Object)mucAsSeenByOne.getOccupant(jidThree).getRole(), (String)("Unexpected role for occupant " + jidThree + " in room " + mucAddress));
        }
        finally {
            MultiUserChatRolesAffiliationsPrivilegesIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }
}

