/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StandardExtensionElement;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.form.ConfigureForm;
import org.jivesoftware.smackx.pubsub.form.FillableConfigureForm;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;

@SpecificationReference(document="XEP-0060")
public class PubSubIntegrationTest
extends AbstractSmackIntegrationTest {
    private final PubSubManager pubSubManagerOne;

    public PubSubIntegrationTest(SmackIntegrationTestEnvironment environment) throws TestNotPossibleException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        super(environment);
        DomainBareJid pubSubService = PubSubManager.getPubSubService((XMPPConnection)this.conOne);
        if (pubSubService == null) {
            throw new TestNotPossibleException("No PubSub service found");
        }
        this.pubSubManagerOne = PubSubManager.getInstanceFor((XMPPConnection)this.conOne, (BareJid)pubSubService);
        if (!this.pubSubManagerOne.canCreateNodesAndPublishItems()) {
            throw new TestNotPossibleException("PubSub service does not allow node creation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void transientNotificationOnlyNodeWithoutItemTest() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        String nodename = "sinttest-transient-notificationonly-withoutitem-nodename-" + this.testRunId;
        ConfigureForm defaultConfiguration = this.pubSubManagerOne.getDefaultConfiguration();
        FillableConfigureForm config = defaultConfiguration.getFillableForm();
        config.setDeliverPayloads(false);
        config.setPersistentItems(false);
        Node node = this.pubSubManagerOne.createNode(nodename, config);
        try {
            LeafNode leafNode = (LeafNode)node;
            leafNode.publish();
        }
        finally {
            this.pubSubManagerOne.deleteNode(nodename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.1.3.6", quote="If the event type is notification + transient and the publisher provides an item, the service MUST bounce the publication request with a <bad-request/> error and a pubsub-specific error condition of <item-forbidden/>.")
    public void transientNotificationOnlyNodeWithItemTest() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        String nodename = "sinttest-transient-notificationonly-withitem-nodename-" + this.testRunId;
        String itemId = "sinttest-transient-notificationonly-withitem-itemid-" + this.testRunId;
        ConfigureForm defaultConfiguration = this.pubSubManagerOne.getDefaultConfiguration();
        FillableConfigureForm config = defaultConfiguration.getFillableForm();
        config.setDeliverPayloads(false);
        config.setPersistentItems(false);
        Node node = this.pubSubManagerOne.createNode(nodename, config);
        StandardExtensionElement dummyPayload = StandardExtensionElement.builder((String)"dummy-payload", (String)"https://igniterealtime.org/projects/smack").setText(this.testRunId).build();
        try {
            XMPPException.XMPPErrorException e = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> {
                LeafNode leafNode = (LeafNode)node;
                PayloadItem item = new PayloadItem(itemId, (XmlElement)dummyPayload);
                leafNode.publish((Item)item);
            }, (String)("Expected an error after publishing item " + itemId + " (but none occurred)."));
            Assertions.assertEquals((Object)StanzaError.Type.MODIFY, (Object)e.getStanzaError().getType(), (String)"Unexpected error type");
            Assertions.assertNotNull((Object)e.getStanzaError().getExtension("item-forbidden", "http://jabber.org/protocol/pubsub#errors"), (String)"Expected error to contain 'item-forbidden', but it did not.");
        }
        finally {
            this.pubSubManagerOne.deleteNode(nodename);
        }
    }
}

