/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.usertune;

import java.net.URI;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.annotations.AfterClass;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.igniterealtime.smack.inttest.util.IntegrationTestRosterUtil;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.disco.EntityCapabilitiesChangedListener;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.pep.PepEventListener;
import org.jivesoftware.smackx.usertune.UserTuneManager;
import org.jivesoftware.smackx.usertune.element.UserTuneElement;
import org.junit.jupiter.api.Assertions;

@SpecificationReference(document="XEP-0118")
public class UserTuneIntegrationTest
extends AbstractSmackIntegrationTest {
    private final UserTuneManager utm1;
    private final UserTuneManager utm2;

    public UserTuneIntegrationTest(SmackIntegrationTestEnvironment environment) throws SmackException.NotLoggedInException {
        super(environment);
        this.utm1 = UserTuneManager.getInstanceFor((XMPPConnection)this.conOne);
        this.utm2 = UserTuneManager.getInstanceFor((XMPPConnection)this.conTwo);
    }

    @AfterClass
    public void unsubscribe() throws SmackException.NotLoggedInException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        IntegrationTestRosterUtil.ensureBothAccountsAreNotInEachOthersRoster(this.conOne, this.conTwo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void testNotification() throws Exception {
        URI uri = new URI("http://www.yesworld.com/lyrics/Fragile.html#9");
        UserTuneElement.Builder builder = UserTuneElement.getBuilder();
        UserTuneElement data = builder.setArtist("Yes").setLength(686).setRating(8).setSource("Yessongs").setTitle("Heart of the Sunrise").setTrack("3").setUri(uri).build();
        IntegrationTestRosterUtil.ensureBothAccountsAreSubscribedToEachOther(this.conOne, this.conTwo, this.timeout);
        SimpleResultSyncPoint userTuneReceived = new SimpleResultSyncPoint();
        PepEventListener userTuneListener = (jid, userTune, id, message) -> {
            if (userTune.equals((Object)data)) {
                userTuneReceived.signal();
            }
        };
        try {
            this.registerListenerAndWait(this.utm2, ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.conTwo), (PepEventListener<UserTuneElement>)userTuneListener);
            this.utm1.publishUserTune(data);
            Object result = userTuneReceived.waitForResult(this.timeout);
            Assertions.assertNotNull(result, (String)"Expected to receive a PEP notification, but did not.");
        }
        finally {
            this.unregisterListener(this.utm2, (PepEventListener<UserTuneElement>)userTuneListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void testNotificationAfterFilterChange() throws Exception {
        URI uri = new URI("http://www.yesworld.com/lyrics/Fragile.html#8");
        UserTuneElement.Builder builder = UserTuneElement.getBuilder();
        UserTuneElement data = builder.setArtist("No").setLength(306).setRating(3).setSource("NoSongs").setTitle("Sunrise of the Heart").setTrack("2").setUri(uri).build();
        IntegrationTestRosterUtil.ensureBothAccountsAreSubscribedToEachOther(this.conOne, this.conTwo, this.timeout);
        SimpleResultSyncPoint userTuneReceived = new SimpleResultSyncPoint();
        PepEventListener userTuneListener = (jid, userTune, id, message) -> {
            if (userTune.equals((Object)data)) {
                userTuneReceived.signal();
            }
        };
        try {
            this.publishAndWait(this.utm1, ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.conOne), data);
            this.registerListenerAndWait(this.utm2, ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.conTwo), (PepEventListener<UserTuneElement>)userTuneListener);
            this.assertResult(userTuneReceived, "Expected " + this.conTwo.getUser() + " to receive a PEP notification from " + this.conOne.getUser() + ", but did not.");
        }
        finally {
            this.unregisterListener(this.utm2, (PepEventListener<UserTuneElement>)userTuneListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListenerAndWait(UserTuneManager userTuneManager, ServiceDiscoveryManager discoManager, PepEventListener<UserTuneElement> listener) throws Exception {
        SimpleResultSyncPoint notificationFilterReceived = new SimpleResultSyncPoint();
        EntityCapabilitiesChangedListener notificationFilterReceivedListener = info -> {
            if (info.containsFeature((CharSequence)"http://jabber.org/protocol/tune+notify")) {
                notificationFilterReceived.signal();
            }
        };
        discoManager.addEntityCapabilitiesChangedListener(notificationFilterReceivedListener);
        try {
            userTuneManager.addUserTuneListener(listener);
            notificationFilterReceived.waitForResult(this.timeout);
        }
        finally {
            discoManager.removeEntityCapabilitiesChangedListener(notificationFilterReceivedListener);
        }
    }

    public void unregisterListener(UserTuneManager userTuneManager, PepEventListener<UserTuneElement> listener) {
        userTuneManager.removeUserTuneListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishAndWait(UserTuneManager userTuneManager, ServiceDiscoveryManager discoManager, UserTuneElement data) throws Exception {
        SimpleResultSyncPoint publicationEchoReceived = new SimpleResultSyncPoint();
        PepEventListener publicationEchoListener = (jid, userTune, id, message) -> {
            if (userTune.equals((Object)data)) {
                publicationEchoReceived.signal();
            }
        };
        try {
            this.registerListenerAndWait(userTuneManager, discoManager, (PepEventListener<UserTuneElement>)publicationEchoListener);
            userTuneManager.addUserTuneListener(publicationEchoListener);
            userTuneManager.publishUserTune(data);
        }
        finally {
            userTuneManager.removeUserTuneListener(publicationEchoListener);
        }
    }
}

