/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.chatstate;

import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.annotations.AfterClass;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.chat2.Chat;
import org.jivesoftware.smack.chat2.ChatManager;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.chatstates.ChatState;
import org.jivesoftware.smackx.chatstates.ChatStateManager;

@SpecificationReference(document="XEP-0085", version="2.1")
public class ChatStateIntegrationTest
extends AbstractSmackIntegrationTest {
    private final SimpleResultSyncPoint composingSyncPoint = new SimpleResultSyncPoint();
    private final SimpleResultSyncPoint activeSyncPoint = new SimpleResultSyncPoint();

    private void composingListener(Chat chat, ChatState state, Message message) {
        if (state.equals((Object)ChatState.composing)) {
            this.composingSyncPoint.signal();
        }
    }

    private void activeListener(Chat chat, ChatState state, Message message) {
        if (state.equals((Object)ChatState.active)) {
            this.activeSyncPoint.signal();
        }
    }

    public ChatStateIntegrationTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
    }

    @SmackIntegrationTest
    public void testChatStateListeners() throws Exception {
        ChatStateManager manOne = ChatStateManager.getInstance((XMPPConnection)this.conOne);
        ChatStateManager manTwo = ChatStateManager.getInstance((XMPPConnection)this.conTwo);
        manTwo.addChatStateListener(this::composingListener);
        manTwo.addChatStateListener(this::activeListener);
        Chat chatOne = ChatManager.getInstanceFor((XMPPConnection)this.conOne).chatWith(this.conTwo.getUser().asEntityBareJid());
        manOne.setCurrentState(ChatState.composing, chatOne);
        this.composingSyncPoint.waitForResult(this.timeout);
        Chat chat = ChatManager.getInstanceFor((XMPPConnection)this.conOne).chatWith(this.conTwo.getUser().asEntityBareJid());
        chat.send((CharSequence)"Hi!");
        this.assertResult(this.activeSyncPoint, "Expected " + this.conTwo.getUser() + " to receive an 'active' chat state from " + this.conOne + " (but they did not).");
    }

    @AfterClass
    public void cleanup() {
        ChatStateManager manTwo = ChatStateManager.getInstance((XMPPConnection)this.conTwo);
        manTwo.removeChatStateListener(this::composingListener);
        manTwo.removeChatStateListener(this::activeListener);
    }
}

