/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.List;
import java.util.logging.Level;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jivesoftware.smackx.xdata.form.FillableForm;
import org.jivesoftware.smackx.xdata.form.Form;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Domainpart;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;

public abstract class AbstractMultiUserChatIntegrationTest
extends AbstractSmackIntegrationTest {
    final String randomString = StringUtils.insecureRandomString((int)6);
    final MultiUserChatManager mucManagerOne = MultiUserChatManager.getInstanceFor((XMPPConnection)this.conOne);
    final MultiUserChatManager mucManagerTwo = MultiUserChatManager.getInstanceFor((XMPPConnection)this.conTwo);
    final MultiUserChatManager mucManagerThree = MultiUserChatManager.getInstanceFor((XMPPConnection)this.conThree);
    final DomainBareJid mucService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractMultiUserChatIntegrationTest(SmackIntegrationTestEnvironment environment) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException, MultiUserChatException.MucAlreadyJoinedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException, XmppStringprepException {
        super(environment);
        List services = this.mucManagerOne.getMucServiceDomains();
        if (services.isEmpty()) {
            throw new TestNotPossibleException("No MUC (XEP-0045) service found");
        }
        DomainBareJid needle = null;
        for (DomainBareJid service : services) {
            MultiUserChat multiUserChat = null;
            try {
                String roomNameLocal = String.join((CharSequence)"-", "smack-inttest-abstract", this.testRunId, StringUtils.insecureRandomString((int)6));
                EntityBareJid mucAddress = JidCreate.entityBareFrom((Localpart)Localpart.from((String)roomNameLocal), (Domainpart)service.getDomain());
                multiUserChat = this.mucManagerOne.getMultiUserChat(mucAddress);
                AbstractMultiUserChatIntegrationTest.createMuc(multiUserChat, "test");
                needle = service;
                AbstractMultiUserChatIntegrationTest.tryDestroy(multiUserChat);
                break;
            }
            catch (XMPPException.XMPPErrorException e) {
                AbstractMultiUserChatIntegrationTest.mucCreationDisallowedOrThrow(e);
                LOGGER.log(Level.FINER, "MUC service " + service + " does not allow MUC creation", e);
            }
            finally {
                AbstractMultiUserChatIntegrationTest.tryDestroy(multiUserChat);
            }
        }
        if (needle == null) {
            throw new TestNotPossibleException("No MUC (XEP-0045) service found that allows test users to createa new room. Considered MUC services: " + services);
        }
        this.mucService = needle;
    }

    static void mucCreationDisallowedOrThrow(XMPPException.XMPPErrorException e) throws XMPPException.XMPPErrorException {
        StanzaError.Condition condition = e.getStanzaError().getCondition();
        if (condition == StanzaError.Condition.not_allowed) {
            return;
        }
        throw e;
    }

    public EntityBareJid getRandomRoom(String prefix) throws XmppStringprepException {
        String roomNameLocal = String.join((CharSequence)"-", prefix, this.testRunId, StringUtils.insecureRandomString((int)6));
        return JidCreate.entityBareFrom((Localpart)Localpart.from((String)roomNameLocal), (Domainpart)this.mucService.getDomain());
    }

    static void tryDestroy(MultiUserChat muc) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (muc == null) {
            return;
        }
        muc.destroy("test fixture teardown", null);
    }

    static void createMuc(MultiUserChat muc, Resourcepart resourceName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException {
        muc.create(resourceName).makeInstant();
    }

    static void createMuc(MultiUserChat muc, String nickname) throws XmppStringprepException, MultiUserChatException.MucAlreadyJoinedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, SmackException.NoResponseException, InterruptedException, MultiUserChatException.NotAMucServiceException {
        AbstractMultiUserChatIntegrationTest.createMuc(muc, Resourcepart.from((String)nickname));
    }

    static void createMembersOnlyMuc(MultiUserChat muc, Resourcepart resourceName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.MucConfigurationNotSupportedException, MultiUserChatException.NotAMucServiceException {
        muc.create(resourceName).getConfigFormManager().makeMembersOnly().submitConfigurationForm();
    }

    static void createModeratedMuc(MultiUserChat muc, Resourcepart resourceName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException, MultiUserChatException.MucConfigurationNotSupportedException {
        muc.create(resourceName).getConfigFormManager().makeModerated().submitConfigurationForm();
    }

    static void createHiddenMuc(MultiUserChat muc, Resourcepart resourceName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException, XmppStringprepException, MultiUserChatException.MucConfigurationNotSupportedException {
        muc.create(resourceName).getConfigFormManager().makeHidden().submitConfigurationForm();
    }

    static void createNonAnonymousMuc(MultiUserChat muc, Resourcepart resourceName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException {
        muc.create(resourceName);
        Form configForm = muc.getConfigurationForm();
        FillableForm answerForm = configForm.getFillableForm();
        answerForm.setAnswer("muc#roomconfig_whois", (CharSequence)"anyone");
        muc.sendConfigurationForm(answerForm);
    }

    static void createSemiAnonymousMuc(MultiUserChat muc, Resourcepart resourceName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException {
        muc.create(resourceName);
        Form configForm = muc.getConfigurationForm();
        FillableForm answerForm = configForm.getFillableForm();
        answerForm.setAnswer("muc#roomconfig_whois", (CharSequence)"moderators");
        muc.sendConfigurationForm(answerForm);
    }

    static void createPasswordProtectedMuc(MultiUserChat muc, Resourcepart resourceName, String password) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException {
        muc.create(resourceName);
        Form configForm = muc.getConfigurationForm();
        FillableForm answerForm = configForm.getFillableForm();
        answerForm.setAnswer("muc#roomconfig_passwordprotectedroom", true);
        answerForm.setAnswer("muc#roomconfig_roomsecret", (CharSequence)password);
        muc.sendConfigurationForm(answerForm);
    }

    static void setMaxUsers(MultiUserChat muc, int maxUsers) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, SmackException.NotConnectedException {
        Form configForm = muc.getConfigurationForm();
        FillableForm answerForm = configForm.getFillableForm();
        answerForm.setAnswer("muc#roomconfig_maxusers", maxUsers);
        muc.sendConfigurationForm(answerForm);
    }
}

