/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox;

import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.AfterClass;
import org.igniterealtime.smack.inttest.annotations.BeforeClass;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.ox.AbstractOpenPgpIntegrationTest;
import org.jivesoftware.smackx.ox.OpenPgpManager;
import org.jivesoftware.smackx.ox.OpenPgpSecretKeyBackupPassphrase;
import org.jivesoftware.smackx.ox.OpenPgpSelf;
import org.jivesoftware.smackx.ox.crypto.OpenPgpProvider;
import org.jivesoftware.smackx.ox.crypto.PainlessOpenPgpProvider;
import org.jivesoftware.smackx.ox.exception.InvalidBackupCodeException;
import org.jivesoftware.smackx.ox.exception.MissingOpenPgpKeyException;
import org.jivesoftware.smackx.ox.exception.MissingUserIdOnKeyException;
import org.jivesoftware.smackx.ox.exception.NoBackupFoundException;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpStore;
import org.jivesoftware.smackx.ox.store.filebased.FileBasedOpenPgpStore;
import org.jivesoftware.smackx.ox.util.OpenPgpPubSubUtil;
import org.jivesoftware.smackx.pep.PepManager;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.junit.jupiter.api.Assertions;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;

@SpecificationReference(document="XEP-0374", version="0.2.0")
public class OXSecretKeyBackupIntegrationTest
extends AbstractOpenPgpIntegrationTest {
    private static final String sessionId = StringUtils.randomString((int)10);
    private static final File tempDir = FileUtils.getTempDirectory();
    private static final File beforePath = new File(tempDir, "ox_backup_" + sessionId);
    private static final File afterPath = new File(tempDir, "ox_restore_" + sessionId);

    public OXSecretKeyBackupIntegrationTest(SmackIntegrationTestEnvironment environment) throws XMPPException.XMPPErrorException, TestNotPossibleException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        super(environment);
        if (!OpenPgpManager.serverSupportsSecretKeyBackups((XMPPConnection)this.aliceConnection)) {
            throw new TestNotPossibleException("Server does not support the 'whitelist' PubSub access model.");
        }
    }

    @AfterClass
    @BeforeClass
    public static void cleanStore() throws IOException {
        FileUtils.deleteDirectory((File)afterPath);
        FileUtils.deleteDirectory((File)beforePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="5")
    public void test() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, IOException, InterruptedException, PubSubException.NotALeafNodeException, SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.XMPPErrorException, SmackException.NotLoggedInException, SmackException.FeatureNotSupportedException, MissingUserIdOnKeyException, NoBackupFoundException, InvalidBackupCodeException, PGPException, MissingOpenPgpKeyException {
        FileBasedOpenPgpStore beforeStore = new FileBasedOpenPgpStore(beforePath);
        beforeStore.setKeyRingProtector((SecretKeyRingProtector)new UnprotectedKeysProtector());
        PainlessOpenPgpProvider beforeProvider = new PainlessOpenPgpProvider((OpenPgpStore)beforeStore);
        OpenPgpManager openPgpManager = OpenPgpManager.getInstanceFor((XMPPConnection)this.aliceConnection);
        openPgpManager.setOpenPgpProvider((OpenPgpProvider)beforeProvider);
        OpenPgpSelf self = openPgpManager.getOpenPgpSelf();
        Assertions.assertNull((Object)self.getSigningKeyFingerprint());
        OpenPgpV4Fingerprint keyFingerprint = openPgpManager.generateAndImportKeyPair(this.alice);
        try {
            Assertions.assertEquals((Object)keyFingerprint, (Object)self.getSigningKeyFingerprint());
            Assertions.assertTrue((boolean)self.getSecretKeys().contains(keyFingerprint.getKeyId()));
            PGPSecretKeyRing beforeSec = beforeStore.getSecretKeyRing(this.alice, keyFingerprint);
            Assertions.assertNotNull((Object)beforeSec);
            PGPPublicKeyRing beforePub = beforeStore.getPublicKeyRing(this.alice, keyFingerprint);
            Assertions.assertNotNull((Object)beforePub);
            OpenPgpSecretKeyBackupPassphrase backupPassphrase = openPgpManager.backupSecretKeyToServer(availableSecretKeys -> availableSecretKeys);
            FileBasedOpenPgpStore afterStore = new FileBasedOpenPgpStore(afterPath);
            afterStore.setKeyRingProtector((SecretKeyRingProtector)new UnprotectedKeysProtector());
            PainlessOpenPgpProvider afterProvider = new PainlessOpenPgpProvider((OpenPgpStore)afterStore);
            openPgpManager.setOpenPgpProvider((OpenPgpProvider)afterProvider);
            OpenPgpV4Fingerprint fingerprint = openPgpManager.restoreSecretKeyServerBackup(() -> backupPassphrase);
            Assertions.assertEquals((Object)keyFingerprint, (Object)fingerprint);
            Assertions.assertTrue((boolean)self.getSecretKeys().contains(keyFingerprint.getKeyId()));
            Assertions.assertEquals((Object)keyFingerprint, (Object)self.getSigningKeyFingerprint());
            PGPSecretKeyRing afterSec = afterStore.getSecretKeyRing(this.alice, keyFingerprint);
            Assertions.assertNotNull((Object)afterSec);
            Assertions.assertArrayEquals((byte[])beforeSec.getEncoded(), (byte[])afterSec.getEncoded());
            PGPPublicKeyRing afterPub = afterStore.getPublicKeyRing(this.alice, keyFingerprint);
            Assertions.assertNotNull((Object)afterPub);
            Assertions.assertArrayEquals((byte[])beforePub.getEncoded(), (byte[])afterPub.getEncoded());
        }
        finally {
            OpenPgpPubSubUtil.deletePublicKeyNode((PepManager)this.alicePepManager, (OpenPgpV4Fingerprint)keyFingerprint);
            OpenPgpPubSubUtil.deletePubkeysListNode((PepManager)this.alicePepManager);
        }
    }
}

