/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest;

import eu.geekplace.javapinning.java7.Java7Pinning;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.igniterealtime.smack.inttest.AbstractSmackIntTest;
import org.igniterealtime.smack.inttest.ConnectionConfigurationBuilderApplier;
import org.igniterealtime.smack.inttest.SmackIntegrationTestFramework;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.debugger.ConsoleDebugger;
import org.jivesoftware.smack.debugger.SmackDebuggerFactory;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.Function;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.util.SslContextFactory;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.debugger.EnhancedDebugger;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public final class Configuration {
    private static final Logger LOGGER = Logger.getLogger(Configuration.class.getName());
    public final DomainBareJid service;
    public final String host;
    public final String serviceTlsPin;
    public final SslContextFactory sslContextFactory;
    public final ConnectionConfiguration.SecurityMode securityMode;
    public final int replyTimeout;
    public final AccountRegistration accountRegistration;
    public final String adminAccountUsername;
    public final String adminAccountPassword;
    public final String accountOneUsername;
    public final String accountOnePassword;
    public final String accountTwoUsername;
    public final String accountTwoPassword;
    public final String accountThreeUsername;
    public final String accountThreePassword;
    public final SmackDebuggerFactory debuggerFactory;
    public final Set<String> enabledTests;
    private final Map<String, Set<String>> enabledTestsMap;
    public final Set<String> disabledTests;
    private final Map<String, Set<String>> disabledTestsMap;
    public final Set<String> enabledSpecifications;
    public final Set<String> disabledSpecifications;
    public final String defaultConnectionNickname;
    public final Set<String> enabledConnections;
    public final Set<String> disabledConnections;
    public final Set<String> testPackages;
    public final ConnectionConfigurationBuilderApplier configurationApplier;
    public final boolean verbose;
    public final DnsResolver dnsResolver;
    public final CompatibilityMode compatibilityMode;
    public final List<? extends SmackIntegrationTestFramework.TestRunResultProcessor> testRunResultProcessors;
    private static final String SINTTEST = "sinttest.";

    private Configuration(Builder builder) throws KeyManagementException, NoSuchAlgorithmException {
        this.service = (DomainBareJid)Objects.requireNonNull((Object)builder.service, (String)"'service' must be set. Either via 'properties' files or via system property 'sinttest.service'.");
        this.host = builder.host;
        this.serviceTlsPin = builder.serviceTlsPin;
        if (this.serviceTlsPin != null) {
            SSLContext sslContext = Java7Pinning.forPin((String)this.serviceTlsPin);
            this.sslContextFactory = () -> sslContext;
        } else {
            this.sslContextFactory = null;
        }
        this.securityMode = builder.securityMode;
        this.replyTimeout = builder.replyTimeout > 0 ? builder.replyTimeout : 47000;
        this.debuggerFactory = builder.debuggerFactory;
        this.accountRegistration = StringUtils.isNotEmpty((CharSequence[])new CharSequence[]{builder.adminAccountUsername, builder.adminAccountPassword}) ? AccountRegistration.serviceAdministration : (StringUtils.isNotEmpty((CharSequence[])new CharSequence[]{builder.accountOneUsername, builder.accountOnePassword, builder.accountTwoUsername, builder.accountTwoPassword, builder.accountThreeUsername, builder.accountThreePassword}) ? AccountRegistration.disabled : AccountRegistration.inBandRegistration);
        this.adminAccountUsername = builder.adminAccountUsername;
        this.adminAccountPassword = builder.adminAccountPassword;
        boolean accountOnePasswordSet = StringUtils.isNotEmpty((CharSequence)builder.accountOnePassword);
        if (accountOnePasswordSet != StringUtils.isNotEmpty((CharSequence)builder.accountTwoPassword) || accountOnePasswordSet != StringUtils.isNotEmpty((CharSequence)builder.accountThreePassword)) {
            throw new IllegalArgumentException();
        }
        this.accountOneUsername = builder.accountOneUsername;
        this.accountOnePassword = builder.accountOnePassword;
        this.accountTwoUsername = builder.accountTwoUsername;
        this.accountTwoPassword = builder.accountTwoPassword;
        this.accountThreeUsername = builder.accountThreeUsername;
        this.accountThreePassword = builder.accountThreePassword;
        this.enabledTests = CollectionUtil.nullSafeUnmodifiableSet(builder.enabledTests);
        this.enabledTestsMap = Configuration.convertTestsToMap(this.enabledTests);
        this.disabledTests = CollectionUtil.nullSafeUnmodifiableSet(builder.disabledTests);
        this.disabledTestsMap = Configuration.convertTestsToMap(this.disabledTests);
        this.enabledSpecifications = CollectionUtil.nullSafeUnmodifiableSet(builder.enabledSpecifications);
        this.disabledSpecifications = CollectionUtil.nullSafeUnmodifiableSet(builder.disabledSpecifications);
        this.defaultConnectionNickname = builder.defaultConnectionNickname;
        this.enabledConnections = builder.enabledConnections;
        this.disabledConnections = builder.disabledConnections;
        this.testPackages = builder.testPackages;
        this.configurationApplier = b -> {
            if (this.sslContextFactory != null) {
                b.setSslContextFactory(this.sslContextFactory);
            }
            b.setSecurityMode(this.securityMode);
            b.setXmppDomain(this.service);
            if (this.host != null) {
                b.setHost((CharSequence)this.host);
            }
            if (this.debuggerFactory != null) {
                b.setDebuggerFactory(this.debuggerFactory);
            }
        };
        this.verbose = builder.verbose;
        this.dnsResolver = builder.dnsResolver;
        this.compatibilityMode = builder.compatibilityMode;
        this.testRunResultProcessors = builder.testRunResultProcessors;
    }

    public boolean isAccountRegistrationPossible() {
        return this.accountRegistration != AccountRegistration.disabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Configuration newConfiguration(String[] testPackages) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        String debugString;
        Properties properties = new Properties();
        File propertiesFile = Configuration.findPropertiesFile();
        if (propertiesFile != null) {
            try (FileInputStream in = new FileInputStream(propertiesFile);){
                properties.load(in);
            }
        }
        Properties systemProperties = System.getProperties();
        for (Map.Entry<Object, Object> entry : systemProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(SINTTEST)) continue;
            key = key.substring(SINTTEST.length());
            String value = (String)entry.getValue();
            properties.put(key.trim(), value.trim());
        }
        Builder builder = Configuration.builder();
        builder.setService(properties.getProperty("service"));
        builder.setHost(properties.getProperty("host"));
        builder.setServiceTlsPin(properties.getProperty("serviceTlsPin"));
        builder.setSecurityMode(properties.getProperty("securityMode"));
        builder.setReplyTimeout(properties.getProperty("replyTimeout", "47000"));
        String adminAccountUsername = properties.getProperty("adminAccountUsername");
        String adminAccountPassword = properties.getProperty("adminAccountPassword");
        if (StringUtils.isNotEmpty((CharSequence[])new CharSequence[]{adminAccountUsername, adminAccountPassword})) {
            builder.setAdminAccountUsernameAndPassword(adminAccountUsername, adminAccountPassword);
        }
        String accountOneUsername = properties.getProperty("accountOneUsername");
        String accountOnePassword = properties.getProperty("accountOnePassword");
        String accountTwoUsername = properties.getProperty("accountTwoUsername");
        String accountTwoPassword = properties.getProperty("accountTwoPassword");
        String accountThreeUsername = properties.getProperty("accountThreeUsername");
        String accountThreePassword = properties.getProperty("accountThreePassword");
        if (accountOneUsername != null || accountOnePassword != null || accountTwoUsername != null || accountTwoPassword != null || accountThreeUsername != null || accountThreePassword != null) {
            builder.setUsernamesAndPassword(accountOneUsername, accountOnePassword, accountTwoUsername, accountTwoPassword, accountThreeUsername, accountThreePassword);
        }
        if ((debugString = properties.getProperty("debug")) != null) {
            LOGGER.warning("Usage of deprecated 'debug' option detected, please use 'debugger' instead");
            builder.setDebugger(debugString);
        }
        builder.setDebugger(properties.getProperty("debugger"));
        builder.setEnabledTests(properties.getProperty("enabledTests"));
        builder.setDisabledTests(properties.getProperty("disabledTests"));
        builder.setEnabledSpecifications(properties.getProperty("enabledSpecifications"));
        builder.setDisabledSpecifications(properties.getProperty("disabledSpecifications"));
        builder.setDefaultConnection(properties.getProperty("defaultConnection"));
        builder.setEnabledConnections(properties.getProperty("enabledConnections"));
        builder.setDisabledConnections(properties.getProperty("disabledConnections"));
        builder.addTestPackages(properties.getProperty("testPackages"));
        builder.addTestPackages(testPackages);
        builder.setVerbose(properties.getProperty("verbose"));
        builder.setDnsResolver(properties.getProperty("dnsResolver"));
        builder.setCompatibilityMode(properties.getProperty("compatibilityMode"));
        builder.setTestRunResultProcessors(properties.getProperty("testRunResultProcessors", SmackIntegrationTestFramework.JulTestRunResultProcessor.class.getName()));
        return builder.build();
    }

    private static File findPropertiesFile() {
        LinkedList<Object> possibleLocations = new LinkedList<Object>();
        possibleLocations.add("properties");
        String userHome = System.getProperty("user.home");
        if (userHome != null) {
            possibleLocations.add(userHome + "/.config/smack-integration-test/properties");
        }
        for (String string : possibleLocations) {
            File res = new File(string);
            if (!res.isFile()) continue;
            return res;
        }
        return null;
    }

    private static Set<String> split(String input) {
        return Configuration.split(input, (Function<String, String>)Function.identity());
    }

    private static Set<String> split(String input, Function<String, String> transformer) {
        if (input == null) {
            return null;
        }
        String[] inputArray = input.split(",");
        HashSet<String> res = new HashSet<String>(inputArray.length);
        for (String s : inputArray) {
            boolean newElement = res.add(s = (String)transformer.apply((Object)s));
            if (newElement) continue;
            throw new IllegalArgumentException("The argument '" + s + "' was already provided.");
        }
        return res;
    }

    private static Set<String> getTestSetFrom(String input) {
        return Configuration.split(input, (Function<String, String>)((Function)s -> {
            if (((String)(s = ((String)s).trim())).startsWith("smackx.") || ((String)s).startsWith("smack.")) {
                s = "org.jivesoftware." + (String)s;
            }
            return s;
        }));
    }

    private static Set<String> getSpecificationSetFrom(String input) {
        return Configuration.split(input, (Function<String, String>)((Function)Configuration::normalizeSpecification));
    }

    private static List<? extends SmackIntegrationTestFramework.TestRunResultProcessor> getTestRunProcessorListFrom(String input) {
        return Arrays.stream(input.split(",")).map(element -> {
            try {
                Class<SmackIntegrationTestFramework.TestRunResultProcessor> aClass = Class.forName(element).asSubclass(SmackIntegrationTestFramework.TestRunResultProcessor.class);
                return aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to construct TestRunResultProcessor from value: " + element, e);
            }
        }).collect(Collectors.toList());
    }

    private static Map<String, Set<String>> convertTestsToMap(Set<String> tests) {
        HashMap<String, Set<String>> res = new HashMap<String, Set<String>>();
        for (String test : tests) {
            String[] testParts = test.split("\\.");
            if (testParts.length == 1) {
                res.put(test, Collections.emptySet());
                continue;
            }
            String lastTestPart = testParts[testParts.length - 1];
            if (lastTestPart.isEmpty()) {
                throw new IllegalArgumentException("Invalid test specifier: " + test);
            }
            char firstCharOfLastTestPart = lastTestPart.charAt(0);
            if (!Character.isLowerCase(firstCharOfLastTestPart)) {
                res.put(test, Collections.emptySet());
            }
            String testMethodName = lastTestPart;
            int classPartsCount = testParts.length - 1;
            CharSequence[] classParts = new String[classPartsCount];
            System.arraycopy(testParts, 0, classParts, 0, classPartsCount);
            String testClass = String.join((CharSequence)".", classParts);
            res.compute(testClass, (k, v) -> {
                if (v == null) {
                    v = new HashSet<String>();
                }
                v.add(testMethodName);
                return v;
            });
        }
        return res;
    }

    private static Set<String> getKey(Class<?> testClass, Map<String, Set<String>> testsMap) {
        String className = testClass.getName();
        if (testsMap.containsKey(className)) {
            return testsMap.get(className);
        }
        String unqualifiedClassName = testClass.getSimpleName();
        if (testsMap.containsKey(unqualifiedClassName)) {
            return testsMap.get(unqualifiedClassName);
        }
        return null;
    }

    private static boolean contains(Class<? extends AbstractSmackIntTest> testClass, Map<String, Set<String>> testsMap) {
        Set<String> enabledMethods = Configuration.getKey(testClass, testsMap);
        return enabledMethods != null;
    }

    public boolean isClassEnabled(Class<? extends AbstractSmackIntTest> testClass) {
        if (this.enabledTestsMap.isEmpty()) {
            return true;
        }
        return Configuration.contains(testClass, this.enabledTestsMap);
    }

    public boolean isClassDisabled(Class<? extends AbstractSmackIntTest> testClass) {
        if (this.disabledTestsMap.isEmpty()) {
            return false;
        }
        return Configuration.contains(testClass, this.disabledTestsMap);
    }

    private static boolean contains(Method method, Map<String, Set<String>> testsMap) {
        Class<?> testClass = method.getDeclaringClass();
        Set<String> methods = Configuration.getKey(testClass, testsMap);
        if (methods == null) {
            return false;
        }
        if (methods.isEmpty()) {
            return true;
        }
        String methodName = method.getName();
        return methods.contains(methodName);
    }

    public boolean isMethodEnabled(Method method) {
        if (this.enabledTestsMap.isEmpty()) {
            return true;
        }
        return Configuration.contains(method, this.enabledTestsMap);
    }

    public boolean isMethodDisabled(Method method) {
        if (this.disabledTestsMap.isEmpty()) {
            return false;
        }
        return Configuration.contains(method, this.disabledTestsMap);
    }

    public boolean isSpecificationEnabled(String specification) {
        if (this.enabledSpecifications.isEmpty()) {
            return true;
        }
        if (specification == null) {
            return false;
        }
        return this.enabledSpecifications.contains(Configuration.normalizeSpecification(specification));
    }

    public boolean isSpecificationDisabled(String specification) {
        if (this.disabledSpecifications.isEmpty()) {
            return false;
        }
        if (specification == null) {
            return false;
        }
        return this.disabledSpecifications.contains(Configuration.normalizeSpecification(specification));
    }

    public static String normalizeSpecification(String specification) {
        if (specification == null || specification.isBlank()) {
            return null;
        }
        return specification.replaceAll("[\\s-]", "").toUpperCase();
    }

    public static final class Builder {
        private DomainBareJid service;
        private String host;
        private String serviceTlsPin;
        private ConnectionConfiguration.SecurityMode securityMode;
        private int replyTimeout;
        private String adminAccountUsername;
        private String adminAccountPassword;
        private String accountOneUsername;
        private String accountOnePassword;
        private String accountTwoUsername;
        private String accountTwoPassword;
        public String accountThreeUsername;
        public String accountThreePassword;
        private SmackDebuggerFactory debuggerFactory;
        private Set<String> enabledTests;
        private Set<String> disabledTests;
        private Set<String> enabledSpecifications;
        private Set<String> disabledSpecifications;
        private String defaultConnectionNickname;
        private Set<String> enabledConnections;
        private Set<String> disabledConnections;
        private Set<String> testPackages;
        private boolean verbose;
        private DnsResolver dnsResolver = DnsResolver.minidns;
        private CompatibilityMode compatibilityMode = CompatibilityMode.standardsCompliant;
        private List<? extends SmackIntegrationTestFramework.TestRunResultProcessor> testRunResultProcessors;

        private Builder() {
        }

        public Builder setService(String service) throws XmppStringprepException {
            if (service == null) {
                return this;
            }
            return this.setService(JidCreate.domainBareFrom((String)service));
        }

        public Builder setService(DomainBareJid service) {
            this.service = service;
            return this;
        }

        private Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder addEnabledTest(Class<? extends AbstractSmackIntTest> enabledTest) {
            if (this.enabledTests == null) {
                this.enabledTests = new HashSet<String>();
            }
            this.enabledTests.add(enabledTest.getName());
            return this.addTestPackage(enabledTest.getPackage().getName());
        }

        private void ensureTestPackagesIsSet(int length) {
            if (this.testPackages == null) {
                this.testPackages = new HashSet<String>(length);
            }
        }

        public Builder addTestPackage(String testPackage) {
            this.ensureTestPackagesIsSet(4);
            this.testPackages.add(testPackage);
            return this;
        }

        public Builder setAdminAccountUsernameAndPassword(String adminAccountUsername, String adminAccountPassword) {
            this.adminAccountUsername = (String)StringUtils.requireNotNullNorEmpty((CharSequence)adminAccountUsername, (String)"adminAccountUsername must not be null nor empty");
            this.adminAccountPassword = (String)StringUtils.requireNotNullNorEmpty((CharSequence)adminAccountPassword, (String)"adminAccountPassword must no be null nor empty");
            return this;
        }

        public Builder setUsernamesAndPassword(String accountOneUsername, String accountOnePassword, String accountTwoUsername, String accountTwoPassword, String accountThreeUsername, String accountThreePassword) {
            this.accountOneUsername = (String)StringUtils.requireNotNullNorEmpty((CharSequence)accountOneUsername, (String)"accountOneUsername must not be null nor empty");
            this.accountOnePassword = (String)StringUtils.requireNotNullNorEmpty((CharSequence)accountOnePassword, (String)"accountOnePassword must not be null nor empty");
            this.accountTwoUsername = (String)StringUtils.requireNotNullNorEmpty((CharSequence)accountTwoUsername, (String)"accountTwoUsername must not be null nor empty");
            this.accountTwoPassword = (String)StringUtils.requireNotNullNorEmpty((CharSequence)accountTwoPassword, (String)"accountTwoPassword must not be null nor empty");
            this.accountThreeUsername = (String)StringUtils.requireNotNullNorEmpty((CharSequence)accountThreeUsername, (String)"accountThreeUsername must not be null nor empty");
            this.accountThreePassword = (String)StringUtils.requireNotNullNorEmpty((CharSequence)accountThreePassword, (String)"accountThreePassword must not be null nor empty");
            return this;
        }

        public Builder setServiceTlsPin(String tlsPin) {
            this.serviceTlsPin = tlsPin;
            return this;
        }

        public Builder setSecurityMode(String securityModeString) {
            this.securityMode = securityModeString != null ? ConnectionConfiguration.SecurityMode.valueOf((String)securityModeString) : ConnectionConfiguration.SecurityMode.required;
            return this;
        }

        public Builder setReplyTimeout(String timeout) {
            if (timeout != null) {
                this.replyTimeout = Integer.valueOf(timeout);
            }
            return this;
        }

        public Builder setDebugger(String debuggerString) {
            if (debuggerString == null) {
                return this;
            }
            switch (debuggerString) {
                case "false": {
                    LOGGER.warning("Debug string \"" + debuggerString + "\" is deprecated, please use \"none\" instead");
                }
                case "none": {
                    this.debuggerFactory = null;
                    break;
                }
                case "true": {
                    LOGGER.warning("Debug string \"" + debuggerString + "\" is deprecated, please use \"console\" instead");
                }
                case "console": {
                    this.debuggerFactory = ConsoleDebugger.Factory.INSTANCE;
                    break;
                }
                case "enhanced": {
                    this.debuggerFactory = EnhancedDebugger.Factory.INSTANCE;
                    break;
                }
                default: {
                    try {
                        Class<SmackDebuggerFactory> aClass = Class.forName(debuggerString).asSubclass(SmackDebuggerFactory.class);
                        this.debuggerFactory = aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        break;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Unable to construct debugger from value: " + debuggerString, e);
                    }
                }
            }
            return this;
        }

        public Builder setEnabledTests(String enabledTestsString) {
            this.enabledTests = Configuration.getTestSetFrom(enabledTestsString);
            return this;
        }

        public Builder setDisabledTests(String disabledTestsString) {
            this.disabledTests = Configuration.getTestSetFrom(disabledTestsString);
            return this;
        }

        public Builder setEnabledSpecifications(String enabledSpecificationsString) {
            this.enabledSpecifications = Configuration.getSpecificationSetFrom(enabledSpecificationsString);
            return this;
        }

        public Builder setDisabledSpecifications(String disabledSpecificationsString) {
            this.disabledSpecifications = Configuration.getSpecificationSetFrom(disabledSpecificationsString);
            return this;
        }

        public Builder setDefaultConnection(String defaultConnectionNickname) {
            this.defaultConnectionNickname = defaultConnectionNickname;
            return this;
        }

        public Builder setEnabledConnections(String enabledConnectionsString) {
            this.enabledConnections = Configuration.split(enabledConnectionsString);
            return this;
        }

        public Builder setDisabledConnections(String disabledConnectionsString) {
            this.disabledConnections = Configuration.split(disabledConnectionsString);
            return this;
        }

        public Builder addTestPackages(String testPackagesString) {
            if (testPackagesString != null) {
                String[] testPackagesArray = testPackagesString.split(",");
                this.ensureTestPackagesIsSet(testPackagesArray.length);
                for (String s : testPackagesArray) {
                    this.testPackages.add(s.trim());
                }
            }
            return this;
        }

        public Builder addTestPackages(String[] testPackagesString) {
            if (testPackagesString == null) {
                return this;
            }
            this.ensureTestPackagesIsSet(testPackagesString.length);
            for (String testPackage : testPackagesString) {
                this.testPackages.add(testPackage);
            }
            return this;
        }

        public Builder setVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder setVerbose(String verboseBooleanString) {
            if (verboseBooleanString == null) {
                return this;
            }
            boolean verbose = ParserUtils.parseXmlBoolean((String)verboseBooleanString);
            return this.setVerbose(verbose);
        }

        public Builder setDnsResolver(DnsResolver dnsResolver) {
            this.dnsResolver = (DnsResolver)((Object)Objects.requireNonNull((Object)((Object)dnsResolver)));
            return this;
        }

        public Builder setDnsResolver(String dnsResolverString) {
            if (dnsResolverString == null) {
                return this;
            }
            DnsResolver dnsResolver = DnsResolver.valueOf(dnsResolverString);
            return this.setDnsResolver(dnsResolver);
        }

        public Builder setCompatibilityMode(CompatibilityMode compatibilityMode) {
            this.compatibilityMode = compatibilityMode;
            return this;
        }

        public Builder setCompatibilityMode(String compatibilityModeString) {
            if (compatibilityModeString == null) {
                return this;
            }
            CompatibilityMode compatibilityMode = CompatibilityMode.valueOf(compatibilityModeString);
            return this.setCompatibilityMode(compatibilityMode);
        }

        public Builder setTestRunResultProcessors(String testRunResultProcessorsString) {
            if (testRunResultProcessorsString == null) {
                return this;
            }
            this.testRunResultProcessors = Configuration.getTestRunProcessorListFrom(testRunResultProcessorsString);
            return this;
        }

        public Configuration build() throws KeyManagementException, NoSuchAlgorithmException {
            return new Configuration(this);
        }
    }

    public static enum CompatibilityMode {
        standardsCompliant,
        ejabberd;

    }

    public static enum DnsResolver {
        minidns,
        javax,
        dnsjava;

    }

    public static enum AccountRegistration {
        disabled,
        inBandRegistration,
        serviceAdministration;

    }
}

