/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.jivesoftware.smack.util.Objects;

public class MultiResultSyncPoint<R, E extends Exception> {
    private final List<R> results;
    private E exception;
    private final int expectedResultCount;

    public MultiResultSyncPoint(int expectedResultCount) {
        this.expectedResultCount = expectedResultCount;
        this.results = new ArrayList<R>(expectedResultCount);
    }

    public synchronized List<R> waitForResults(long timeout) throws E, InterruptedException, TimeoutException {
        return this.waitForResults(timeout, null);
    }

    public synchronized List<R> waitForResults(long timeout, String timeoutMessage) throws E, InterruptedException, TimeoutException {
        long now = System.currentTimeMillis();
        long deadline = now + timeout;
        while (this.results.size() < this.expectedResultCount && this.exception == null && now < deadline) {
            this.wait(deadline - now);
            now = System.currentTimeMillis();
        }
        if (now >= deadline) {
            StringBuilder sb = new StringBuilder();
            if (timeoutMessage != null) {
                sb.append(timeoutMessage).append(". ");
            }
            sb.append("MultiResultSyncPoint timeout waiting " + timeout + " ms. Got " + this.results.size() + " results of " + this.expectedResultCount + " results");
            throw new TimeoutException(sb.toString());
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return new ArrayList<R>(this.results);
    }

    public synchronized void signal(R result) {
        this.results.add(Objects.requireNonNull(result));
        if (this.expectedResultCount <= this.results.size()) {
            this.notifyAll();
        }
    }

    public synchronized void signal(E exception) {
        this.exception = (Exception)Objects.requireNonNull(exception);
        this.notifyAll();
    }
}

