/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.caps;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.igniterealtime.smack.inttest.AbstractSmackIntTest;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.annotations.AfterClass;
import org.igniterealtime.smack.inttest.annotations.BeforeClass;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PresenceTypeFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.RosterUtil;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smackx.caps.EntityCapsManager;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.Jid;

@SpecificationReference(document="XEP-0115", version="1.6.0")
public class EntityCapsTest
extends AbstractSmackIntegrationTest {
    private final EntityCapsManager ecmTwo;
    private final ServiceDiscoveryManager sdmOne;
    private final ServiceDiscoveryManager sdmTwo;
    private final AtomicInteger dummyFeatureId = new AtomicInteger();
    private final Set<String> dummyFeatures = new HashSet<String>();

    public EntityCapsTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
        this.ecmTwo = EntityCapsManager.getInstanceFor((XMPPConnection)environment.conTwo);
        this.sdmOne = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)environment.conOne);
        this.sdmTwo = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)environment.conTwo);
    }

    private String getNewDummyFeature() {
        String dummyFeature = "entityCapsTest" + this.dummyFeatureId.incrementAndGet();
        this.dummyFeatures.add(dummyFeature);
        return dummyFeature;
    }

    @BeforeClass
    public void setUp() throws SmackException.NotLoggedInException, SmackException.NotConnectedException, InterruptedException, TimeoutException {
        RosterUtil.ensureSubscribed((XMPPConnection)this.conOne, (XMPPConnection)this.conTwo, (long)this.timeout);
    }

    @AfterClass
    public void tearDown() throws SmackException.NotConnectedException, InterruptedException {
        ServiceDiscoveryManager[] sdms;
        RosterUtil.ensureNotSubscribedToEachOther((XMPPConnection)this.conOne, (XMPPConnection)this.conTwo);
        for (ServiceDiscoveryManager sdm : sdms = new ServiceDiscoveryManager[]{this.sdmOne, this.sdmTwo}) {
            for (String dummyFeature : this.dummyFeatures) {
                sdm.removeFeature(dummyFeature);
            }
        }
    }

    @SmackIntegrationTest
    public void testLocalEntityCaps() throws InterruptedException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        final String dummyFeature = this.getNewDummyFeature();
        DiscoverInfo info = EntityCapsManager.getDiscoveryInfoByNodeVer((String)this.ecmTwo.getLocalNodeVer());
        Assertions.assertFalse((boolean)info.containsFeature((CharSequence)dummyFeature), (String)("Expected the service discovery info for node '" + this.ecmTwo.getLocalNodeVer() + "' to contain the feature '" + dummyFeature + "' (but it did not)."));
        EntityCapsTest.dropWholeEntityCapsCache();
        this.performActionAndWaitUntilStanzaReceived(new Runnable(){

            @Override
            public void run() {
                EntityCapsTest.this.sdmTwo.addFeature(dummyFeature);
            }
        }, this.conOne, (StanzaFilter)new AndFilter(new StanzaFilter[]{PresenceTypeFilter.AVAILABLE, FromMatchesFilter.create((Jid)this.conTwo.getUser())}));
        info = EntityCapsManager.getDiscoveryInfoByNodeVer((String)this.ecmTwo.getLocalNodeVer());
        Assertions.assertNotNull((Object)info, (String)("Expected '" + this.conOne.getUser() + "' to have received an 'available' presence from '" + this.conTwo.getUser() + "' with a new CAPS 'ver' attribute (but it did not)."));
        Assertions.assertTrue((boolean)info.containsFeature((CharSequence)dummyFeature), (String)("Expected the service discovery info for node '" + this.ecmTwo.getLocalNodeVer() + "' to contain the feature '" + dummyFeature + "' (but it did not)."));
    }

    @SmackIntegrationTest
    public void testPreventDiscoInfo() throws Exception {
        String dummyFeature = this.getNewDummyFeature();
        final AtomicBoolean discoInfoSend = new AtomicBoolean();
        this.conOne.addStanzaSendingListener(new StanzaListener(){

            public void processStanza(Stanza stanza) {
                discoInfoSend.set(true);
            }
        }, (StanzaFilter)new AndFilter(new StanzaFilter[]{new StanzaTypeFilter(DiscoverInfo.class), IQTypeFilter.GET}));
        this.addFeatureAndWaitForPresence(this.conOne, this.conTwo, dummyFeature);
        EntityCapsTest.dropCapsCache();
        DiscoverInfo info = this.sdmOne.discoverInfo((Jid)this.conTwo.getUser());
        Assertions.assertTrue((boolean)discoInfoSend.get(), (String)("Expected '" + this.conOne.getUser() + "' to have made a disco/info request to '" + this.conTwo.getUser() + "', but it did not."));
        Assertions.assertTrue((boolean)info.containsFeature((CharSequence)dummyFeature), (String)("The info response '" + info + "' does not contain the expected feature '" + dummyFeature + "'"));
        discoInfoSend.set(false);
        info = this.sdmOne.discoverInfo((Jid)this.conTwo.getUser());
        Assertions.assertFalse((boolean)discoInfoSend.get(), (String)("Expected '" + this.conOne.getUser() + "' to not have made a disco/info request to '" + this.conTwo.getUser() + "' (as CAPS should have been cached), but it did not."));
        Assertions.assertTrue((boolean)info.containsFeature((CharSequence)dummyFeature), (String)("The info response '" + info + "' does not contain the expected feature '" + dummyFeature + "'"));
    }

    @SmackIntegrationTest
    public void testCapsChanged() throws Exception {
        String dummyFeature = this.getNewDummyFeature();
        String nodeVerBefore = EntityCapsManager.getNodeVersionByJid((Jid)this.conTwo.getUser());
        this.addFeatureAndWaitForPresence(this.conOne, this.conTwo, dummyFeature);
        String nodeVerAfter = EntityCapsManager.getNodeVersionByJid((Jid)this.conTwo.getUser());
        Assertions.assertNotEquals((Object)nodeVerBefore, (Object)nodeVerAfter, (String)"Expected the reported node 'ver' value to differ after a feature was added (but it did not).");
    }

    @SmackIntegrationTest
    public void testEntityCaps() throws XMPPException, InterruptedException, SmackException.NoResponseException, SmackException.NotConnectedException, TimeoutException {
        final String dummyFeature = this.getNewDummyFeature();
        EntityCapsTest.dropWholeEntityCapsCache();
        this.performActionAndWaitUntilStanzaReceived(new Runnable(){

            @Override
            public void run() {
                EntityCapsTest.this.sdmTwo.addFeature(dummyFeature);
            }
        }, this.connection, (StanzaFilter)new AndFilter(new StanzaFilter[]{PresenceTypeFilter.AVAILABLE, FromMatchesFilter.create((Jid)this.conTwo.getUser())}));
        this.waitUntilTrue(new AbstractSmackIntTest.Condition(){

            @Override
            public boolean evaluate() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
                DiscoverInfo info = EntityCapsTest.this.sdmOne.discoverInfo((Jid)EntityCapsTest.this.conTwo.getUser());
                return info.containsFeature((CharSequence)dummyFeature);
            }
        });
        DiscoverInfo info = this.sdmOne.discoverInfo((Jid)this.conTwo.getUser());
        String u1ver = EntityCapsManager.getNodeVersionByJid((Jid)this.conTwo.getUser());
        Assertions.assertNotNull((Object)u1ver, (String)("Expected " + this.conOne.getUser() + " to have received a CAPS 'ver' value for " + this.conTwo.getUser() + " (but did not)."));
        DiscoverInfo entityInfo = (DiscoverInfo)EntityCapsManager.CAPS_CACHE.lookup((Object)u1ver);
        Assertions.assertNotNull((Object)entityInfo, (String)("Expected the local static cache to have a value cached for 'ver' value '" + u1ver + "' (but it did not)."));
        Assertions.assertEquals((Object)info.toXML().toString(), (Object)entityInfo.toXML().toString(), (String)"Expected the cached service/discovery info to be equal to the original (but it was not).");
    }

    private static void dropWholeEntityCapsCache() {
        EntityCapsManager.CAPS_CACHE.clear();
        EntityCapsManager.JID_TO_NODEVER_CACHE.clear();
    }

    private static void dropCapsCache() {
        EntityCapsManager.CAPS_CACHE.clear();
    }

    private void addFeatureAndWaitForPresence(XMPPConnection conA, XMPPConnection conB, final String feature) throws Exception {
        final ServiceDiscoveryManager sdmB = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)conB);
        Async.ThrowingRunnable action = new Async.ThrowingRunnable(){

            public void runOrThrow() throws Exception {
                sdmB.addFeature(feature);
            }
        };
        this.performActionAndWaitForPresence(conA, conB, action);
    }
}

