/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.geolocation;

import java.net.URI;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.annotations.AfterClass;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.igniterealtime.smack.inttest.util.IntegrationTestRosterUtil;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.disco.EntityCapabilitiesChangedListener;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.geoloc.GeoLocationManager;
import org.jivesoftware.smackx.geoloc.packet.GeoLocation;
import org.jivesoftware.smackx.pep.PepEventListener;
import org.jxmpp.util.XmppDateTime;

@SpecificationReference(document="XEP-0080", version="1.9")
public class GeolocationIntegrationTest
extends AbstractSmackIntegrationTest {
    private final GeoLocationManager glm1;
    private final GeoLocationManager glm2;

    public GeolocationIntegrationTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
        this.glm1 = GeoLocationManager.getInstanceFor((XMPPConnection)this.conOne);
        this.glm2 = GeoLocationManager.getInstanceFor((XMPPConnection)this.conTwo);
    }

    @AfterClass
    public void unsubscribe() throws SmackException.NotLoggedInException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        IntegrationTestRosterUtil.ensureBothAccountsAreNotInEachOthersRoster(this.conOne, this.conTwo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void testNotification() throws Exception {
        GeoLocation.Builder builder = GeoLocation.builder();
        GeoLocation data = builder.setAccuracy(Double.valueOf(23.0)).setAlt(Double.valueOf(1000.0)).setAltAccuracy(Double.valueOf(10.0)).setArea("Delhi").setBearing(Double.valueOf(10.0)).setBuilding("Small Building").setCountry("India").setCountryCode("IN").setDescription("My Description").setFloor("top").setLat(Double.valueOf(25.098345)).setLocality("awesome").setLon(Double.valueOf(77.992034)).setPostalcode("110085").setRegion("North").setRoom("small").setSpeed(Double.valueOf(250.0)).setStreet("Wall Street").setText("Unit Testing GeoLocation").setTimestamp(XmppDateTime.parseDate((String)"2004-02-19")).setTzo("+5:30").setUri(new URI("http://xmpp.org")).build();
        IntegrationTestRosterUtil.ensureBothAccountsAreSubscribedToEachOther(this.conOne, this.conTwo, this.timeout);
        SimpleResultSyncPoint geoLocationReceived = new SimpleResultSyncPoint();
        PepEventListener geoLocationListener = (jid, geoLocation, id, message) -> {
            if (geoLocation.equals((Object)data)) {
                geoLocationReceived.signal();
            }
        };
        try {
            this.registerListenerAndWait(this.glm2, ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.conTwo), (PepEventListener<GeoLocation>)geoLocationListener);
            this.glm1.publishGeoLocation(data);
            this.assertResult(geoLocationReceived, "Expected " + this.conTwo.getUser() + " to receive a PEP notification from " + this.conOne.getUser() + " that contained '" + data.toXML() + "', but did not.");
        }
        finally {
            this.unregisterListener(this.glm2, (PepEventListener<GeoLocation>)geoLocationListener);
            IntegrationTestRosterUtil.ensureBothAccountsAreNotInEachOthersRoster(this.conOne, this.conTwo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void testNotificationAfterFilterChange() throws Exception {
        GeoLocation.Builder builder = GeoLocation.builder();
        GeoLocation data = builder.setAccuracy(Double.valueOf(12.0)).setAlt(Double.valueOf(999.0)).setAltAccuracy(Double.valueOf(9.0)).setArea("Amsterdam").setBearing(Double.valueOf(9.0)).setBuilding("Test Building").setCountry("Netherlands").setCountryCode("NL").setDescription("My Description").setFloor("middle").setLat(Double.valueOf(25.098345)).setLocality("brilliant").setLon(Double.valueOf(77.992034)).setPostalcode("110085").setRegion("North").setRoom("small").setSpeed(Double.valueOf(250.0)).setStreet("Wall Street").setText("Unit Testing GeoLocation 2").setTimestamp(XmppDateTime.parseDate((String)"2007-02-19")).setTzo("+5:30").setUri(new URI("http://xmpp.org")).build();
        IntegrationTestRosterUtil.ensureBothAccountsAreSubscribedToEachOther(this.conOne, this.conTwo, this.timeout);
        SimpleResultSyncPoint geoLocationReceived = new SimpleResultSyncPoint();
        PepEventListener geoLocationListener = (jid, geoLocation, id, message) -> {
            if (geoLocation.equals((Object)data)) {
                geoLocationReceived.signal();
            }
        };
        try {
            this.publishAndWait(this.glm1, ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.conOne), data);
            this.registerListenerAndWait(this.glm2, ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.conTwo), (PepEventListener<GeoLocation>)geoLocationListener);
            this.assertResult(geoLocationReceived, "Expected " + this.conTwo.getUser() + " to receive a PEP notification from " + this.conOne.getUser() + " that contained '" + data.toXML() + "', but did not.");
        }
        finally {
            this.unregisterListener(this.glm2, (PepEventListener<GeoLocation>)geoLocationListener);
            IntegrationTestRosterUtil.ensureBothAccountsAreNotInEachOthersRoster(this.conOne, this.conTwo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListenerAndWait(GeoLocationManager geoManager, ServiceDiscoveryManager discoManager, PepEventListener<GeoLocation> listener) throws Exception {
        SimpleResultSyncPoint notificationFilterReceived = new SimpleResultSyncPoint();
        EntityCapabilitiesChangedListener notificationFilterReceivedListener = info -> {
            if (info.containsFeature((CharSequence)"http://jabber.org/protocol/geoloc+notify")) {
                notificationFilterReceived.signal();
            }
        };
        discoManager.addEntityCapabilitiesChangedListener(notificationFilterReceivedListener);
        try {
            geoManager.addGeoLocationListener(listener);
            notificationFilterReceived.waitForResult(this.timeout);
        }
        finally {
            discoManager.removeEntityCapabilitiesChangedListener(notificationFilterReceivedListener);
        }
    }

    public void unregisterListener(GeoLocationManager geoManager, PepEventListener<GeoLocation> listener) {
        geoManager.removeGeoLocationListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishAndWait(GeoLocationManager geoManager, ServiceDiscoveryManager discoManager, GeoLocation data) throws Exception {
        SimpleResultSyncPoint publicationEchoReceived = new SimpleResultSyncPoint();
        PepEventListener publicationEchoListener = (jid, geoLocation, id, message) -> {
            if (geoLocation.equals((Object)data)) {
                publicationEchoReceived.signal();
            }
        };
        try {
            this.registerListenerAndWait(geoManager, discoManager, (PepEventListener<GeoLocation>)publicationEchoListener);
            geoManager.addGeoLocationListener(publicationEchoListener);
            geoManager.publishGeoLocation(data);
        }
        finally {
            geoManager.removeGeoLocationListener(publicationEchoListener);
        }
    }
}

