/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iot;

import java.util.Collections;
import java.util.List;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.igniterealtime.smack.inttest.util.IntegrationTestRosterUtil;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.iot.Thing;
import org.jivesoftware.smackx.iot.data.IoTDataManager;
import org.jivesoftware.smackx.iot.data.ThingMomentaryReadOutRequest;
import org.jivesoftware.smackx.iot.data.ThingMomentaryReadOutResult;
import org.jivesoftware.smackx.iot.data.element.IoTDataField;
import org.jivesoftware.smackx.iot.data.element.IoTFieldsExtension;
import org.jivesoftware.smackx.iot.data.element.NodeElement;
import org.jivesoftware.smackx.iot.data.element.TimestampElement;
import org.junit.jupiter.api.Assertions;

@SpecificationReference(document="XEP-0347", version="0.5.1")
public class IoTDataIntegrationTest
extends AbstractSmackIntegrationTest {
    private final IoTDataManager iotDataManagerOne;
    private final IoTDataManager iotDataManagerTwo;

    public IoTDataIntegrationTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
        this.iotDataManagerOne = IoTDataManager.getInstanceFor((XMPPConnection)this.conOne);
        this.iotDataManagerTwo = IoTDataManager.getInstanceFor((XMPPConnection)this.conTwo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void dataTest() throws Exception {
        List values;
        String key = StringUtils.randomString((int)12);
        String sn = StringUtils.randomString((int)12);
        final int value = INSECURE_RANDOM.nextInt();
        Thing dataThing = Thing.builder().setKey(key).setSerialNumber(sn).setMomentaryReadOutRequestHandler(new ThingMomentaryReadOutRequest(){

            public void momentaryReadOutRequest(ThingMomentaryReadOutResult callback) {
                IoTDataField.IntField field = new IoTDataField.IntField(IoTDataIntegrationTest.this.testRunId, value);
                callback.momentaryReadOut(Collections.singletonList(field));
            }
        }).build();
        this.iotDataManagerOne.installThing(dataThing);
        try {
            IntegrationTestRosterUtil.ensureBothAccountsAreSubscribedToEachOther(this.conOne, this.conTwo, this.timeout);
            values = this.iotDataManagerTwo.requestMomentaryValuesReadOut(this.conOne.getUser());
        }
        finally {
            this.iotDataManagerOne.uninstallThing(dataThing);
            IntegrationTestRosterUtil.ensureBothAccountsAreNotInEachOthersRoster(this.conOne, this.conTwo);
        }
        Assertions.assertEquals((int)1, (int)values.size(), (String)("An unexpected amount of momentary values was received by " + this.conOne.getUser()));
        IoTFieldsExtension iotFieldsExtension = (IoTFieldsExtension)values.get(0);
        List nodes = iotFieldsExtension.getNodes();
        Assertions.assertEquals((int)1, (int)nodes.size(), (String)("The momentary value received by " + this.conOne.getUser() + " contains an unexpected amount of nodes."));
        NodeElement node = (NodeElement)nodes.get(0);
        List timestamps = node.getTimestampElements();
        Assertions.assertEquals((int)1, (int)timestamps.size(), (String)("The node received by " + this.conOne.getUser() + " contains an unexpected amount of timestamps."));
        TimestampElement timestamp = (TimestampElement)timestamps.get(0);
        List fields = timestamp.getDataFields();
        Assertions.assertEquals((int)1, (int)fields.size(), (String)("The timestamp received by " + this.conOne.getUser() + " contains an unexpected amount of data fields."));
        IoTDataField dataField = (IoTDataField)fields.get(0);
        Assertions.assertTrue((boolean)(dataField instanceof IoTDataField.IntField), (String)("The data field received by " + this.conOne.getUser() + " was expected to be an instance of " + IoTDataField.IntField.class.getSimpleName() + ", but instead, it was " + dataField.getClass().getSimpleName()));
        IoTDataField.IntField intDataField = (IoTDataField.IntField)dataField;
        Assertions.assertEquals((Object)this.testRunId, (Object)intDataField.getName(), (String)("Unexpected name in the data field received by " + this.conOne.getUser()));
        Assertions.assertEquals((int)value, (int)intDataField.getValue(), (String)("Unexpected value in the data field received by " + this.conOne.getUser()));
    }
}

