/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.muc.AbstractMultiUserChatIntegrationTest;
import org.jivesoftware.smackx.muc.MucConfigFormManager;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;

@SpecificationReference(document="XEP-0045", version="1.34.6")
public class MultiUserChatIntegrationTest
extends AbstractMultiUserChatIntegrationTest {
    public MultiUserChatIntegrationTest(SmackIntegrationTestEnvironment environment) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException, MultiUserChatException.MucAlreadyJoinedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException, XmppStringprepException {
        super(environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-message");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        final String mucMessage = "Smack Integration Test MUC Test Message " + this.randomString;
        final SimpleResultSyncPoint resultSyncPoint = new SimpleResultSyncPoint();
        mucAsSeenByTwo.addMessageListener(new MessageListener(){

            public void processMessage(Message message) {
                String body = message.getBody();
                if (mucMessage.equals(body)) {
                    resultSyncPoint.signal();
                }
            }
        });
        MultiUserChatIntegrationTest.createMuc(mucAsSeenByOne, "one-" + this.randomString);
        mucAsSeenByTwo.join(Resourcepart.from((String)("two-" + this.randomString)));
        mucAsSeenByOne.sendMessage(mucMessage);
        try {
            this.assertResult(resultSyncPoint, "Expected " + this.conTwo.getUser() + " to receive message that was sent by " + this.conOne.getUser() + " in room " + mucAddress + " (but it did not).");
        }
        finally {
            MultiUserChatIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="10.9", quote="A room owner MUST be able to destroy a room, especially if the room is persistent... The room removes all users from the room... and destroys the room")
    public void mucDestroyOwnerTest() throws TimeoutException, Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-destroy-owner");
        MultiUserChat muc = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChatIntegrationTest.createMuc(muc, Resourcepart.from((String)("one-" + this.randomString)));
        if (!this.mucManagerOne.getJoinedRooms().contains(mucAddress)) {
            MultiUserChatIntegrationTest.tryDestroy(muc);
            throw new IllegalStateException("Expected user to have joined a room '" + mucAddress + "' (but does not appear to have done so).");
        }
        final SimpleResultSyncPoint mucDestroyed = new SimpleResultSyncPoint();
        UserStatusListener userStatusListener = new UserStatusListener(){

            public void roomDestroyed(MultiUserChat alternateMUC, String password, String reason) {
                mucDestroyed.signal();
            }
        };
        muc.addUserStatusListener(userStatusListener);
        try {
            muc.destroy("Dummy reason", null);
            this.assertResult(mucDestroyed, "Expected " + this.conOne.getUser() + " to be notified of destruction of room " + mucAddress + " (but was not).");
        }
        finally {
            muc.removeUserStatusListener(userStatusListener);
        }
        Set joinedRooms = this.mucManagerOne.getJoinedRooms();
        Assertions.assertFalse((boolean)muc.isJoined(), (String)("Expected " + this.conOne.getUser() + " to no longer be in room " + mucAddress + " after it was destroyed, but it is still in."));
        Assertions.assertEquals((int)0, (int)joinedRooms.size(), (String)("Expected " + this.conOne.getUser() + " to no longer be in any rooms after " + mucAddress + " was destroyed. But it is still in " + joinedRooms));
        Assertions.assertEquals((int)0, (int)muc.getOccupantsCount(), (String)("Expected room " + mucAddress + " to no longer have any occupants after it was destroyed (but it has)."));
        Assertions.assertNull((Object)muc.getNickname());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="10.9", quote="A room owner MUST be able to destroy a room, especially if the room is persistent... The room removes all users from the room... and destroys the room")
    public void mucDestroyTestOccupant() throws TimeoutException, Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-destroy-occupant");
        MultiUserChat mucAsSeenByOwner = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByParticipant = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChatIntegrationTest.createMuc(mucAsSeenByOwner, Resourcepart.from((String)("one-" + this.randomString)));
        mucAsSeenByParticipant.join(Resourcepart.from((String)("two-" + this.randomString)));
        if (!this.mucManagerTwo.getJoinedRooms().contains(mucAddress)) {
            MultiUserChatIntegrationTest.tryDestroy(mucAsSeenByOwner);
            throw new IllegalStateException("Expected user to have joined a room '" + mucAddress + "' (but does not appear to have done so).");
        }
        final SimpleResultSyncPoint mucDestroyed = new SimpleResultSyncPoint();
        UserStatusListener userStatusListener = new UserStatusListener(){

            public void roomDestroyed(MultiUserChat alternateMUC, String password, String reason) {
                mucDestroyed.signal();
            }
        };
        mucAsSeenByParticipant.addUserStatusListener(userStatusListener);
        try {
            mucAsSeenByOwner.destroy("Dummy reason", null);
            this.assertResult(mucDestroyed, "Expected " + this.conTwo.getUser() + " to be notified of destruction of room " + mucAddress + " (but was not).");
        }
        finally {
            mucAsSeenByParticipant.removeUserStatusListener(userStatusListener);
        }
        Set joinedRooms = this.mucManagerTwo.getJoinedRooms();
        Assertions.assertFalse((boolean)mucAsSeenByParticipant.isJoined(), (String)("Expected " + this.conTwo.getUser() + " to no longer be in room " + mucAddress + " after it was destroyed, but it is still in."));
        Assertions.assertEquals((int)0, (int)joinedRooms.size(), (String)("Expected " + this.conTwo.getUser() + " to no longer be in any rooms after " + mucAddress + " was destroyed. But it is still in " + joinedRooms));
        Assertions.assertEquals((int)0, (int)mucAsSeenByParticipant.getOccupantsCount(), (String)("Expected room " + mucAddress + " to no longer have any occupants after it was destroyed (but it has)."));
        Assertions.assertNull((Object)mucAsSeenByParticipant.getNickname());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void mucNameChangeTest() throws XmppStringprepException, MultiUserChatException.MucAlreadyJoinedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, MultiUserChatException.MucConfigurationNotSupportedException {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-muc-name-change");
        MultiUserChat muc = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChatIntegrationTest.createMuc(muc, Resourcepart.from((String)("one-" + this.randomString)));
        String newRoomName = "New Room Name (" + this.randomString + ")";
        try {
            muc.getConfigFormManager().setRoomName(newRoomName).submitConfigurationForm();
            MultiUserChatManager mucManager = MultiUserChatManager.getInstanceFor((XMPPConnection)this.conTwo);
            RoomInfo roomInfo = mucManager.getRoomInfo(muc.getRoom());
            Assertions.assertEquals((Object)newRoomName, (Object)roomInfo.getName());
        }
        finally {
            MultiUserChatIntegrationTest.tryDestroy(muc);
        }
    }

    @SmackIntegrationTest(section="8.1", quote="modify the subject [...] MUST be denied if the <user@host> of the 'from' address of the request does not match the bare JID portion of one of the moderators; in this case, the service MUST return a <forbidden/> error.")
    public void mucTestVisitorNotAllowedToChangeSubject() throws XmppStringprepException, MultiUserChatException.MucAlreadyJoinedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-visitor-change-subject");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        Resourcepart nicknameOne = Resourcepart.from((String)("one-" + this.randomString));
        Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
        MultiUserChatIntegrationTest.createMuc(mucAsSeenByOne, nicknameOne);
        try {
            MucConfigFormManager configFormManager = mucAsSeenByOne.getConfigFormManager();
            if (configFormManager.occupantsAreAllowedToChangeSubject()) {
                configFormManager.disallowOccupantsToChangeSubject().submitConfigurationForm();
            }
            mucAsSeenByTwo.join(nicknameTwo);
            XMPPException.XMPPErrorException e = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> mucAsSeenByTwo.changeSubject("Test Subject Change"), (String)("Expected an error after '" + this.conTwo.getUser() + "' (that is not a moderator) tried to change the subject of room '" + mucAddress + "' (but none occurred)."));
            Assertions.assertEquals((Object)StanzaError.Condition.forbidden, (Object)e.getStanzaError().getCondition(), (String)("Unexpected error condition in the (expected) error that was returned to '" + this.conTwo.getUser() + "' after it tried to change to subject of room '" + mucAddress + "' while not being a moderator."));
        }
        catch (MultiUserChatException.MucConfigurationNotSupportedException e) {
            throw new TestNotPossibleException(e);
        }
        finally {
            MultiUserChatIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    @SmackIntegrationTest
    public void mucTestChangeRoomName() throws XmppStringprepException, MultiUserChatException.MucAlreadyJoinedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-change-room-name");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        Resourcepart nicknameOne = Resourcepart.from((String)("one-" + this.randomString));
        MultiUserChatIntegrationTest.createMuc(mucAsSeenByOne, nicknameOne);
        try {
            String initialRoomName = "Initial Room Name";
            mucAsSeenByOne.getConfigFormManager().setRoomName(initialRoomName).submitConfigurationForm();
            RoomInfo roomInfo = this.mucManagerOne.getRoomInfo(mucAddress);
            Assertions.assertEquals((Object)initialRoomName, (Object)roomInfo.getName());
            String newRoomName = "New Room Name";
            mucAsSeenByOne.getConfigFormManager().setRoomName(newRoomName).submitConfigurationForm();
            roomInfo = this.mucManagerOne.getRoomInfo(mucAddress);
            Assertions.assertEquals((Object)newRoomName, (Object)roomInfo.getName());
        }
        catch (MultiUserChatException.MucConfigurationNotSupportedException e) {
            throw new TestNotPossibleException(e);
        }
        finally {
            MultiUserChatIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }
}

