/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.io.IOException;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.AfterClass;
import org.igniterealtime.smack.inttest.annotations.BeforeClass;
import org.igniterealtime.smack.inttest.util.IntegrationTestRosterUtil;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.omemo.AbstractOmemoIntegrationTest;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoManagerSetupHelper;
import org.junit.jupiter.api.Assertions;

public abstract class AbstractTwoUsersOmemoIntegrationTest
extends AbstractOmemoIntegrationTest {
    protected OmemoManager alice;
    protected OmemoManager bob;

    public AbstractTwoUsersOmemoIntegrationTest(SmackIntegrationTestEnvironment environment) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, TestNotPossibleException {
        super(environment);
    }

    @BeforeClass
    public void setup() throws Exception {
        this.alice = OmemoManagerSetupHelper.prepareOmemoManager(this.conOne);
        this.bob = OmemoManagerSetupHelper.prepareOmemoManager(this.conTwo);
        Assertions.assertNotEquals((Integer)this.alice.getDeviceId(), (Integer)this.bob.getDeviceId(), (String)("Expected device ID for " + this.conOne.getUser() + " to differ from that of " + this.conTwo.getUser() + " (but they did not)"));
        IntegrationTestRosterUtil.ensureBothAccountsAreSubscribedToEachOther(this.alice.getConnection(), this.bob.getConnection(), this.timeout);
        OmemoManagerSetupHelper.trustAllIdentitiesWithTests(this.alice, this.bob);
        OmemoManagerSetupHelper.trustAllIdentitiesWithTests(this.bob, this.alice);
        Assertions.assertEquals((Object)this.bob.getOwnFingerprint(), this.alice.getActiveFingerprints(this.bob.getOwnJid()).get(this.bob.getOwnDevice()), (String)("Expected fingerprint of " + this.conTwo.getUser() + "'s device as known to " + this.conOne.getUser() + " to be equal to " + this.conTwo.getUser() + "'s own fingerprint (but it was not)."));
        Assertions.assertEquals((Object)this.alice.getOwnFingerprint(), this.bob.getActiveFingerprints(this.alice.getOwnJid()).get(this.alice.getOwnDevice()), (String)("Expected fingerprint of " + this.conOne.getUser() + "'s device as known to " + this.conTwo.getUser() + " to be equal to " + this.conOne.getUser() + "'s own fingerprint (but it was not)."));
    }

    @AfterClass
    public void cleanUp() throws IOException, SmackException.NotConnectedException, InterruptedException {
        this.alice.stopStanzaAndPEPListeners();
        this.bob.stopStanzaAndPEPListeners();
        OmemoManagerSetupHelper.cleanUpPubSub(this.alice);
        OmemoManagerSetupHelper.cleanUpRoster(this.alice);
        OmemoManagerSetupHelper.cleanUpPubSub(this.bob);
        OmemoManagerSetupHelper.cleanUpRoster(this.bob);
    }
}

