/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest;

import java.lang.reflect.Method;
import java.util.List;
import org.igniterealtime.smack.inttest.AbstractSmackLowLevelIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestFramework;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SmackIntegrationTestFrameWorkTest {
    private static Method getTestMethod(Class<?> testClass) {
        Method[] methods;
        for (Method method : methods = testClass.getDeclaredMethods()) {
            if (!method.getName().equals("test")) continue;
            return method;
        }
        throw new IllegalArgumentException("No test method found in " + testClass);
    }

    @Test
    public void testValidLowLevelList() {
        Method testMethod = SmackIntegrationTestFrameWorkTest.getTestMethod(ValidLowLevelList.class);
        SmackIntegrationTestFramework.TestMethodParameterType determinedParameterType = SmackIntegrationTestFramework.determineTestMethodParameterType((Method)testMethod, AbstractXMPPConnection.class);
        Assertions.assertEquals((Object)SmackIntegrationTestFramework.TestMethodParameterType.collectionOfConnections, (Object)determinedParameterType);
    }

    @Test
    public void testInvalidLowLevelList() {
        Method testMethod = SmackIntegrationTestFrameWorkTest.getTestMethod(InvalidLowLevelList.class);
        SmackIntegrationTestFramework.TestMethodParameterType determinedParameterType = SmackIntegrationTestFramework.determineTestMethodParameterType((Method)testMethod, AbstractXMPPConnection.class);
        Assertions.assertNull((Object)determinedParameterType);
    }

    @Test
    public void testValidLowLevelVarargs() {
        Method testMethod = SmackIntegrationTestFrameWorkTest.getTestMethod(ValidLowLevelVarargs.class);
        SmackIntegrationTestFramework.TestMethodParameterType determinedParameterType = SmackIntegrationTestFramework.determineTestMethodParameterType((Method)testMethod, AbstractXMPPConnection.class);
        Assertions.assertEquals((Object)SmackIntegrationTestFramework.TestMethodParameterType.parameterListOfConnections, (Object)determinedParameterType);
    }

    @Test
    public void testInvalidLowLevelVargs() {
        Method testMethod = SmackIntegrationTestFrameWorkTest.getTestMethod(InvalidLowLevelVarargs.class);
        SmackIntegrationTestFramework.TestMethodParameterType determinedParameterType = SmackIntegrationTestFramework.determineTestMethodParameterType((Method)testMethod, AbstractXMPPConnection.class);
        Assertions.assertNull((Object)determinedParameterType);
    }

    @Test
    public void testValidUnconnectedConnectionSource() {
        Method testMethod = SmackIntegrationTestFrameWorkTest.getTestMethod(ValidUnconnectedConnectionSource.class);
        SmackIntegrationTestFramework.TestMethodParameterType determinedParameterType = SmackIntegrationTestFramework.determineTestMethodParameterType((Method)testMethod, AbstractXMPPConnection.class);
        Assertions.assertEquals((Object)SmackIntegrationTestFramework.TestMethodParameterType.unconnectedConnectionSource, (Object)determinedParameterType);
    }

    private static class ValidLowLevelList {
        private ValidLowLevelList() {
        }

        public void test(List<AbstractXMPPConnection> connections) {
        }
    }

    private static class InvalidLowLevelList {
        private InvalidLowLevelList() {
        }

        public void test(List<AbstractXMPPConnection> connections, boolean invalid) {
        }
    }

    private static class ValidLowLevelVarargs {
        private ValidLowLevelVarargs() {
        }

        public void test(AbstractXMPPConnection connectionOne, AbstractXMPPConnection connectionTwo, AbstractXMPPConnection connectionThree) {
        }
    }

    private static class InvalidLowLevelVarargs {
        private InvalidLowLevelVarargs() {
        }

        public void test(AbstractXMPPConnection connectionOne, Integer invalid, AbstractXMPPConnection connectionTwo, AbstractXMPPConnection connectionThree) {
        }
    }

    private static class ValidUnconnectedConnectionSource {
        private ValidUnconnectedConnectionSource() {
        }

        public void test(AbstractSmackLowLevelIntegrationTest.UnconnectedConnectionSource source) {
        }
    }
}

