/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest.util;

import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeoutException;
import org.igniterealtime.smack.inttest.util.MultiResultSyncPoint;
import org.igniterealtime.smack.inttest.util.ResultSyncPoint;
import org.jivesoftware.smack.util.Async;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MultiResultSyncPointTest {
    @Test
    public void testResultSyncPoint() throws Exception {
        String result1 = "r1";
        String result2 = "r2";
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final MultiResultSyncPoint rsp = new MultiResultSyncPoint(2);
        Async.go((Runnable)new Async.ThrowingRunnable(){

            public void runOrThrow() throws InterruptedException, BrokenBarrierException {
                barrier.await();
                rsp.signal((Object)"r1");
                rsp.signal((Object)"r2");
            }
        });
        barrier.await();
        List receivedResult = rsp.waitForResults(60000L);
        Assertions.assertTrue((boolean)receivedResult.contains("r1"));
        Assertions.assertTrue((boolean)receivedResult.contains("r2"));
    }

    @Test
    public void exceptionTestResultSyncPoint() throws Exception {
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final ResultSyncPoint rsp = new ResultSyncPoint();
        Async.go((Runnable)new Async.ThrowingRunnable(){

            public void runOrThrow() throws InterruptedException, BrokenBarrierException {
                barrier.await();
                rsp.signal((Exception)new TestException());
            }
        });
        barrier.await();
        Assertions.assertThrows(TestException.class, () -> rsp.waitForResult(60000L));
    }

    @Test
    public void testTimeout() throws Exception {
        MultiResultSyncPoint rsp = new MultiResultSyncPoint(2);
        try {
            rsp.waitForResults(100L);
            Assertions.fail((String)"A timeout exception should have been thrown.");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Test
    public void testTimeoutWithOneResult() throws Exception {
        String result1 = "partial";
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final MultiResultSyncPoint rsp = new MultiResultSyncPoint(2);
        Async.go((Runnable)new Async.ThrowingRunnable(){

            public void runOrThrow() throws InterruptedException, BrokenBarrierException {
                barrier.await();
                rsp.signal((Object)"partial");
            }
        });
        barrier.await();
        try {
            rsp.waitForResults(100L);
            Assertions.fail((String)"A timeout exception should have been thrown.");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    private static class TestException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private TestException() {
        }
    }
}

