/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import org.igniterealtime.smack.inttest.AbstractSmackSpecificLowLevelIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.MessageWithBodiesFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public class StreamManagementTest
extends AbstractSmackSpecificLowLevelIntegrationTest<XMPPTCPConnection> {
    public StreamManagementTest(SmackIntegrationTestEnvironment environment) throws Exception {
        super(environment, XMPPTCPConnection.class);
        XMPPTCPConnection connection = (XMPPTCPConnection)this.getSpecificUnconnectedConnection();
        connection.connect().login();
        if (!connection.isSmAvailable()) {
            throw new TestNotPossibleException("XEP-198: Stream Mangement not supported by service");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void testStreamManagement(XMPPTCPConnection conOne, XMPPTCPConnection conTwo) throws InterruptedException, SmackException, IOException, XMPPException {
        String body1 = "Hi, what's up? " + this.testRunId;
        String body2 = "Hi, what's up? I've been just instantly shutdown" + this.testRunId;
        String body3 = "Hi, what's up? I've been just resumed" + this.testRunId;
        StanzaCollector collector = conTwo.createStanzaCollector((StanzaFilter)new AndFilter(new StanzaFilter[]{MessageWithBodiesFilter.INSTANCE, FromMatchesFilter.createFull((Jid)conOne.getUser())}));
        try {
            StreamManagementTest.send(body1, (XMPPConnection)conOne, (XMPPConnection)conTwo);
            StreamManagementTest.assertMessageWithBodyReceived(body1, collector, conTwo.getUser());
            conOne.instantShutdown();
            StreamManagementTest.send(body2, (XMPPConnection)conOne, (XMPPConnection)conTwo);
            conOne.connect().login();
            StreamManagementTest.assertMessageWithBodyReceived(body2, collector, conTwo.getUser());
            StreamManagementTest.send(body3, (XMPPConnection)conOne, (XMPPConnection)conTwo);
            StreamManagementTest.assertMessageWithBodyReceived(body3, collector, conTwo.getUser());
        }
        finally {
            collector.cancel();
        }
    }

    private static void send(String messageString, XMPPConnection from, XMPPConnection to) throws SmackException.NotConnectedException, InterruptedException {
        Message message = ((MessageBuilder)from.getStanzaFactory().buildMessageStanza().to((Jid)to.getUser())).setBody(messageString).build();
        from.sendStanza((Stanza)message);
    }

    private static void assertMessageWithBodyReceived(String body, StanzaCollector collector, EntityFullJid recipient) throws InterruptedException {
        Message message = (Message)collector.nextResult();
        Assertions.assertNotNull((Object)message, (String)("Expected '" + recipient + "' to receive a message stanza with body '" + body + "', but it didn't receive the message stanza at all."));
        Assertions.assertEquals((Object)body, (Object)message.getBody(), (String)("Expected '" + recipient + "'to receive a message stanza with a specific body, but it received a message stanza with a different body."));
    }
}

