/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata;

import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.chat.Chat;
import org.jivesoftware.smack.chat.ChatManager;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.ThreadFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smackx.xdata.BooleanFormField;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.TextMultiFormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.form.FillableForm;
import org.jivesoftware.smackx.xdata.form.Form;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;

public class FormTest
extends AbstractSmackIntegrationTest {
    public FormTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void testFilloutForm() throws SmackException.NotConnectedException, InterruptedException {
        DataForm.Builder formToSend = DataForm.builder((DataForm.Type)DataForm.Type.form);
        formToSend.setInstructions("Fill out this form to report your case.\nThe case will be created automatically.");
        formToSend.setTitle("Case configurations");
        formToSend.setFormType("https://igniterealtime.org/projects/smack/sinttest/form-test/1");
        TextSingleFormField field = ((TextSingleFormField.Builder)FormField.hiddenBuilder((String)"hidden_var").setValue((CharSequence)"Some value for the hidden variable")).build();
        formToSend.addField((FormField)field);
        field = ((TextSingleFormField.Builder)FormField.fixedBuilder().setValue((CharSequence)"Section 1: Case description")).build();
        formToSend.addField((FormField)field);
        field = ((TextSingleFormField.Builder)FormField.textSingleBuilder((String)"name").setLabel("Enter a name for the case")).build();
        formToSend.addField((FormField)field);
        field = ((TextMultiFormField.Builder)FormField.textMultiBuilder((String)"description").setLabel("Enter a description")).build();
        formToSend.addField((FormField)field);
        field = ((BooleanFormField.Builder)FormField.booleanBuilder((String)"time").setLabel("Is this your first case?")).build();
        formToSend.addField((FormField)field);
        field = ((TextSingleFormField.Builder)FormField.textSingleBuilder((String)"age").setLabel("How old are you?")).build();
        formToSend.addField((FormField)field);
        Chat chat = ChatManager.getInstanceFor((XMPPConnection)this.conOne).createChat((EntityJid)this.conTwo.getUser(), null);
        StanzaCollector collector = this.conOne.createStanzaCollector((StanzaFilter)new ThreadFilter(chat.getThreadID()));
        StanzaCollector collector2 = this.conTwo.createStanzaCollector((StanzaFilter)new ThreadFilter(chat.getThreadID()));
        Message msg = ((MessageBuilder)StanzaBuilder.buildMessage().setBody("To enter a case please fill out this form and send it back to me").addExtension((XmlElement)formToSend.build())).build();
        try {
            chat.sendMessage(msg);
            Message msg2 = (Message)collector2.nextResult();
            Assertions.assertNotNull((Object)msg2, (String)"Message not found");
            Form formToRespond = Form.from((StanzaView)msg2);
            Assertions.assertNotNull((Object)formToRespond);
            Assertions.assertNotNull((Object)formToRespond.getField("name"));
            Assertions.assertNotNull((Object)formToRespond.getField("description"));
            FillableForm completedForm = formToRespond.getFillableForm();
            Assertions.assertNotNull((Object)completedForm.getField("hidden_var"));
            Assertions.assertThrows(IllegalArgumentException.class, () -> completedForm.setAnswer("name", true));
            completedForm.setAnswer("name", (CharSequence)"Credit card number invalid");
            completedForm.setAnswer("description", (CharSequence)"The ATM says that my credit card number is invalid. What's going on?");
            completedForm.setAnswer("time", true);
            completedForm.setAnswer("age", 20);
            Message msg3 = ((MessageBuilder)((MessageBuilder)StanzaBuilder.buildMessage().to((Jid)this.conOne.getUser().asBareJid())).setThread(msg2.getThread()).ofType(Message.Type.chat).setBody("To enter a case please fill out this form and send it back to me").addExtension((XmlElement)completedForm.getDataFormToSubmit())).build();
            this.conTwo.sendStanza((Stanza)msg3);
            Message msg4 = (Message)collector.nextResult();
            Assertions.assertNotNull((Object)msg4, (String)"Message not found");
            DataForm completedForm2 = DataForm.from((StanzaView)msg4);
            Assertions.assertNotNull((Object)completedForm2);
            Assertions.assertNotNull((Object)completedForm2.getField("name"));
            Assertions.assertNotNull((Object)completedForm2.getField("description"));
            Assertions.assertEquals((Object)"Credit card number invalid", (Object)((CharSequence)completedForm2.getField("name").getValues().get(0)).toString());
            Assertions.assertNotNull((Object)completedForm2.getField("time"));
            Assertions.assertNotNull((Object)completedForm2.getField("age"));
            Assertions.assertEquals((Object)"20", (Object)((CharSequence)completedForm2.getField("age").getValues().get(0)).toString(), (String)"The age is bad");
        }
        finally {
            collector.cancel();
            collector2.cancel();
        }
    }
}

