/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest.util;

import java.util.concurrent.TimeoutException;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.roster.AbstractPresenceEventListener;
import org.jivesoftware.smack.roster.PresenceEventListener;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.SubscribeListener;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public class IntegrationTestRosterUtil {
    public static void ensureBothAccountsAreSubscribedToEachOther(XMPPConnection conOne, XMPPConnection conTwo, long timeout) throws TimeoutException, Exception {
        IntegrationTestRosterUtil.ensureSubscribedTo(conOne, conTwo, timeout);
        IntegrationTestRosterUtil.ensureSubscribedTo(conTwo, conOne, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureSubscribedTo(XMPPConnection presenceRequestReceiverConnection, final XMPPConnection presenceRequestingConnection, long timeout) throws TimeoutException, Exception {
        Roster presenceRequestReceiverRoster = Roster.getInstanceFor((XMPPConnection)presenceRequestReceiverConnection);
        Roster presenceRequestingRoster = Roster.getInstanceFor((XMPPConnection)presenceRequestingConnection);
        final EntityFullJid presenceRequestReceiverAddress = presenceRequestReceiverConnection.getUser();
        EntityFullJid presenceRequestingAddress = presenceRequestingConnection.getUser();
        if (presenceRequestReceiverRoster.isSubscribedToMyPresence((Jid)presenceRequestingAddress)) {
            return;
        }
        SubscribeListener subscribeListener = new SubscribeListener(){

            public SubscribeListener.SubscribeAnswer processSubscribe(Jid from, Presence subscribeRequest) {
                if (from.equals((CharSequence)presenceRequestingConnection.getUser().asBareJid())) {
                    return SubscribeListener.SubscribeAnswer.Approve;
                }
                return SubscribeListener.SubscribeAnswer.Deny;
            }
        };
        presenceRequestReceiverRoster.addSubscribeListener(subscribeListener);
        final SimpleResultSyncPoint syncPoint = new SimpleResultSyncPoint();
        AbstractPresenceEventListener presenceEventListener = new AbstractPresenceEventListener(){

            public void presenceSubscribed(BareJid address, Presence subscribedPresence) {
                if (!address.equals((CharSequence)presenceRequestReceiverAddress.asBareJid())) {
                    return;
                }
                syncPoint.signal();
            }
        };
        presenceRequestingRoster.addPresenceEventListener((PresenceEventListener)presenceEventListener);
        try {
            presenceRequestingRoster.sendSubscriptionRequest(presenceRequestReceiverAddress.asBareJid());
            syncPoint.waitForResult(timeout, "Timeout while waiting for subscription request of '" + String.valueOf(presenceRequestingAddress) + "' to '" + String.valueOf(presenceRequestReceiverAddress) + "' to be answered.");
        }
        finally {
            presenceRequestReceiverRoster.removeSubscribeListener(subscribeListener);
            presenceRequestingRoster.removePresenceEventListener((PresenceEventListener)presenceEventListener);
        }
    }

    public static void ensureBothAccountsAreNotInEachOthersRoster(XMPPConnection conOne, XMPPConnection conTwo) throws SmackException.NotLoggedInException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        IntegrationTestRosterUtil.notInRoster(conOne, conTwo);
        IntegrationTestRosterUtil.notInRoster(conTwo, conOne);
    }

    private static void notInRoster(XMPPConnection c1, XMPPConnection c2) throws SmackException.NotLoggedInException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Roster roster = Roster.getInstanceFor((XMPPConnection)c1);
        RosterEntry c2Entry = roster.getEntry(c2.getUser().asBareJid());
        if (c2Entry == null) {
            return;
        }
        try {
            roster.removeEntry(c2Entry);
        }
        catch (XMPPException.XMPPErrorException e) {
            if (e.getStanzaError().getCondition() == StanzaError.Condition.item_not_found) {
                return;
            }
            throw e;
        }
    }
}

