/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.Collection;
import java.util.concurrent.TimeoutException;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.igniterealtime.smack.inttest.util.IntegrationTestRosterUtil;
import org.igniterealtime.smack.inttest.util.ResultSyncPoint;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.PresenceTypeFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.AbstractRosterListener;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.RosterListener;
import org.jivesoftware.smack.roster.SubscribeListener;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.util.Consumer;
import org.jivesoftware.smack.util.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.Jid;

@SpecificationReference(document="RFC6121")
public class RosterIntegrationTest
extends AbstractSmackIntegrationTest {
    private final Roster rosterOne;
    private final Roster rosterTwo;

    public RosterIntegrationTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
        this.rosterOne = Roster.getInstanceFor((XMPPConnection)this.conOne);
        this.rosterTwo = Roster.getInstanceFor((XMPPConnection)this.conTwo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void subscribeRequestListenerTest() throws TimeoutException, Exception {
        IntegrationTestRosterUtil.ensureBothAccountsAreNotInEachOthersRoster(this.conOne, this.conTwo);
        SubscribeListener subscribeListener = new SubscribeListener(){

            public SubscribeListener.SubscribeAnswer processSubscribe(Jid from, Presence subscribeRequest) {
                if (from.equals((CharSequence)RosterIntegrationTest.this.conOne.getUser().asBareJid())) {
                    return SubscribeListener.SubscribeAnswer.Approve;
                }
                return SubscribeListener.SubscribeAnswer.Deny;
            }
        };
        this.rosterTwo.addSubscribeListener(subscribeListener);
        final String conTwosRosterName = "ConTwo " + this.testRunId;
        final SimpleResultSyncPoint addedAndSubscribed = new SimpleResultSyncPoint();
        AbstractRosterListener rosterListener = new AbstractRosterListener(){

            public void entriesAdded(Collection<Jid> addresses) {
                this.checkIfAddedAndSubscribed(addresses);
            }

            public void entriesUpdated(Collection<Jid> addresses) {
                this.checkIfAddedAndSubscribed(addresses);
            }

            private void checkIfAddedAndSubscribed(Collection<Jid> addresses) {
                for (Jid jid : addresses) {
                    if (!jid.equals((CharSequence)RosterIntegrationTest.this.conTwo.getUser().asBareJid())) continue;
                    BareJid bareJid = RosterIntegrationTest.this.conTwo.getUser().asBareJid();
                    RosterEntry rosterEntry = RosterIntegrationTest.this.rosterOne.getEntry(bareJid);
                    if (rosterEntry == null) {
                        addedAndSubscribed.signalFailure("Added/Updated entry was not for " + String.valueOf(bareJid));
                        return;
                    }
                    String name = rosterEntry.getName();
                    if (StringUtils.isNullOrEmpty((CharSequence)name)) {
                        addedAndSubscribed.signalFailure("Added/Updated entry without name");
                        return;
                    }
                    if (!rosterEntry.getName().equals(conTwosRosterName)) {
                        addedAndSubscribed.signalFailure("Added/Updated entry name does not match. Expected: " + conTwosRosterName + " but was: " + rosterEntry.getName());
                        return;
                    }
                    if (!rosterEntry.getType().equals((Object)RosterPacket.ItemType.to)) {
                        return;
                    }
                    addedAndSubscribed.signal();
                }
            }
        };
        this.rosterOne.addRosterListener((RosterListener)rosterListener);
        try {
            this.rosterOne.createItemAndRequestSubscription(this.conTwo.getUser().asBareJid(), conTwosRosterName, null);
            this.assertResult(addedAndSubscribed, "A roster entry for " + String.valueOf(this.conTwo.getUser().asBareJid()) + " using the name '" + conTwosRosterName + "' of type 'to' was expected to be added to the roster of " + String.valueOf(this.conOne.getUser()) + " (but it was not).");
        }
        finally {
            this.rosterTwo.removeSubscribeListener(subscribeListener);
            this.rosterOne.removeRosterListener((RosterListener)rosterListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="3.1.2", quote="After locally delivering or remotely routing the presence subscription request, the user's server MUST then send a roster push to all of the user's interested resources, containing the potential contact with a subscription state of \"none\" and with notation that the subscription is pending (via an 'ask' attribute whose value is \"subscribe\").")
    public void testRosterPushAfterSubscriptionRequest() throws Exception {
        IntegrationTestRosterUtil.ensureBothAccountsAreNotInEachOthersRoster(this.conOne, this.conTwo);
        this.rosterTwo.setSubscriptionMode(Roster.SubscriptionMode.manual);
        final ResultSyncPoint added = new ResultSyncPoint();
        AbstractRosterListener rosterListener = new AbstractRosterListener(){

            public void entriesAdded(Collection<Jid> addresses) {
                for (Jid jid : addresses) {
                    if (!jid.equals((CharSequence)RosterIntegrationTest.this.conTwo.getUser().asBareJid())) continue;
                    BareJid bareJid = RosterIntegrationTest.this.conTwo.getUser().asBareJid();
                    RosterEntry rosterEntry = RosterIntegrationTest.this.rosterOne.getEntry(bareJid);
                    added.signal(rosterEntry);
                    return;
                }
            }
        };
        this.rosterOne.addRosterListener((RosterListener)rosterListener);
        Presence subscribe = ((PresenceBuilder)this.conOne.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.subscribe).to((Jid)this.conTwo.getUser().asBareJid())).build();
        try {
            this.conOne.sendStanza((Stanza)subscribe);
            RosterEntry rosterEntry = (RosterEntry)this.assertResult(added, "Expected the server to send a roster push back to '" + String.valueOf(this.conOne.getUser()) + "' after they sent a presence subscription request to '" + String.valueOf(this.conTwo.getUser().asBareJid()) + "' (but the server did not).");
            Assertions.assertEquals((Object)RosterPacket.ItemType.none, (Object)rosterEntry.getType(), (String)("Unexpected subscription type on roster push after '" + String.valueOf(this.conOne.getUser()) + "' sent a presence subscription request to '" + String.valueOf(this.conTwo.getUser().asBareJid()) + "'."));
            Assertions.assertTrue((boolean)rosterEntry.isSubscriptionPending(), (String)("Missing 'ask=subscribe' attribute on roster push after '" + String.valueOf(this.conOne.getUser()) + "' sent a presence subscription request to '" + String.valueOf(this.conTwo.getUser().asBareJid()) + "'."));
        }
        finally {
            this.rosterTwo.setSubscriptionMode(Roster.getDefaultSubscriptionMode());
            this.rosterOne.removeRosterListener((RosterListener)rosterListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="3.1.3", quote="if there is at least one available resource associated with the contact when the subscription request is received by the contact's server, then the contact's server MUST send that subscription request to all available resources in accordance with Section 8.")
    public void testPresenceDeliveredToRecipient() throws Exception {
        IntegrationTestRosterUtil.ensureBothAccountsAreNotInEachOthersRoster(this.conOne, this.conTwo);
        ResultSyncPoint added = new ResultSyncPoint();
        StanzaListener stanzaListener = stanza -> added.signal((Presence)stanza);
        this.conTwo.addAsyncStanzaListener(stanzaListener, (StanzaFilter)new AndFilter(new StanzaFilter[]{StanzaTypeFilter.PRESENCE, FromMatchesFilter.createBare((Jid)this.conOne.getUser())}));
        Presence subscribe = ((PresenceBuilder)this.conOne.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.subscribe).to((Jid)this.conTwo.getUser().asBareJid())).build();
        try {
            this.conOne.sendStanza((Stanza)subscribe);
            Presence received = (Presence)this.assertResult(added, "Expected subscription request from '" + String.valueOf(this.conOne.getUser()) + "' to '" + String.valueOf(this.conTwo.getUser().asBareJid()) + "' to be delivered to " + String.valueOf(this.conTwo.getUser()) + " (but it did not).");
            Assertions.assertEquals((Object)Presence.Type.subscribe, (Object)received.getType(), (String)("Unexpected presence type in presence stanza received by '" + String.valueOf(this.conTwo.getUser()) + "' after '" + String.valueOf(this.conOne.getUser()) + "' sent a presence subscription request."));
        }
        finally {
            this.conTwo.removeAsyncStanzaListener(stanzaListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="3.1.5", quote="When the contact's client sends the subscription approval, the contact's server MUST stamp the outbound stanza with the bare JID <contact@domainpart> of the contact and locally deliver or remotely route the stanza to the user.")
    public void testPresenceApprovalStampedAndDelivered() throws Exception {
        IntegrationTestRosterUtil.ensureBothAccountsAreNotInEachOthersRoster(this.conOne, this.conTwo);
        this.rosterTwo.setSubscriptionMode(Roster.SubscriptionMode.accept_all);
        Consumer interceptor = presenceBuilder -> ((PresenceBuilder)presenceBuilder.to((Jid)this.conOne.getUser())).build();
        this.conTwo.addPresenceInterceptor(interceptor, p -> p.getType() == Presence.Type.subscribed);
        ResultSyncPoint added = new ResultSyncPoint();
        StanzaListener stanzaListener = stanza -> added.signal((Presence)stanza);
        this.conOne.addAsyncStanzaListener(stanzaListener, (StanzaFilter)PresenceTypeFilter.SUBSCRIBED);
        Presence subscribe = ((PresenceBuilder)this.conOne.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.subscribe).to((Jid)this.conTwo.getUser().asBareJid())).build();
        try {
            this.conOne.sendStanza((Stanza)subscribe);
            Presence received = (Presence)this.assertResult(added, "Expected presence 'subscribed' stanza to be delivered to '" + String.valueOf(this.conOne.getUser()) + "' after '" + String.valueOf(this.conTwo.getUser()) + "' approved their subscription request (but it was not).");
            Assertions.assertEquals((Object)this.conTwo.getUser().asBareJid(), (Object)received.getFrom().asEntityBareJidOrThrow(), (String)("Expected presence 'subscribed' stanza that was delivered to '" + String.valueOf(this.conOne.getUser()) + "' after '" + String.valueOf(this.conTwo.getUser()) + "' approved their subscription request to have a 'from' attribute value that is associated to '" + String.valueOf(this.conTwo.getUser().getLocalpart()) + "' (but it did not)."));
            Assertions.assertTrue((boolean)received.getFrom().isEntityBareJid(), (String)("Expected presence 'subscribed' stanza that was delivered to '" + String.valueOf(this.conOne.getUser()) + "' after '" + String.valueOf(this.conTwo.getUser()) + "' approved their subscription request to have a 'from' attribute value that is a bare JID (but it was not)."));
        }
        finally {
            this.rosterTwo.setSubscriptionMode(Roster.getDefaultSubscriptionMode());
            this.conTwo.removePresenceInterceptor(interceptor);
            this.conOne.removeAsyncStanzaListener(stanzaListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="3.1.5", quote="The contact's server then MUST send an updated roster push to all of the contact's interested resources, with the 'subscription' attribute set to a value of \"from\".")
    public void testPresenceApprovalYieldsRosterPush() throws Exception {
        IntegrationTestRosterUtil.ensureBothAccountsAreNotInEachOthersRoster(this.conOne, this.conTwo);
        this.rosterTwo.setSubscriptionMode(Roster.SubscriptionMode.accept_all);
        final ResultSyncPoint updated = new ResultSyncPoint();
        AbstractRosterListener rosterListener = new AbstractRosterListener(){

            public void entriesAdded(Collection<Jid> addresses) {
                for (Jid jid : addresses) {
                    if (!jid.equals((CharSequence)RosterIntegrationTest.this.conOne.getUser().asBareJid())) continue;
                    BareJid bareJid = RosterIntegrationTest.this.conOne.getUser().asBareJid();
                    RosterEntry rosterEntry = RosterIntegrationTest.this.rosterTwo.getEntry(bareJid);
                    updated.signal(rosterEntry);
                }
            }
        };
        this.rosterTwo.addRosterListener((RosterListener)rosterListener);
        Presence subscribe = ((PresenceBuilder)this.conOne.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.subscribe).to((Jid)this.conTwo.getUser().asBareJid())).build();
        try {
            this.conOne.sendStanza((Stanza)subscribe);
            RosterEntry entry = (RosterEntry)this.assertResult(updated, "Expected '" + String.valueOf(this.conTwo.getUser()) + "' to receive a roster push with an update for the entry of '" + String.valueOf(this.conOne.getUser().asBareJid()) + "' after '" + String.valueOf(this.conTwo.getUser()) + "' approved their subscription request.");
            Assertions.assertEquals((Object)RosterPacket.ItemType.from, (Object)entry.getType(), (String)("Unexpected type for '" + String.valueOf(this.conOne.getUser().asBareJid()) + "''s entry in '" + String.valueOf(this.conTwo.getUser().asBareJid()) + "''s roster."));
        }
        finally {
            this.rosterTwo.setSubscriptionMode(Roster.getDefaultSubscriptionMode());
            this.rosterTwo.removeRosterListener((RosterListener)rosterListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="3.1.5", quote="The contact's server then MUST send an updated roster push to all of the contact's interested resources, with the 'subscription' attribute set to a value of \"from\". (Here we assume that the contact does not already have a subscription to the user; if that were the case, the 'subscription' attribute would be set to a value of \"both\", as explained under Appendix A.)")
    public void testPresenceApprovalYieldsRosterPush2() throws Exception {
        IntegrationTestRosterUtil.ensureBothAccountsAreNotInEachOthersRoster(this.conOne, this.conTwo);
        this.rosterOne.setSubscriptionMode(Roster.SubscriptionMode.accept_all);
        final SimpleResultSyncPoint fixtureComplete = new SimpleResultSyncPoint();
        AbstractRosterListener rosterListenerTwo = new AbstractRosterListener(){

            public void entriesAdded(Collection<Jid> addresses) {
                this.checkIfAdded(addresses);
            }

            public void entriesUpdated(Collection<Jid> addresses) {
                this.checkIfAdded(addresses);
            }

            private void checkIfAdded(Collection<Jid> addresses) {
                for (Jid jid : addresses) {
                    BareJid bareJid;
                    if (!jid.equals((CharSequence)(bareJid = RosterIntegrationTest.this.conOne.getUser().asBareJid())) || RosterIntegrationTest.this.rosterTwo.getEntry(bareJid) == null || RosterIntegrationTest.this.rosterTwo.getEntry(bareJid).getType() == RosterPacket.ItemType.none) continue;
                    fixtureComplete.signal();
                    RosterIntegrationTest.this.rosterTwo.removeRosterListener((RosterListener)this);
                }
            }
        };
        this.rosterTwo.addRosterListener((RosterListener)rosterListenerTwo);
        Presence subscribeOne = ((PresenceBuilder)this.conTwo.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.subscribe).to((Jid)this.conOne.getUser().asBareJid())).build();
        try {
            this.conTwo.sendStanza((Stanza)subscribeOne);
            fixtureComplete.waitForResult(this.connection.getReplyTimeout());
        }
        finally {
            this.rosterOne.setSubscriptionMode(Roster.getDefaultSubscriptionMode());
            this.rosterTwo.removeRosterListener((RosterListener)rosterListenerTwo);
        }
        this.rosterTwo.setSubscriptionMode(Roster.SubscriptionMode.accept_all);
        final ResultSyncPoint updated = new ResultSyncPoint();
        rosterListenerTwo = new AbstractRosterListener(){

            public void entriesUpdated(Collection<Jid> addresses) {
                for (Jid jid : addresses) {
                    if (!jid.equals((CharSequence)RosterIntegrationTest.this.conOne.getUser().asBareJid())) continue;
                    BareJid bareJid = RosterIntegrationTest.this.conOne.getUser().asBareJid();
                    updated.signal(RosterIntegrationTest.this.rosterTwo.getEntry(bareJid));
                }
            }
        };
        this.rosterTwo.addRosterListener((RosterListener)rosterListenerTwo);
        Presence subscribeTwo = ((PresenceBuilder)this.conOne.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.subscribe).to((Jid)this.conTwo.getUser().asBareJid())).build();
        try {
            this.conOne.sendStanza((Stanza)subscribeTwo);
            RosterEntry entry = (RosterEntry)this.assertResult(updated, "Expected '" + String.valueOf(this.conTwo.getUser()) + "' to receive a roster push with an update for the entry of '" + String.valueOf(this.conOne.getUser().asBareJid()) + "' after '" + String.valueOf(this.conOne.getUser()) + "' approved their subscription request.");
            Assertions.assertEquals((Object)RosterPacket.ItemType.both, (Object)entry.getType(), (String)("Unexpected type for '" + String.valueOf(this.conOne.getUser().asBareJid()) + "''s entry in '" + String.valueOf(this.conTwo.getUser().asBareJid()) + "''s roster."));
        }
        finally {
            this.rosterTwo.setSubscriptionMode(Roster.getDefaultSubscriptionMode());
            this.rosterTwo.removeRosterListener((RosterListener)rosterListenerTwo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="3.1.5", quote="The contact's server MUST then also send current presence to the user from each of the contact's available resources.")
    public void testCurrentPresenceSentAfterSubscriptionApproval() throws Exception {
        IntegrationTestRosterUtil.ensureBothAccountsAreNotInEachOthersRoster(this.conOne, this.conTwo);
        String needle = "Look for me!";
        this.conTwo.sendStanza((Stanza)this.conTwo.getStanzaFactory().buildPresenceStanza().setStatus("Look for me!").build());
        this.rosterTwo.setSubscriptionMode(Roster.SubscriptionMode.accept_all);
        SimpleResultSyncPoint received = new SimpleResultSyncPoint();
        StanzaListener stanzaListener = stanza -> {
            Presence presence = (Presence)stanza;
            String status = presence.getStatus();
            if (status == null) {
                return;
            }
            if (status.equals("Look for me!")) {
                received.signal();
            }
        };
        this.conOne.addAsyncStanzaListener(stanzaListener, (StanzaFilter)new AndFilter(new StanzaFilter[]{StanzaTypeFilter.PRESENCE, FromMatchesFilter.createBare((Jid)this.conTwo.getUser())}));
        Presence subscribe = ((PresenceBuilder)this.conOne.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.subscribe).to((Jid)this.conTwo.getUser().asBareJid())).build();
        try {
            this.conOne.sendStanza((Stanza)subscribe);
            this.assertResult(received, "Expected '" + String.valueOf(this.conTwo.getUser()) + "' to receive '" + String.valueOf(this.conOne.getUser()) + "''s current presence update (including the status 'Look for me!'), but it did not.");
        }
        finally {
            this.rosterTwo.setSubscriptionMode(Roster.getDefaultSubscriptionMode());
            this.conOne.removeAsyncStanzaListener(stanzaListener);
        }
    }
}

