/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.softwareInfo;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.annotations.AfterClass;
import org.igniterealtime.smack.inttest.annotations.BeforeClass;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.igniterealtime.smack.inttest.util.IntegrationTestRosterUtil;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.mediaelement.element.MediaElement;
import org.jivesoftware.smackx.softwareinfo.SoftwareInfoManager;
import org.jivesoftware.smackx.softwareinfo.form.SoftwareInfoForm;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.Jid;

@SpecificationReference(document="XEP-0232", version="0.3")
public class SoftwareInfoIntegrationTest
extends AbstractSmackIntegrationTest {
    public final SoftwareInfoManager sim1;
    public final SoftwareInfoManager sim2;

    public SoftwareInfoIntegrationTest(SmackIntegrationTestEnvironment environment) throws IOException, XmlPullParserException, SmackParsingException {
        super(environment);
        this.sim1 = SoftwareInfoManager.getInstanceFor((XMPPConnection)this.conOne);
        this.sim2 = SoftwareInfoManager.getInstanceFor((XMPPConnection)this.conTwo);
    }

    @BeforeClass
    public void setUp() throws Exception {
        IntegrationTestRosterUtil.ensureBothAccountsAreSubscribedToEachOther(this.conOne, this.conTwo, this.timeout);
    }

    @AfterClass
    public void cleanUp() throws Exception {
        IntegrationTestRosterUtil.ensureBothAccountsAreNotInEachOthersRoster(this.conOne, this.conTwo);
    }

    @SmackIntegrationTest
    public void test() throws Exception {
        final SoftwareInfoForm softwareInfoSent = SoftwareInfoIntegrationTest.createSoftwareInfoForm();
        this.performActionAndWaitForPresence(this.conTwo, this.conOne, new Async.ThrowingRunnable(){

            public void runOrThrow() throws Exception {
                SoftwareInfoIntegrationTest.this.sim1.publishSoftwareInformationForm(softwareInfoSent);
            }
        });
        SoftwareInfoForm softwareInfoFormReceived = this.sim2.fromJid((Jid)this.conOne.getUser());
        Assertions.assertEquals((Object)softwareInfoSent, (Object)softwareInfoFormReceived, (String)("Expected " + String.valueOf(this.conOne.getUser()) + "'s software version info as received by " + String.valueOf(this.conTwo.getUser()) + " to be equal to what " + String.valueOf(this.conOne.getUser()) + " publishes (but it is not)."));
    }

    private static SoftwareInfoForm createSoftwareInfoForm() throws URISyntaxException {
        SoftwareInfoForm.Builder builder = SoftwareInfoForm.getBuilder();
        MediaElement mediaElement = MediaElement.builder().addUri(new MediaElement.Uri(new URI("http://example.org"), "test-type")).setHeightAndWidth(16, 16).build();
        SoftwareInfoForm softwareInfoForm = builder.setIcon(mediaElement).setOS("Linux").setOSVersion("Debian").setSoftware("Gajim").setSoftwareVersion("1.4.0").build();
        return softwareInfoForm;
    }
}

