/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.muc.AbstractMultiUserChatIntegrationTest;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;

@SpecificationReference(document="XEP-0045", version="1.34.6")
public class UserStatusIntegrationTest
extends AbstractMultiUserChatIntegrationTest {
    public UserStatusIntegrationTest(SmackIntegrationTestEnvironment environment) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException, MultiUserChatException.MucAlreadyJoinedException, MultiUserChatException.MissingMucCreationAcknowledgeException, XmppStringprepException, MultiUserChatException.NotAMucServiceException {
        super(environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="9.4", quote="An admin might want to revoke a user's membership [...] The service MUST then send updated presence from this individual to all occupants, indicating the loss of membership by sending a presence element that contains an <x/> element qualified by the 'http://jabber.org/protocol/muc#user' namespace and containing an <item/> child with the 'affiliation' attribute set to a value of \"none\".")
    public void testMembershipRevokedInOpenRoom() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-userstatus-membership-revoked-membersonly");
        MultiUserChat mucAsSeenByOwner = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTarget = this.mucManagerTwo.getMultiUserChat(mucAddress);
        EntityFullJid mucAddressOwner = JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)Resourcepart.from((String)("owner-" + this.randomString)));
        EntityFullJid mucAddressTarget = JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)Resourcepart.from((String)("target-" + this.randomString)));
        UserStatusIntegrationTest.createMuc(mucAsSeenByOwner, mucAddressOwner.getResourcepart());
        try {
            mucAsSeenByOwner.grantMembership(this.conTwo.getUser().asBareJid());
            mucAsSeenByTarget.join(mucAddressTarget.getResourcepart());
            final SimpleResultSyncPoint targetSeesRevoke = new SimpleResultSyncPoint();
            mucAsSeenByTarget.addUserStatusListener(new UserStatusListener(){

                public void membershipRevoked() {
                    targetSeesRevoke.signal();
                }
            });
            mucAsSeenByOwner.revokeMembership(this.conTwo.getUser().asBareJid());
            this.assertResult(targetSeesRevoke, "Expected '" + String.valueOf(this.conTwo.getUser()) + "' (using nickname '" + String.valueOf(mucAddressTarget.getResourcepart()) + "') to be notified that their membership status was removed by '" + String.valueOf(this.conOne.getUser()) + "' (using nickname '" + String.valueOf(mucAddressOwner.getResourcepart()) + "') in '" + String.valueOf(mucAddress) + "' (but did not).");
        }
        finally {
            UserStatusIntegrationTest.tryDestroy(mucAsSeenByOwner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="9.4", quote="An admin might want to revoke a user's membership [...] If the room is members-only, the service MUST remove the user from the room, including a status code of 321 to indicate that the user was removed because of an affiliation change, and inform all remaining occupants")
    public void testMembershipRevokedInMemberOnlyRoom() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("smack-inttest-userstatus-membership-revoked-membersonly");
        MultiUserChat mucAsSeenByOwner = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTarget = this.mucManagerTwo.getMultiUserChat(mucAddress);
        EntityFullJid mucAddressOwner = JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)Resourcepart.from((String)("owner-" + this.randomString)));
        EntityFullJid mucAddressTarget = JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)Resourcepart.from((String)("target-" + this.randomString)));
        UserStatusIntegrationTest.createMembersOnlyMuc(mucAsSeenByOwner, mucAddressOwner.getResourcepart());
        try {
            mucAsSeenByOwner.grantMembership(this.conTwo.getUser().asBareJid());
            mucAsSeenByTarget.join(mucAddressTarget.getResourcepart());
            final SimpleResultSyncPoint targetSeesRevoke = new SimpleResultSyncPoint();
            final SimpleResultSyncPoint targetSeesRemove = new SimpleResultSyncPoint();
            mucAsSeenByTarget.addUserStatusListener(new UserStatusListener(){

                public void removed(MUCUser mucUser, Presence presence) {
                    targetSeesRemove.signal();
                }

                public void membershipRevoked() {
                    targetSeesRevoke.signal();
                }
            });
            mucAsSeenByOwner.revokeMembership(this.conTwo.getUser().asBareJid());
            this.assertResult(targetSeesRemove, "Expected '" + String.valueOf(this.conTwo.getUser()) + "' (using nickname '" + String.valueOf(mucAddressTarget.getResourcepart()) + "') to be notified that it is removed from '" + String.valueOf(mucAddress) + "' which is a member-only room, as their membership status was removed by '" + String.valueOf(this.conOne.getUser()) + "' (using nickname '" + String.valueOf(mucAddressOwner.getResourcepart()) + "') (but did not).");
            this.assertResult(targetSeesRevoke, "Expected '" + String.valueOf(this.conTwo.getUser()) + "' (using nickname '" + String.valueOf(mucAddressTarget.getResourcepart()) + "') to be notified that their membership status was removed by '" + String.valueOf(this.conOne.getUser()) + "' (using nickname '" + String.valueOf(mucAddressOwner.getResourcepart()) + "') in '" + String.valueOf(mucAddress) + "' (but did not).");
        }
        finally {
            UserStatusIntegrationTest.tryDestroy(mucAsSeenByOwner);
        }
    }
}

